/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.encode.StringEditor;
import groove.grammar.Grammar;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EncodedHostName
implements EncodedType<String, String> {
    @Override
    public EncodedTypeEditor<String, String> createEditor(GrammarModel grammar) {
        return new StringEditor<String>(grammar, "", 20);
    }

    @Override
    public String parse(Grammar rules, String source) throws FormatException {
        Pattern pattern = Pattern.compile("^https?\\://[a-zA-Z0-9\\-\\.]+(\\.[a-zA-Z]{2,3})?\\:[0-9]{4}(/\\S*)?$");
        Matcher matcher = pattern.matcher(source);
        if (!matcher.find()) {
            throw new FormatException("Bad host name '%s': %s", source, "Should match pattern: " + pattern.toString());
        }
        return source;
    }
}

