/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.ParsableValue;
import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.explore.encode.Serialized;
import groove.explore.encode.TemplateListener;
import groove.explore.prettyparse.SerializedParser;
import groove.explore.prettyparse.StringConsumer;
import groove.grammar.Grammar;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.gui.dialog.ExplorationDialog;
import groove.gui.layout.SpringUtilities;
import groove.io.HTMLConverter;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public abstract class Template<A>
implements EncodedType<A, Serialized> {
    private final ParsableValue value;
    private Visibility visibility = Visibility.ALL;
    private final SerializedParser commandlineParser;
    private final String[] argumentNames;
    private final Map<String, EncodedType<?, String>> argumentTypes;
    private static final HTMLConverter.HTMLTag INFO_FONT = new HTMLConverter.HTMLTag("FONT", "color", "#005050");

    public Template(ParsableValue value, SerializedParser commandlineParser, String ... argumentNames) {
        this.value = value;
        this.commandlineParser = commandlineParser;
        this.argumentNames = argumentNames;
        this.argumentTypes = new TreeMap();
    }

    public void setArgumentType(String name, EncodedType<?, String> type) {
        this.argumentTypes.put(name, type);
    }

    public ParsableValue getValue() {
        return this.value;
    }

    public String getKeyword() {
        return this.getValue().getKeyword();
    }

    public String getName() {
        return this.getValue().getName();
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public String toString() {
        return "Template for " + this.value.toString();
    }

    public abstract Serialized toSerialized(Object ... var1);

    @Override
    public EncodedTypeEditor<A, Serialized> createEditor(GrammarModel grammar) {
        return new TemplateEditor(grammar);
    }

    String argumentError(String argName) {
        return "Unable to parse the " + argName + " argument of " + this.getKeyword() + ".";
    }

    Serialized parseCommandline(String text) {
        StringConsumer stream = new StringConsumer(text);
        if (!stream.consumeLiteral(this.getKeyword())) {
            return null;
        }
        Serialized result = new Serialized(this.getKeyword());
        if (this.argumentNames.length == 0) {
            if (stream.isEmpty()) {
                return result;
            }
            return null;
        }
        if (!stream.consumeLiteral(":")) {
            return null;
        }
        if (!this.commandlineParser.parse(stream, result)) {
            return null;
        }
        return result;
    }

    String describeCommandlineGrammar() {
        StringBuffer desc = new StringBuffer();
        desc.append(this.getKeyword());
        if (this.argumentNames.length != 0) {
            desc.append(":");
            desc.append(this.commandlineParser.describeGrammar());
        }
        desc.append(" - ");
        desc.append(this.getName());
        return desc.toString();
    }

    public static abstract class Template0<X>
    extends Template<X> {
        public Template0(ParsableValue value) {
            super(value, null, new String[0]);
        }

        @Override
        public X parse(Grammar rules, Serialized source) throws FormatException {
            if (!source.getKeyword().equals(this.getKeyword())) {
                throw new FormatException("Type mismatch between '" + source.getKeyword() + "' and '" + this.getKeyword() + "'.", new Object[0]);
            }
            return this.create();
        }

        @Override
        public Serialized toSerialized(Object ... args) {
            assert (args.length == 0);
            return this.getValue().toSerialized();
        }

        public abstract X create();
    }

    public static abstract class Template1<X, P1>
    extends Template<X> {
        private final EncodedType<P1, String> type1;
        private final String name1;

        public Template1(ParsableValue value, SerializedParser commandlineParser, String arg1Name, EncodedType<P1, String> arg1Type) {
            super(value, commandlineParser, arg1Name);
            this.type1 = arg1Type;
            this.name1 = arg1Name;
            this.setArgumentType(arg1Name, arg1Type);
        }

        @Override
        public X parse(Grammar rules, Serialized source) throws FormatException {
            P1 v1;
            if (!source.getKeyword().equals(this.getKeyword())) {
                throw new FormatException("Type mismatch between '" + source.getKeyword() + "' and '" + this.getKeyword() + "'.", new Object[0]);
            }
            try {
                v1 = this.type1.parse(rules, source.getArgument(this.name1));
            }
            catch (FormatException exc) {
                exc.insert(new FormatException(this.argumentError(this.name1), new Object[0]));
                throw exc;
            }
            return this.create(v1);
        }

        @Override
        public Serialized toSerialized(Object ... args) {
            assert (args.length == 1);
            Serialized result = this.getValue().toSerialized();
            result.setArgument(this.name1, args[0].toString());
            return result;
        }

        public abstract X create(P1 var1);
    }

    public static abstract class Template2<X, P1, P2>
    extends Template<X> {
        private final EncodedType<P1, String> type1;
        private final String name1;
        private final EncodedType<P2, String> type2;
        private final String name2;

        public Template2(ParsableValue value, SerializedParser commandlineParser, String arg1Name, EncodedType<P1, String> arg1Type, String arg2Name, EncodedType<P2, String> arg2Type) {
            super(value, commandlineParser, arg1Name, arg2Name);
            this.type1 = arg1Type;
            this.name1 = arg1Name;
            this.setArgumentType(arg1Name, arg1Type);
            this.type2 = arg2Type;
            this.name2 = arg2Name;
            this.setArgumentType(arg2Name, arg2Type);
        }

        @Override
        public X parse(Grammar rules, Serialized source) throws FormatException {
            P2 v2;
            P1 v1;
            if (!source.getKeyword().equals(this.getKeyword())) {
                throw new FormatException("Type mismatch between '" + source.getKeyword() + "' and '" + this.getKeyword() + "'.", new Object[0]);
            }
            try {
                v1 = this.type1.parse(rules, source.getArgument(this.name1));
            }
            catch (FormatException exc) {
                exc.insert(new FormatException(this.argumentError(this.name1), new Object[0]));
                throw exc;
            }
            try {
                v2 = this.type2.parse(rules, source.getArgument(this.name2));
            }
            catch (FormatException exc) {
                exc.insert(new FormatException(this.argumentError(this.name2), new Object[0]));
                throw exc;
            }
            return this.create(v1, v2);
        }

        @Override
        public Serialized toSerialized(Object ... args) {
            assert (args.length == 2);
            Serialized result = this.getValue().toSerialized();
            result.setArgument(this.name1, args[0].toString());
            result.setArgument(this.name2, args[1].toString());
            return result;
        }

        public abstract X create(P1 var1, P2 var2);
    }

    private class TemplateEditor<X>
    extends EncodedTypeEditor<X, Serialized> {
        private final Map<String, EncodedTypeEditor<?, String>> editors;

        public TemplateEditor(GrammarModel grammar) {
            super(grammar, new SpringLayout());
            this.editors = new TreeMap();
            this.setBackground(ExplorationDialog.INFO_BG_COLOR);
            this.addName();
            this.addExplanation();
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            this.addKeyword();
            this.addNrArguments();
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            String[] stringArray = Template.this.argumentNames;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String argName = stringArray[n2];
                this.addArgument(argName);
                ++n2;
            }
            this.add(Box.createRigidArea(new Dimension(0, 400)));
            SpringUtilities.makeCompactGrid(this, 7 + Template.this.argumentNames.length, 1, 2, 2, 0, 0);
            this.refresh();
        }

        @Override
        public void refresh() {
            for (EncodedTypeEditor<?, String> editor : this.editors.values()) {
                editor.refresh();
            }
        }

        private void addName() {
            this.add(new JLabel("<HTML><B><U><FONT color=#005050>" + Template.this.getName() + ":</FONT></U></B></HTML>"));
        }

        private void addExplanation() {
            StringBuilder text = new StringBuilder();
            text.append(Template.this.getValue().getDescription());
            INFO_FONT.on(text);
            HTMLConverter.HTML_TAG.on(text);
            this.add(new JLabel(text.toString()));
        }

        private void addKeyword() {
            StringBuilder text = new StringBuilder();
            text.append("Keyword for commandline: ");
            text.append(HTMLConverter.STRONG_TAG.on(Template.this.getKeyword()));
            text.append('.');
            INFO_FONT.on(text);
            HTMLConverter.HTML_TAG.on(text);
            this.add(new JLabel(text.toString()));
        }

        private void addNrArguments() {
            this.add(new JLabel("<HTML><FONT color=#005050>Additional arguments: <B>" + Integer.toString(Template.this.argumentNames.length) + "</B>" + (Template.this.argumentNames.length == 0 ? "." : " (select values below).") + "</FONT></HTML>"));
        }

        private void addArgument(String argName) {
            EncodedTypeEditor editor = ((EncodedType)Template.this.argumentTypes.get(argName)).createEditor(this.getGrammar());
            JPanel line = new JPanel(new FlowLayout(0, 0, 0));
            line.setBackground(ExplorationDialog.INFO_BG_COLOR);
            if (editor != null) {
                this.editors.put(argName, editor);
                line.add(editor);
            }
            line.add(Box.createRigidArea(new Dimension(5, 0)));
            line.add(new JLabel("<HTML><B><FONT color=#005050>(" + argName + ")</B></HTML>"));
            this.add(line);
        }

        @Override
        public Serialized getCurrentValue() {
            Serialized value = new Serialized(Template.this.getKeyword());
            for (Map.Entry<String, EncodedTypeEditor<?, String>> entry : this.editors.entrySet()) {
                String argValue = entry.getValue().getCurrentValue();
                if (argValue == null) {
                    return null;
                }
                value.setArgument(entry.getKey(), argValue);
            }
            return value;
        }

        @Override
        public void setCurrentValue(Serialized value) {
            if (!value.getKeyword().equals(Template.this.getKeyword())) {
                return;
            }
            String[] stringArray = Template.this.argumentNames;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String argName = stringArray[n2];
                this.editors.get(argName).setCurrentValue(value.getArgument(argName));
                ++n2;
            }
        }

        @Override
        public void addTemplateListener(TemplateListener listener) {
            super.addTemplateListener(listener);
            for (EncodedTypeEditor<?, String> editor : this.editors.values()) {
                editor.addTemplateListener(listener);
            }
        }

        @Override
        public void removeTemplateListener(TemplateListener listener) {
            for (EncodedTypeEditor<?, String> editor : this.editors.values()) {
                editor.removeTemplateListener(listener);
            }
            super.removeTemplateListener(listener);
        }
    }

    public static enum Visibility {
        ALL,
        DEVELOPMENT_ONLY;

    }
}

