/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.result;

import groove.grammar.Rule;
import groove.lts.GraphState;
import groove.lts.RuleTransition;

public abstract class Predicate<A> {
    public final boolean statePredicate;
    public final boolean transitionPredicate;

    public Predicate(boolean statePredicate, boolean transitionPredicate) {
        this.statePredicate = statePredicate;
        this.transitionPredicate = transitionPredicate;
    }

    public Predicate() {
        this(false, false);
    }

    public abstract boolean eval(A var1);

    public static class And<X>
    extends Predicate<X> {
        private final Predicate<X> P;
        private final Predicate<X> Q;

        public And(Predicate<X> P, Predicate<X> Q) {
            super(P.statePredicate, P.transitionPredicate);
            this.P = P;
            this.Q = Q;
        }

        @Override
        public boolean eval(X value) {
            return this.P.eval(value) && this.Q.eval(value);
        }
    }

    public static class Implies<X>
    extends Predicate<X> {
        private final Predicate<X> P;
        private final Predicate<X> Q;

        public Implies(Predicate<X> P, Predicate<X> Q) {
            super(P.statePredicate, P.transitionPredicate);
            this.P = P;
            this.Q = Q;
        }

        @Override
        public boolean eval(X value) {
            if (this.P.eval(value)) {
                return this.Q.eval(value);
            }
            return true;
        }
    }

    public static class Not<X>
    extends Predicate<X> {
        private final Predicate<X> P;

        public Not(Predicate<X> P) {
            super(P.statePredicate, P.transitionPredicate);
            this.P = P;
        }

        @Override
        public boolean eval(X value) {
            return !this.P.eval(value);
        }
    }

    public static class Or<X>
    extends Predicate<X> {
        private final Predicate<X> P;
        private final Predicate<X> Q;

        public Or(Predicate<X> P, Predicate<X> Q) {
            super(P.statePredicate, P.transitionPredicate);
            this.P = P;
            this.Q = Q;
        }

        @Override
        public boolean eval(X value) {
            return this.P.eval(value) || this.Q.eval(value);
        }
    }

    public static class RuleApplicable
    extends Predicate<GraphState> {
        private final Rule rule;

        public RuleApplicable(Rule rule) {
            super(true, false);
            this.rule = rule;
        }

        @Override
        public boolean eval(GraphState value) {
            return this.rule.hasMatch(value.getGraph());
        }
    }

    public static class RuleApplied
    extends Predicate<RuleTransition> {
        private final Rule rule;

        public RuleApplied(Rule rule) {
            super(false, true);
            this.rule = rule;
        }

        @Override
        public boolean eval(RuleTransition value) {
            return value.getEvent().getRule().equals(this.rule);
        }
    }
}

