/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.result.Acceptor;
import groove.explore.strategy.GTSStrategy;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import java.util.List;
import java.util.Stack;

public abstract class ClosingStrategy
extends GTSStrategy {
    private final ExploreListener exploreListener = new ExploreListener();
    private final Stack<GraphState> transientStack = new Stack();

    @Override
    public GraphState doNext() {
        GraphState state = this.getNextState();
        List<MatchResult> matches = state.getMatches();
        if (!state.getSchedule().isFinished()) {
            assert (!state.isTransient());
            this.putInPool(state);
        }
        if (state.setFlag(GraphState.Flag.KNOWN, false)) {
            for (RuleTransition out : state.getRuleTransitions()) {
                GraphState target = out.target();
                if (!target.hasFlag(GraphState.Flag.KNOWN)) continue;
                this.addExplorable(target);
            }
        }
        for (MatchResult next : matches) {
            state.applyMatch(next);
        }
        this.setNextState();
        return state;
    }

    @Override
    public void prepare(GTS gts, GraphState state, Acceptor acceptor) {
        super.prepare(gts, state, acceptor);
        gts.addLTSListener(this.exploreListener);
        this.clearPool();
    }

    @Override
    public void finish() {
        super.finish();
        this.getGTS().removeLTSListener(this.exploreListener);
    }

    @Override
    protected GraphState computeNextState() {
        if (this.transientStack.isEmpty()) {
            return this.getFromPool();
        }
        return this.transientStack.pop();
    }

    private void addExplorable(GraphState state) {
        if (state.isTransient()) {
            this.transientStack.push(state);
        } else {
            this.putInPool(state);
        }
    }

    protected abstract GraphState getFromPool();

    protected abstract void putInPool(GraphState var1);

    protected abstract void clearPool();

    private class ExploreListener
    extends GTSAdapter {
        private ExploreListener() {
        }

        @Override
        public void addUpdate(GTS gts, GraphState state) {
            ClosingStrategy.this.addExplorable(state);
        }
    }
}

