/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.result.Acceptor;
import groove.explore.strategy.LinearStrategy;
import groove.lts.DefaultGraphNextState;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.match.MatcherFactory;
import groove.match.SearchEngine;
import groove.match.rete.ReteSearchEngine;
import groove.transform.DeltaStore;

public class ReteLinearStrategy
extends LinearStrategy {
    private SearchEngine oldEngine;
    private ReteSearchEngine rete;

    public ReteLinearStrategy() {
        this(false);
    }

    public ReteLinearStrategy(boolean closeFast) {
        super(closeFast);
    }

    @Override
    public void prepare(GTS gts, GraphState state, Acceptor acceptor) {
        super.prepare(gts, state, acceptor);
        this.rete = new ReteSearchEngine(this.getGTS().getGrammar());
        this.oldEngine = MatcherFactory.instance().getEngine();
        MatcherFactory.instance().setEngine(this.rete);
    }

    @Override
    protected GraphState computeNextState() {
        GraphState result = super.computeNextState();
        DeltaStore d = new DeltaStore();
        if (result != null) {
            ((DefaultGraphNextState)result).getDelta().applyDelta(d);
            this.rete.transitionOccurred(result.getGraph(), d);
        }
        return result;
    }

    @Override
    public void finish() {
        MatcherFactory.instance().setEngine(this.oldEngine);
        super.finish();
    }
}

