/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.algebra.AlgebraFamily;
import groove.control.CtrlPar;
import groove.control.CtrlType;
import groove.control.CtrlVar;
import groove.grammar.Action;
import groove.grammar.AnchorFactory;
import groove.grammar.Condition;
import groove.grammar.DefaultAnchorFactory;
import groove.grammar.GrammarProperties;
import groove.grammar.QualName;
import groove.grammar.host.HostEdgeSet;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.model.FormatException;
import groove.grammar.rule.Anchor;
import groove.grammar.rule.DefaultRuleNode;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.RuleToHostMap;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeGuard;
import groove.graph.AEdge;
import groove.graph.GraphProperties;
import groove.match.Matcher;
import groove.match.MatcherFactory;
import groove.match.SearchStrategy;
import groove.match.TreeMatch;
import groove.match.plan.PlanSearchStrategy;
import groove.transform.Proof;
import groove.util.Fixable;
import groove.util.Visitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Rule
implements Action,
Fixable {
    private boolean partial;
    private final Condition condition;
    private Rule parent;
    private Collection<Rule> subRules;
    private boolean hasMergers;
    private boolean hasMergersSet;
    private boolean hasNodeCreators;
    private boolean hasNodeCreatorsSet;
    private boolean hasEdgeCreators;
    private boolean hasEdgeCreatorsSet;
    private boolean hasNodeErasers;
    private boolean hasNodeErasersSet;
    private boolean hasEdgeErasers;
    private boolean hasEdgeErasersSet;
    private boolean modifying;
    private boolean modifyingSet;
    private RuleGraph lhs;
    private RuleGraph rhs;
    private final RuleGraph coRoot;
    private boolean checkDangling;
    private boolean fixed;
    private boolean fixing;
    private RuleGraph creatorGraph;
    private Set<RuleNode> creatorEnds;
    private DefaultRuleNode[] eraserNodes;
    private RuleEdge[] eraserEdges;
    private Anchor anchor;
    private Anchor seed;
    private RuleEdge[] eraserNonAnchorEdges;
    private Set<RuleNode> modifierEnds;
    private Set<LabelVar> modifierVars;
    private RuleNode[] isolatedNodes;
    private RuleNode[] creatorNodes;
    private RuleEdge[] creatorEdges;
    private RuleEdge[] simpleCreatorEdges;
    private Set<RuleEdge> complexCreatorEdges;
    private LabelVar[] creatorVars;
    private Set<RuleEdge> lhsMergers;
    private Set<RuleEdge> rhsMergers;
    private Map<RuleNode, RuleNode> lhsMergeMap;
    private Map<RuleNode, RuleNode> rhsMergeMap;
    private final Map<RuleNode, Color> colorMap = new HashMap<RuleNode, Color>();
    private int priority;
    private String transitionLabel;
    private String formatString;
    private List<CtrlPar.Var> sig;
    private int[] parBinding;
    private Set<RuleNode> hiddenPars;
    private Matcher matcher;
    private final Map<BitSet, Matcher> matcherMap = new HashMap<BitSet, Matcher>();
    private Matcher eventMatcher;
    private static AnchorFactory anchorFactory = DefaultAnchorFactory.getInstance();
    private static final boolean PRINT = false;

    public Rule(Condition condition, RuleGraph rhs, RuleGraph coRoot) {
        assert (condition.getTypeGraph().getFactory() == rhs.getFactory().getTypeFactory() && (coRoot == null || rhs.getFactory() == coRoot.getFactory()));
        this.condition = condition;
        this.coRoot = coRoot;
        this.lhs = condition.getPattern();
        this.rhs = rhs;
        assert (coRoot == null || this.rhs().nodeSet().containsAll(coRoot.nodeSet())) : String.format("RHS nodes %s do not contain all co-root values %s", this.rhs().nodeSet(), coRoot.nodeSet());
    }

    public Condition getCondition() {
        return this.condition;
    }

    public RuleGraph getRoot() {
        return this.getCondition().getRoot();
    }

    public TypeGraph getTypeGraph() {
        return this.getCondition().getTypeGraph();
    }

    @Override
    public String getFullName() {
        return this.getCondition().getName();
    }

    @Override
    public String getLastName() {
        return QualName.getLastName(this.getFullName());
    }

    public GrammarProperties getSystemProperties() {
        return this.getCondition().getSystemProperties();
    }

    public void setParent(Rule parent, int[] level) {
        this.testFixed(false);
        assert (this.getCoRoot() != null) : String.format("Sub-rule at level %s must have a non-trivial co-root map", Arrays.toString(level));
        if (parent != null) assert (parent.rhs().nodeSet().containsAll(this.getCoRoot().nodeSet())) : String.format("Rule '%s': Parent nodes %s do not contain all co-roots %s", this.getFullName(), parent.rhs().nodeSet(), this.getCoRoot().nodeSet());
        this.parent = parent;
    }

    public Rule getParent() {
        if (this.parent == null) {
            this.testFixed(true);
            this.parent = this;
        }
        return this.parent;
    }

    public void setProperties(GraphProperties properties) {
        this.testFixed(false);
        this.priority = Integer.parseInt(properties.getProperty(GraphProperties.Key.PRIORITY));
        this.transitionLabel = properties.getProperty(GraphProperties.Key.TRANSITION_LABEL);
        this.formatString = properties.getProperty(GraphProperties.Key.FORMAT);
    }

    public String getTransitionLabel() {
        String result = this.transitionLabel;
        if (result.isEmpty()) {
            result = this.getFullName();
        }
        return result;
    }

    public String getFormatString() {
        return this.formatString;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setCheckDangling(boolean checkDangling) {
        this.checkDangling = checkDangling;
    }

    public boolean isTop() {
        return this.getParent() == this;
    }

    public Action getTop() {
        if (this.isTop()) {
            return this;
        }
        return this.getParent().getTop();
    }

    Set<RuleNode> computeInputNodes() {
        HashSet<RuleNode> result = null;
        if (this.isTop()) {
            result = new HashSet<RuleNode>();
            for (CtrlPar.Var var : this.getSignature()) {
                if (!var.isInOnly()) continue;
                result.add(var.getRuleNode());
            }
        }
        return result;
    }

    public boolean hasSubRules() {
        assert (this.isFixed());
        return !this.getSubRules().isEmpty();
    }

    public void addSubRule(Rule subRule) {
        assert (!this.isFixed());
        assert (subRule.isFixed());
        this.getSubRules().add(subRule);
    }

    public Collection<Rule> getSubRules() {
        if (this.subRules == null) {
            this.subRules = new TreeSet<Rule>();
            for (Condition condition : this.getCondition().getSubConditions()) {
                for (Condition subCondition : condition.getSubConditions()) {
                    if (!subCondition.hasRule()) continue;
                    this.subRules.add(subCondition.getRule());
                }
            }
        }
        return this.subRules;
    }

    public void setSignature(List<CtrlPar.Var> sig, Set<RuleNode> hiddenPars) {
        assert (!this.isFixed());
        this.sig = sig;
        this.hiddenPars = hiddenPars;
        ArrayList<CtrlPar.Var> derivedSig = new ArrayList<CtrlPar.Var>();
        int i = 0;
        while (i < sig.size()) {
            RuleNode parNode = sig.get(i).getRuleNode();
            if (this.lhs.containsNode(parNode)) {
                this.condition.getRoot().addNode(parNode);
            }
            String parName = "arg" + i;
            CtrlType parType = sig.get(i).getType();
            CtrlVar var = new CtrlVar(parName, parType);
            boolean inOnly = sig.get(i).isInOnly();
            boolean outOnly = sig.get(i).isOutOnly();
            CtrlPar.Var par = !inOnly && !outOnly ? new CtrlPar.Var(var) : new CtrlPar.Var(var, inOnly);
            derivedSig.add(par);
            ++i;
        }
        assert (derivedSig.equals(sig)) : String.format("Declared signature %s differs from derived signature %s", sig, derivedSig);
    }

    @Override
    public List<CtrlPar.Var> getSignature() {
        assert (this.isFixed());
        if (this.sig == null) {
            this.sig = Collections.emptyList();
        }
        return this.sig;
    }

    public int getParBinding(int i) {
        if (this.parBinding == null) {
            this.parBinding = this.computeParBinding();
        }
        return this.parBinding[i];
    }

    private int[] computeParBinding() {
        int[] result = new int[this.sig.size()];
        int anchorSize = this.getAnchor().size();
        int i = 0;
        while (i < this.sig.size()) {
            int binding;
            CtrlPar.Var par = this.sig.get(i);
            RuleNode ruleNode = par.getRuleNode();
            if (par.isCreator()) {
                binding = Arrays.asList(this.getCreatorNodes()).indexOf(ruleNode) + anchorSize;
                assert (binding >= anchorSize);
            } else {
                binding = this.getAnchor().indexOf(ruleNode);
                assert (binding >= 0) : String.format("Node %s not in anchors %s", ruleNode, this.getAnchor());
            }
            result[i] = binding;
            ++i;
        }
        return result;
    }

    Set<RuleNode> getHiddenPars() {
        return this.hiddenPars;
    }

    public final boolean hasMatch(HostGraph host) {
        return this.condition.isGround() && this.getMatch(host, null) != null;
    }

    @Override
    public Action.Kind getKind() {
        return Action.Kind.RULE;
    }

    public Proof getMatch(HostGraph host, RuleToHostMap contextMap) {
        return (Proof)this.traverseMatches(host, contextMap, Visitor.newFinder(null));
    }

    public Collection<Proof> getAllMatches(HostGraph host, RuleToHostMap contextMap) {
        ArrayList<Proof> result = new ArrayList<Proof>();
        this.traverseMatches(host, contextMap, Visitor.newCollector(result));
        return result;
    }

    public <R> R traverseMatches(final HostGraph host, RuleToHostMap contextMap, final Visitor<Proof, R> visitor) {
        assert (this.isFixed());
        RuleToHostMap seedMap = contextMap == null ? host.getFactory().createRuleToHostMap() : contextMap;
        this.getMatcher(seedMap).traverse(host, contextMap, new Visitor<TreeMatch, R>(){

            @Override
            protected boolean process(TreeMatch match) {
                if (!$assertionsDisabled && !visitor.isContinue()) {
                    throw new AssertionError();
                }
                if (Rule.this.isValidPatternMap(host, match.getPatternMap())) {
                    match.traverseProofs(visitor);
                }
                return visitor.isContinue();
            }
        });
        return visitor.getResult();
    }

    public Matcher getEventMatcher() {
        if (this.eventMatcher == null) {
            this.eventMatcher = this.createMatcher(this.getAnchor());
        }
        return this.eventMatcher;
    }

    private SearchStrategy getMatcher(RuleToHostMap seedMap) {
        Matcher result;
        assert (this.isTop());
        if (this.getSignature().size() > 0) {
            int sigSize = this.getSignature().size();
            BitSet initPars = new BitSet(sigSize);
            int i = 0;
            while (i < sigSize) {
                initPars.set(i, seedMap.nodeMap().containsKey(this.getSignature().get(i).getRuleNode()));
                ++i;
            }
            result = this.matcherMap.get(initPars);
            if (result == null) {
                Anchor seed = new Anchor(seedMap.nodeMap().keySet());
                result = this.createMatcher(seed);
                this.matcherMap.put(initPars, result);
            }
        } else {
            result = this.getMatcher();
        }
        return result;
    }

    public Matcher getMatcher() {
        if (this.matcher == null) {
            this.matcher = this.createMatcher(this.getSeed());
        }
        return this.matcher;
    }

    private Matcher createMatcher(Anchor seed) {
        this.testFixed(true);
        return this.getMatcherFactory().createMatcher(this.getCondition(), seed);
    }

    private MatcherFactory getMatcherFactory() {
        return MatcherFactory.instance();
    }

    public boolean isValidPatternMap(HostGraph host, RuleToHostMap matchMap) {
        boolean result = true;
        if (this.checkDangling) {
            result = this.satisfiesDangling(host, matchMap);
        }
        return result;
    }

    private boolean satisfiesDangling(HostGraph host, RuleToHostMap match) {
        boolean result = true;
        DefaultRuleNode[] defaultRuleNodeArray = this.getEraserNodes();
        int n = defaultRuleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultRuleNode eraserNode = defaultRuleNodeArray[n2];
            HostNode erasedNode = (HostNode)match.getNode(eraserNode);
            HostEdgeSet danglingEdges = new HostEdgeSet(host.edgeSet(erasedNode));
            for (RuleEdge eraserEdge : this.lhs().edgeSet(eraserNode)) {
                boolean removed = danglingEdges.remove(match.getEdge(eraserEdge));
                assert (removed) : String.format("Match %s not present in incident edges %s", match.getEdge(eraserEdge), host.edgeSet(erasedNode));
            }
            if (!danglingEdges.isEmpty()) {
                result = false;
                break;
            }
            ++n2;
        }
        return result;
    }

    public RuleGraph lhs() {
        return this.lhs;
    }

    public RuleGraph rhs() {
        return this.rhs;
    }

    public void addColorMap(Map<RuleNode, Color> colorMap) {
        this.colorMap.putAll(colorMap);
    }

    public Map<RuleNode, Color> getColorMap() {
        return this.colorMap;
    }

    public Anchor getAnchor() {
        if (this.anchor == null) {
            this.anchor = anchorFactory.newAnchor(this);
        }
        return this.anchor;
    }

    public Anchor getSeed() {
        if (this.seed == null) {
            this.seed = new Anchor(this.getRoot());
        }
        return this.seed;
    }

    public String toString() {
        StringBuilder res = new StringBuilder(String.format("Rule %s; anchor %s%n", this.getFullName(), this.getAnchor()));
        res.append(this.getCondition().toString("    "));
        return res.toString();
    }

    @Override
    public int compareTo(Action other) {
        return this.getFullName().compareTo(other.getFullName());
    }

    @Override
    public boolean setFixed() throws FormatException {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result && !this.fixing) {
            this.fixing = true;
            this.fixed = true;
            this.getCondition().setFixed();
            Rule parent = this.parent;
            while (parent != null && parent != this) {
                parent.getColorMap().putAll(this.getColorMap());
                Rule rule = parent = parent == parent.parent ? null : parent.parent;
            }
            this.fixing = false;
        }
        return result;
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void testFixed(boolean value) throws IllegalStateException {
        if (this.isFixed() != value) {
            String message = value ? "Rule should be fixed" : "Rule should not be fixed";
            throw new IllegalStateException(message);
        }
    }

    public void checkCombatible(AlgebraFamily family) throws FormatException {
        if (!family.supportsSymbolic()) {
            this.getCondition().checkResolution();
        }
    }

    public final RuleNode[] getIsolatedNodes() {
        if (this.isolatedNodes == null) {
            this.isolatedNodes = this.computeIsolatedNodes();
        }
        return this.isolatedNodes;
    }

    private RuleNode[] computeIsolatedNodes() {
        this.testFixed(true);
        HashSet<RuleNode> result = new HashSet<RuleNode>();
        for (RuleNode node : this.lhs().nodeSet()) {
            if (!this.lhs().edgeSet(node).isEmpty()) continue;
            result.add(node);
        }
        result.removeAll(this.condition.getRoot().nodeSet());
        return result.toArray(new RuleNode[result.size()]);
    }

    public final boolean hasMergers() {
        if (!this.hasMergersSet) {
            this.hasMergers = this.computeHasMergers();
            this.hasMergersSet = true;
        }
        return this.hasMergers;
    }

    private boolean computeHasMergers() {
        boolean result;
        boolean bl = result = !this.getLhsMergeMap().isEmpty() || !this.getRhsMergeMap().isEmpty();
        if (!result) {
            for (Rule subRule : this.getSubRules()) {
                result = subRule.hasMergers();
                if (result) break;
            }
        }
        return result;
    }

    public boolean isModifying() {
        if (!this.modifyingSet) {
            this.modifying = this.computeIsModifying();
            this.modifyingSet = true;
        }
        return this.modifying;
    }

    private boolean computeIsModifying() {
        boolean result;
        boolean bl = result = this.getEraserEdges().length > 0 || this.getEraserNodes().length > 0 || this.hasMergers() || this.hasNodeCreators() || this.hasEdgeCreators() || !this.getColorMap().isEmpty();
        if (!result) {
            for (Rule subRule : this.getSubRules()) {
                result = subRule.isModifying();
                if (result) break;
            }
        }
        return result;
    }

    public boolean hasNodeCreators() {
        if (!this.hasNodeCreatorsSet) {
            this.hasNodeCreators = this.computeHasNodeCreators();
            this.hasNodeCreatorsSet = true;
        }
        return this.hasNodeCreators;
    }

    private boolean computeHasNodeCreators() {
        boolean result;
        boolean bl = result = this.getCreatorNodes().length > 0;
        if (!result) {
            for (Rule subRule : this.getSubRules()) {
                result = subRule.hasNodeCreators();
                if (result) break;
            }
        }
        return result;
    }

    public boolean hasEdgeCreators() {
        if (!this.hasEdgeCreatorsSet) {
            this.hasEdgeCreators = this.computeHasEdgeCreators();
            this.hasEdgeCreatorsSet = true;
        }
        return this.hasEdgeCreators;
    }

    private boolean computeHasEdgeCreators() {
        boolean result;
        boolean bl = result = this.getCreatorEdges().length > 0;
        if (!result) {
            for (Rule subRule : this.getSubRules()) {
                result = subRule.hasEdgeCreators();
                if (result) break;
            }
        }
        return result;
    }

    public boolean hasNodeErasers() {
        if (!this.hasNodeErasersSet) {
            this.hasNodeErasers = this.computeHasNodeErasers();
            this.hasNodeErasersSet = true;
        }
        return this.hasNodeErasers;
    }

    private boolean computeHasNodeErasers() {
        boolean result;
        boolean bl = result = this.getEraserNodes().length > 0;
        if (!result) {
            for (Rule subRule : this.getSubRules()) {
                result = subRule.hasNodeErasers();
                if (result) break;
            }
        }
        return result;
    }

    public boolean hasEdgeErasers() {
        if (!this.hasEdgeErasersSet) {
            this.hasEdgeErasers = this.computeHasEdgeErasers();
            this.hasEdgeErasersSet = true;
        }
        return this.hasEdgeErasers;
    }

    private boolean computeHasEdgeErasers() {
        boolean result;
        boolean bl = result = this.getEraserEdges().length > 0;
        if (!result) {
            for (Rule subRule : this.getSubRules()) {
                result = subRule.hasEdgeErasers();
                if (result) break;
            }
        }
        return result;
    }

    public final RuleEdge[] getEraserEdges() {
        if (this.eraserEdges == null) {
            this.eraserEdges = this.computeEraserEdges();
        }
        return this.eraserEdges;
    }

    private RuleEdge[] computeEraserEdges() {
        this.testFixed(true);
        HashSet<RuleEdge> result = new HashSet<RuleEdge>(this.lhs().edgeSet());
        result.removeAll(this.rhs().edgeSet());
        DefaultRuleNode[] defaultRuleNodeArray = this.getEraserNodes();
        int n = defaultRuleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DefaultRuleNode eraserNode = defaultRuleNodeArray[n2];
            result.removeAll(this.lhs().edgeSet(eraserNode));
            ++n2;
        }
        return result.toArray(new RuleEdge[result.size()]);
    }

    public final RuleEdge[] getEraserNonAnchorEdges() {
        if (this.eraserNonAnchorEdges == null) {
            this.eraserNonAnchorEdges = this.computeEraserNonAnchorEdges();
        }
        return this.eraserNonAnchorEdges;
    }

    private RuleEdge[] computeEraserNonAnchorEdges() {
        HashSet<RuleEdge> eraserNonAnchorEdgeSet = new HashSet<RuleEdge>(Arrays.asList(this.getEraserEdges()));
        eraserNonAnchorEdgeSet.removeAll(this.getAnchor().edgeSet());
        return eraserNonAnchorEdgeSet.toArray(new RuleEdge[eraserNonAnchorEdgeSet.size()]);
    }

    public final DefaultRuleNode[] getEraserNodes() {
        if (this.eraserNodes == null) {
            this.eraserNodes = this.computeEraserNodes();
        }
        return this.eraserNodes;
    }

    private DefaultRuleNode[] computeEraserNodes() {
        HashSet<RuleNode> result = new HashSet<RuleNode>(this.lhs().nodeSet());
        result.removeAll(this.rhs().nodeSet());
        return result.toArray(new DefaultRuleNode[result.size()]);
    }

    public final Set<RuleNode> getModifierEnds() {
        if (this.modifierEnds == null) {
            this.modifierEnds = this.computeModifierEnds();
        }
        return this.modifierEnds;
    }

    private Set<RuleNode> computeModifierEnds() {
        HashSet<RuleNode> result = new HashSet<RuleNode>();
        RuleEdge[] ruleEdgeArray = this.getEraserEdges();
        int n = ruleEdgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleEdge eraserEdge = ruleEdgeArray[n2];
            result.add((RuleNode)eraserEdge.source());
            result.add((RuleNode)eraserEdge.target());
            ++n2;
        }
        for (RuleEdge rhsEdge : this.rhs().edgeSet()) {
            if (this.lhs().containsEdge(rhsEdge)) continue;
            RuleNode source = (RuleNode)rhsEdge.source();
            if (this.lhs().containsNode(source)) {
                result.add(source);
            }
            RuleNode target = (RuleNode)rhsEdge.target();
            if (!this.lhs().containsNode(target)) continue;
            result.add(target);
        }
        return result;
    }

    final Set<LabelVar> getModifierVars() {
        if (this.modifierVars == null) {
            this.modifierVars = this.computeModifierVars();
        }
        return this.modifierVars;
    }

    private Set<LabelVar> computeModifierVars() {
        Object eraser;
        HashSet<LabelVar> result = new HashSet<LabelVar>();
        for (RuleEdge edge : this.getCreatorGraph().edgeSet()) {
            result.addAll(((RuleLabel)edge.label()).allVarSet());
        }
        for (RuleNode node : this.getCreatorGraph().nodeSet()) {
            for (TypeGuard guard : node.getTypeGuards()) {
                result.add(guard.getVar());
            }
        }
        Object object = this.getEraserNodes();
        int n = ((DefaultRuleNode[])object).length;
        int n2 = 0;
        while (n2 < n) {
            eraser = object[n2];
            for (TypeGuard guard : eraser.getTypeGuards()) {
                result.add(guard.getVar());
            }
            ++n2;
        }
        object = this.getEraserEdges();
        n = ((RuleEdge[])object).length;
        n2 = 0;
        while (n2 < n) {
            eraser = object[n2];
            result.addAll(((RuleLabel)((AEdge)eraser).label()).allVarSet());
            ++n2;
        }
        return result;
    }

    final RuleGraph getCoRoot() {
        return this.coRoot;
    }

    public final RuleEdge[] getSimpleCreatorEdges() {
        if (this.simpleCreatorEdges == null) {
            this.simpleCreatorEdges = this.computeSimpleCreatorEdges();
        }
        return this.simpleCreatorEdges;
    }

    private RuleEdge[] computeSimpleCreatorEdges() {
        ArrayList<RuleEdge> result = new ArrayList<RuleEdge>();
        Set<RuleNode> nonCreatorNodes = this.getCreatorEnds();
        RuleEdge[] ruleEdgeArray = this.getCreatorEdges();
        int n = ruleEdgeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleEdge edge = ruleEdgeArray[n2];
            if (nonCreatorNodes.contains(edge.source()) && nonCreatorNodes.contains(edge.target())) {
                result.add(edge);
            }
            ++n2;
        }
        return result.toArray(new RuleEdge[result.size()]);
    }

    public final Set<RuleEdge> getComplexCreatorEdges() {
        if (this.complexCreatorEdges == null) {
            this.complexCreatorEdges = this.computeComplexCreatorEdges();
        }
        return this.complexCreatorEdges;
    }

    private Set<RuleEdge> computeComplexCreatorEdges() {
        HashSet<RuleEdge> result = new HashSet<RuleEdge>(Arrays.asList(this.getCreatorEdges()));
        result.removeAll(Arrays.asList(this.getSimpleCreatorEdges()));
        return result;
    }

    public final RuleEdge[] getCreatorEdges() {
        if (this.creatorEdges == null) {
            this.creatorEdges = this.computeCreatorEdges();
        }
        return this.creatorEdges;
    }

    private RuleEdge[] computeCreatorEdges() {
        HashSet<RuleEdge> result = new HashSet<RuleEdge>(this.rhs().edgeSet());
        result.removeAll(this.lhs().edgeSet());
        Rule parent = this.getParent();
        if (parent != null && parent != this) {
            result.removeAll(parent.rhs().edgeSet());
        }
        result.removeAll(this.getLhsMergers());
        result.removeAll(this.getRhsMergers());
        return result.toArray(new RuleEdge[result.size()]);
    }

    public final RuleNode[] getCreatorNodes() {
        if (this.creatorNodes == null) {
            this.creatorNodes = this.computeCreatorNodes();
        }
        return this.creatorNodes;
    }

    private RuleNode[] computeCreatorNodes() {
        HashSet<RuleNode> result = new HashSet<RuleNode>(this.rhs().nodeSet());
        result.removeAll(this.lhs().nodeSet());
        Rule parent = this.getParent();
        if (parent != null && parent != this) {
            result.removeAll(parent.rhs().nodeSet());
        }
        return result.toArray(new RuleNode[result.size()]);
    }

    public final LabelVar[] getCreatorVars() {
        if (this.creatorVars == null) {
            this.creatorVars = this.computeCreatorVars();
        }
        return this.creatorVars;
    }

    private LabelVar[] computeCreatorVars() {
        HashSet<LabelVar> creatorVarSet = new HashSet<LabelVar>();
        int i = 0;
        while (i < this.getCreatorEdges().length) {
            this.addCreatorVar(creatorVarSet, this.getCreatorEdges()[i]);
            ++i;
        }
        i = 0;
        while (i < this.getCreatorNodes().length) {
            this.addCreatorVar(creatorVarSet, this.getCreatorNodes()[i]);
            ++i;
        }
        return creatorVarSet.toArray(new LabelVar[creatorVarSet.size()]);
    }

    private void addCreatorVar(Set<LabelVar> creatorVarSet, RuleElement creatorEdge) {
        for (TypeGuard guard : creatorEdge.getTypeGuards()) {
            creatorVarSet.add(guard.getVar());
        }
    }

    final RuleGraph getCreatorGraph() {
        if (this.creatorGraph == null) {
            this.creatorGraph = this.computeCreatorGraph();
        }
        return this.creatorGraph;
    }

    private RuleGraph computeCreatorGraph() {
        RuleGraph result = this.rhs().newGraph(String.valueOf(this.getFullName()) + "(creators)");
        result.addNodeSet(Arrays.asList(this.getCreatorNodes()));
        result.addEdgeSetContext(Arrays.asList(this.getCreatorEdges()));
        return result;
    }

    public final Set<RuleNode> getCreatorEnds() {
        if (this.creatorEnds == null) {
            this.creatorEnds = new HashSet<RuleNode>(this.getCreatorGraph().nodeSet());
            this.creatorEnds.retainAll(this.lhs().nodeSet());
        }
        return this.creatorEnds;
    }

    public final Set<RuleEdge> getLhsMergers() {
        if (this.lhsMergers == null) {
            this.initMergers();
        }
        return this.lhsMergers;
    }

    public final Set<RuleEdge> getRhsMergers() {
        if (this.rhsMergers == null) {
            this.initMergers();
        }
        return this.rhsMergers;
    }

    private final void initMergers() {
        this.lhsMergers = new HashSet<RuleEdge>();
        this.rhsMergers = new HashSet<RuleEdge>();
        this.lhsMergeMap = new HashMap<RuleNode, RuleNode>();
        this.rhsMergeMap = new HashMap<RuleNode, RuleNode>();
        for (RuleEdge rhsEdge : this.rhs().edgeSet()) {
            if (!((RuleLabel)rhsEdge.label()).isEmpty() || this.lhs.containsEdge(rhsEdge)) continue;
            RuleNode source = (RuleNode)rhsEdge.source();
            RuleNode target = (RuleNode)rhsEdge.target();
            if (this.lhs().containsNode(source) && this.lhs().containsNode(target)) {
                this.lhsMergeMap.put(source, target);
                this.lhsMergers.add(rhsEdge);
                continue;
            }
            this.rhsMergeMap.put(source, target);
            this.rhsMergers.add(rhsEdge);
        }
        this.closeMergeMap(this.lhsMergeMap);
        this.closeMergeMap(this.rhsMergeMap);
    }

    public final Map<RuleNode, RuleNode> getLhsMergeMap() {
        if (this.lhsMergeMap == null) {
            this.initMergers();
        }
        return this.lhsMergeMap;
    }

    public final Map<RuleNode, RuleNode> getRhsMergeMap() {
        if (this.rhsMergeMap == null) {
            this.initMergers();
        }
        return this.rhsMergeMap;
    }

    private void closeMergeMap(Map<RuleNode, RuleNode> mergeMap) {
        for (Map.Entry<RuleNode, RuleNode> mergeEntry : mergeMap.entrySet()) {
            RuleNode oldValue;
            RuleNode newValue = oldValue = mergeEntry.getValue();
            while (mergeMap.containsKey(newValue)) {
                newValue = mergeMap.get(newValue);
            }
            mergeEntry.setValue(newValue);
        }
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setPartial() {
        this.partial = true;
    }

    public static AnchorFactory getAnchorFactory() {
        return anchorFactory;
    }

    public static void setAnchorFactory(AnchorFactory anchorFactory) {
        Rule.anchorFactory = anchorFactory;
    }

    public static long getMatchingTime() {
        return PlanSearchStrategy.searchFindReporter.getTotalTime();
    }
}

