/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.algebra.Algebras;
import groove.algebra.Constant;
import groove.algebra.Operator;
import groove.algebra.Precedence;
import groove.algebra.SignatureKind;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.util.ExprParser;
import groove.util.Pair;
import java.util.ArrayList;
import java.util.List;

public abstract class Expression {
    private final Kind kind;
    private static final String PAR_PREFIX = "$";
    private static final ExprParser parser = new ExprParser('\uffff', new char[]{'\"'}, (char[][])new char[][]{{'(', ')'}});

    protected Expression(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public abstract SignatureKind getType();

    public final String toString() {
        return this.toString(true);
    }

    abstract String toString(boolean var1);

    public final String toDisplayString() {
        return this.toDisplayString(Precedence.NONE);
    }

    abstract String toDisplayString(Precedence var1);

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        return this.kind == other.kind;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        return result;
    }

    public abstract Expression relabel(TypeLabel var1, TypeLabel var2);

    public static Expression parse(String text) throws FormatException {
        return Expression.parse(text, null);
    }

    public static Expression parse(String text, SignatureKind expectedType) throws FormatException {
        Expression result;
        String sigName;
        if (text.length() == 0) {
            throw new FormatException("Empty string cannot be parsed as expression", new Object[0]);
        }
        Pair<String, List<String>> splitText = parser.parse(text);
        String outer = splitText.one();
        int pos = outer.indexOf(58);
        SignatureKind declaredType = expectedType;
        if (pos >= 0 && (declaredType = SignatureKind.getKind(sigName = outer.substring(0, pos))) == null) {
            throw new FormatException("Unknown signature '%s'", sigName);
        }
        String rest = outer.substring(pos + 1);
        switch (splitText.two().size()) {
            case 0: {
                if (rest.startsWith(PAR_PREFIX)) {
                    return Expression.parseAsPar(rest, declaredType);
                }
                Constant constant = Algebras.getConstant(rest);
                if (constant == null) {
                    return Expression.parseAsField(rest, declaredType);
                }
                if (declaredType != null && constant.getSignature() != declaredType) {
                    throw new FormatException("Declared type %s differs from actual constant type %s", new Object[]{declaredType, constant.getSignature()});
                }
                result = new Const(constant);
                break;
            }
            case 1: {
                if (rest.charAt(rest.length() - 1) != '\uffff') {
                    throw new FormatException("Can't parse '%s' as expression", text);
                }
                String two = splitText.two().get(0);
                if (two.charAt(0) == '\"') {
                    if (rest.length() > 1) {
                        throw new FormatException("Can't parse '%s' as expression", text);
                    }
                    if (declaredType != null && declaredType != SignatureKind.STRING) {
                        throw new FormatException("Declared type %s differs from actual constant type %s", new Object[]{declaredType, SignatureKind.STRING});
                    }
                    result = new Const(Algebras.getConstant(two));
                    break;
                }
                String operatorName = rest.substring(0, rest.length() - 1);
                result = Expression.parseAsOperator(operatorName, two, declaredType);
                break;
            }
            default: {
                throw new FormatException("Can't parse '%s' as expression", text);
            }
        }
        if (expectedType != null && ((Expression)result).getType() != expectedType) {
            throw new FormatException("Actual type %s differs from expected type %s", new Object[]{((Expression)result).getType(), expectedType});
        }
        return result;
    }

    private static Expression parseAsPar(String text, SignatureKind type) throws FormatException {
        assert (text.startsWith(PAR_PREFIX));
        try {
            int nr = Integer.parseInt(text.substring(1));
            return new Par(type, nr);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FormatException("%s is not a valid parameter expression", text);
        }
    }

    private static Expression parseAsField(String field, SignatureKind type) throws FormatException {
        if (type == null) {
            throw new FormatException("Missing type declaration for field %s", field);
        }
        int pos = field.indexOf(46);
        if (pos < 0) {
            if (!Expression.isIdentifier(field)) {
                throw new FormatException("Field name '%s' is not a valid identifier", field);
            }
            return new Field(type, null, field);
        }
        String owner = field.substring(0, pos);
        if (!Expression.isIdentifier(owner)) {
            throw new FormatException("Field owner '%s' is not a valid identifier", owner);
        }
        String name = field.substring(pos + 1);
        if (!Expression.isIdentifier(name)) {
            throw new FormatException("Field name '%s' is not a valid identifier", name);
        }
        return new Field(type, owner, name);
    }

    private static Expression parseAsOperator(String operatorName, String argsText, SignatureKind signature) throws FormatException {
        String[] argsArray;
        if (signature == null) {
            throw new FormatException("Missing type declaration for operator %s", operatorName);
        }
        if (argsText.charAt(0) != '(') {
            throw new FormatException("Can't parse '%s' as argument list", argsText);
        }
        Operator operator = Algebras.getOperator(signature, operatorName);
        if (operator == null) {
            throw new FormatException("No operator '%s' in signature '%s'", new Object[]{operatorName, signature});
        }
        Call result = new Call(operator);
        int arity = result.getOperator().getArity();
        if (arity != (argsArray = parser.split(argsText.substring(1, argsText.length() - 1), ",")).length) {
            throw new FormatException("Wrong argument count %s (expected %s) for '%s'", argsArray.length, arity, operatorName);
        }
        int i = 0;
        while (i < argsArray.length) {
            SignatureKind argType = operator.getParamTypes().get(i);
            result.addArgument(Expression.parse(argsArray[i], argType));
            ++i;
        }
        return result;
    }

    private static boolean isIdentifier(String text) {
        boolean result;
        boolean bl = result = text.length() > 0;
        if (result) {
            result = Character.isJavaIdentifierStart(text.charAt(0));
            int i = 1;
            while (result && i < text.length()) {
                result = Character.isJavaIdentifierPart(text.charAt(i));
                ++i;
            }
        }
        return result;
    }

    public static class Call
    extends Expression {
        private final Operator operator;
        private final List<Expression> arguments = new ArrayList<Expression>();

        public Call(Operator operator) {
            super(Kind.CALL);
            this.operator = operator;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public void addArgument(Expression arg) {
            assert (this.getKind() == Kind.CALL);
            this.arguments.add(arg);
        }

        public List<Expression> getArguments() {
            return this.arguments;
        }

        @Override
        public SignatureKind getType() {
            return this.getOperator().getResultType();
        }

        @Override
        String toDisplayString(Precedence context) {
            StringBuilder result = new StringBuilder();
            Precedence precedence = this.getOperator().getPrecedence();
            if (precedence == null) {
                assert (this.getArguments().size() == this.getOperator().getArity());
                result.append(this.getOperator().getName());
                result.append('(');
                int i = 0;
                while (i < this.getArguments().size()) {
                    if (i > 0) {
                        result.append(',');
                    }
                    result.append(this.getArguments().get(i).toDisplayString(Precedence.NONE));
                    ++i;
                }
                result.append(')');
            } else {
                if (precedence == Precedence.UNARY) {
                    assert (this.getArguments().size() == 1);
                    result.append(this.getOperator().getSymbol());
                    result.append(this.getArguments().get(0).toDisplayString(precedence));
                } else {
                    assert (this.getArguments().size() == 2);
                    result.append(this.getArguments().get(0).toDisplayString(precedence));
                    result.append(' ');
                    result.append(this.getOperator().getSymbol());
                    result.append(' ');
                    result.append(this.getArguments().get(1).toDisplayString(precedence));
                }
                if (context.compareTo(precedence) > 0) {
                    result.insert(0, '(');
                    result.append(')');
                }
            }
            return result.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Call other = (Call)obj;
            return this.operator.equals(other.operator) && this.arguments.equals(other.arguments);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.arguments.hashCode();
            result = 31 * result + this.operator.hashCode();
            return result;
        }

        @Override
        String toString(boolean withType) {
            StringBuilder result = new StringBuilder();
            assert (this.getArguments().size() == this.getOperator().getArity());
            result.append((Object)this.getOperator().getSignature());
            result.append(':');
            result.append(this.getOperator().getName());
            result.append('(');
            int i = 0;
            while (i < this.getArguments().size()) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(this.getArguments().get(i).toString(false));
                ++i;
            }
            result.append(')');
            return result.toString();
        }

        @Override
        public Expression relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            Call result = this;
            if (oldLabel.getRole() == EdgeRole.BINARY) {
                ArrayList<Expression> newArgs = new ArrayList<Expression>();
                boolean isNew = false;
                int i = 0;
                while (i < this.getArguments().size()) {
                    Expression oldArg = this.getArguments().get(i);
                    Expression newArg = oldArg.relabel(oldLabel, newLabel);
                    newArgs.add(newArg);
                    isNew |= newArg != oldArg;
                    ++i;
                }
                if (isNew) {
                    result = new Call(this.getOperator());
                    result.getArguments().addAll(newArgs);
                }
            }
            return result;
        }
    }

    public static class Const
    extends Expression {
        private final Constant constant;

        public Const(Constant constant) {
            super(Kind.CONSTANT);
            this.constant = constant;
        }

        public Constant getConstant() {
            return this.constant;
        }

        @Override
        public SignatureKind getType() {
            return this.getConstant().getSignature();
        }

        @Override
        public String toDisplayString(Precedence precedence) {
            StringBuilder result = new StringBuilder();
            result.append(this.getConstant().getSymbol());
            return result.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Const other = (Const)obj;
            return this.constant.equals(other.constant);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.constant.hashCode();
            return result;
        }

        @Override
        String toString(boolean withType) {
            StringBuilder result = new StringBuilder();
            result.append(this.getConstant().getSymbol());
            return result.toString();
        }

        @Override
        public Expression relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            return this;
        }
    }

    public static class Field
    extends Expression {
        private final String owner;
        private final String field;
        private final SignatureKind type;

        public Field(SignatureKind type, String owner, String field) {
            super(Kind.FIELD);
            this.type = type;
            this.owner = owner;
            this.field = field;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getField() {
            return this.field;
        }

        @Override
        public SignatureKind getType() {
            return this.type;
        }

        @Override
        public String toDisplayString(Precedence precedence) {
            StringBuilder result = new StringBuilder();
            if (this.owner != null) {
                result.append(this.owner);
                result.append('.');
            }
            result.append(this.field);
            return result.toString();
        }

        @Override
        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Field other = (Field)obj;
            if (!this.type.equals((Object)other.type)) {
                return false;
            }
            boolean bl = this.owner == null ? other.owner == null : (result = this.owner.equals(other.owner));
            return result && this.field.equals(other.field);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.field.hashCode();
            result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            result = 31 * result + this.type.hashCode();
            return result;
        }

        @Override
        String toString(boolean withType) {
            StringBuilder result = new StringBuilder();
            if (withType) {
                result.append((Object)this.getType());
                result.append(':');
            }
            if (this.owner != null) {
                result.append(this.owner);
                result.append('.');
            }
            result.append(this.field);
            return result.toString();
        }

        @Override
        public Expression relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            if (oldLabel.getRole() == EdgeRole.BINARY && oldLabel.text().equals(this.field)) {
                return new Field(this.getType(), this.getOwner(), newLabel.text());
            }
            return this;
        }
    }

    public static enum Kind {
        CALL,
        CONSTANT,
        FIELD,
        PAR;

    }

    public static class Par
    extends Expression {
        private final int nr;
        private final SignatureKind type;

        public Par(SignatureKind type, int nr) {
            super(Kind.PAR);
            this.type = type;
            this.nr = nr;
        }

        public int getNumber() {
            return this.nr;
        }

        @Override
        public SignatureKind getType() {
            return this.type;
        }

        @Override
        public String toDisplayString(Precedence precedence) {
            StringBuilder result = new StringBuilder();
            result.append(Expression.PAR_PREFIX);
            result.append(this.getNumber());
            return result.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            Par other = (Par)obj;
            return this.nr == other.nr;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.nr;
            return result;
        }

        @Override
        String toString(boolean withType) {
            StringBuilder result = new StringBuilder();
            if (withType) {
                result.append((Object)this.getType());
                result.append(':');
            }
            result.append(this.toDisplayString());
            return result.toString();
        }

        @Override
        public Expression relabel(TypeLabel oldLabel, TypeLabel newLabel) {
            return this;
        }
    }
}

