/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.host;

import groove.grammar.AnchorKind;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeLabel;
import groove.graph.AEdge;
import groove.graph.EdgeRole;

public class DefaultHostEdge
extends AEdge<HostNode, TypeLabel>
implements HostEdge {
    private final int nr;
    private final TypeEdge type;

    protected DefaultHostEdge(HostNode source, TypeEdge type, HostNode target, int nr) {
        super(source, (TypeLabel)type.label(), target);
        assert (((TypeLabel)this.label()).getRole() == EdgeRole.BINARY || source == target) : String.format("Can't create %s label %s between distinct nodes %s and %s", ((TypeLabel)this.label()).getRole().getDescription(false), this.label(), source, target);
        this.nr = nr;
        this.type = type;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultHostEdge)) {
            return false;
        }
        DefaultHostEdge other = (DefaultHostEdge)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getNumber() != other.getNumber()) {
            return false;
        }
        return ((HostNode)this.source()).equals(other.source()) && ((HostNode)this.target()).equals(other.target());
    }

    @Override
    public int getNumber() {
        return this.nr;
    }

    @Override
    public TypeEdge getType() {
        return this.type;
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.EDGE;
    }
}

