/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.host;

import groove.algebra.Algebra;
import groove.algebra.AlgebraFamily;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeGraph;
import groove.graph.AElementMap;
import groove.graph.Edge;
import groove.graph.ElementFactory;
import groove.graph.Graph;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.graph.NodeSetEdgeSetGraph;

public class DefaultHostGraph
extends NodeSetEdgeSetGraph<HostNode, HostEdge>
implements HostGraph {
    private final HostFactory factory;

    public DefaultHostGraph(String name) {
        this(name, HostFactory.newInstance());
    }

    public DefaultHostGraph(String name, HostFactory factory) {
        super(name);
        assert (factory != null);
        this.factory = factory;
    }

    public DefaultHostGraph(HostGraph graph, AlgebraFamily family) {
        this(graph.getName(), graph.getFactory());
        HostGraphMorphism morphism = this.getFactory().createMorphism();
        for (HostNode sn : graph.nodeSet()) {
            HostNode tn;
            if (sn instanceof ValueNode && family != null) {
                ValueNode vn = (ValueNode)sn;
                tn = this.getFactory().createNodeFromString(family.getAlgebra(vn.getSignature()), vn.getSymbol());
            } else {
                tn = sn;
            }
            this.addNode(tn);
            morphism.putNode(sn, tn);
        }
        for (HostEdge se : graph.edgeSet()) {
            this.addEdgeContext((HostEdge)morphism.mapEdge(se));
        }
    }

    public DefaultHostGraph(Graph graph) {
        this(graph.getName());
        AElementMap<Node, Edge, HostNode, HostEdge> map = new AElementMap<Node, Edge, HostNode, HostEdge>((ElementFactory)this.getFactory()){};
        for (Node node : graph.nodeSet()) {
            HostNode newNode = (HostNode)this.addNode(node.getNumber());
            map.putNode(node, newNode);
        }
        for (Edge edge : graph.edgeSet()) {
            HostNode sourceImage = (HostNode)map.getNode(edge.source());
            HostNode targetImage = (HostNode)map.getNode(edge.target());
            HostEdge edgeImage = (HostEdge)this.addEdge(sourceImage, edge.label().text(), targetImage);
            map.putEdge(edge, edgeImage);
        }
        GraphInfo.transfer(graph, this, map);
    }

    public ValueNode addNode(Algebra<?> algebra, Object value) {
        ValueNode result = this.getFactory().createValueNode(algebra, value);
        this.addNode(result);
        return result;
    }

    @Override
    public HostGraph clone(AlgebraFamily family) {
        return new DefaultHostGraph(this, family);
    }

    @Override
    public DefaultHostGraph clone() {
        return new DefaultHostGraph(this, null);
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.HOST;
    }

    @Override
    public DefaultHostGraph newGraph(String name) {
        return new DefaultHostGraph(this.getName(), this.getFactory());
    }

    @Override
    protected boolean isTypeCorrect(Node node) {
        return node instanceof HostNode;
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        return edge instanceof HostEdge;
    }

    @Override
    public HostFactory getFactory() {
        return this.factory;
    }

    @Override
    public TypeGraph getTypeGraph() {
        return this.getFactory().getTypeFactory().getGraph();
    }

    @Override
    public HostGraph retype(TypeGraph typeGraph) throws FormatException {
        return typeGraph.analyzeHost(this).createImage(this.getName());
    }
}

