/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.host;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostEdgeSet;
import java.util.LinkedHashMap;
import java.util.Map;

public final class HostEdgeStore<K>
extends LinkedHashMap<K, HostEdgeSet> {
    public HostEdgeStore() {
    }

    public HostEdgeStore(HostEdgeStore<K> original, boolean deepCopy) {
        for (Map.Entry entry : original.entrySet()) {
            HostEdgeSet image = (HostEdgeSet)entry.getValue();
            this.put(entry.getKey(), deepCopy ? HostEdgeSet.newInstance(image) : image);
        }
    }

    public boolean addKey(K key) {
        HostEdgeSet oldValue = this.put(key, HostEdgeSet.newInstance(null));
        return oldValue == null;
    }

    public HostEdgeSet removeEdge(K key, HostEdge edge, boolean refresh) {
        HostEdgeSet result = (HostEdgeSet)this.get(key);
        if (result != null) {
            if (refresh) {
                result = HostEdgeSet.newInstance(result);
                this.put(key, result);
            }
            result.remove(edge);
        }
        return result;
    }

    public HostEdgeSet addEdge(K key, HostEdge edge, boolean refresh) {
        HostEdgeSet result = (HostEdgeSet)this.get(key);
        if (refresh || result == null) {
            result = HostEdgeSet.newInstance(result);
            this.put(key, result);
        }
        result.add(edge);
        return result;
    }
}

