/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.host;

import groove.algebra.Algebra;
import groove.algebra.SignatureKind;
import groove.grammar.AnchorKind;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeNode;
import groove.graph.ANode;

public class ValueNode
extends ANode
implements HostNode {
    private final SignatureKind signature;
    private final Algebra<?> algebra;
    private final Object value;
    private final TypeNode type;
    public static final ValueNode DUMMY_NODE = new ValueNode();

    private ValueNode() {
        super(Integer.MAX_VALUE);
        this.algebra = null;
        this.signature = null;
        this.value = null;
        this.type = null;
    }

    public ValueNode(int nr, Algebra<?> algebra, Object value, TypeNode type) {
        super(nr);
        this.algebra = algebra;
        this.signature = algebra.getKind();
        this.value = value;
        this.type = type;
        assert (algebra != null && value != null && type != null);
    }

    public Object getValue() {
        assert (this != DUMMY_NODE);
        return this.value;
    }

    public String getSymbol() {
        return this.getAlgebra().getSymbol(this.getValue());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getAlgebra().getName()) + ':' + this.getSymbol();
    }

    @Override
    protected String getToStringPrefix() {
        throw new UnsupportedOperationException();
    }

    public Algebra<?> getAlgebra() {
        assert (this != DUMMY_NODE);
        return this.algebra;
    }

    public SignatureKind getSignature() {
        assert (this != DUMMY_NODE);
        return this.signature;
    }

    @Override
    public TypeNode getType() {
        return this.type;
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.NODE;
    }
}

