/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.grammar.aspect.AspectNode;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.HostModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.grammar.model.TypeModel;
import groove.grammar.type.ImplicitTypeGraph;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CompositeTypeModel
extends ResourceModel<TypeGraph> {
    private final Map<String, TypeModel> typeModelMap = new HashMap<String, TypeModel>();
    private TypeGraph implicitTypeGraph;

    CompositeTypeModel(GrammarModel grammar) {
        super(grammar, ResourceKind.TYPE, "Composed type for " + grammar.getName());
    }

    @Override
    public Object getSource() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public TypeGraph getTypeGraph() {
        TypeGraph result;
        try {
            result = (TypeGraph)this.toResource();
        }
        catch (FormatException formatException) {
            result = this.getImplicitTypeGraph();
        }
        return result;
    }

    @Override
    boolean isShouldRebuild() {
        boolean result = super.isShouldRebuild();
        if (result) {
            result = this.isStale(ResourceKind.TYPE, ResourceKind.PROPERTIES);
            if (this.getGrammar().getActiveNames(ResourceKind.TYPE).isEmpty()) {
                result |= this.isStale(ResourceKind.HOST, ResourceKind.RULE);
            }
        }
        return result;
    }

    @Override
    TypeGraph compute() throws FormatException {
        TypeGraph result = null;
        FormatErrorSet errors = this.createErrors();
        this.typeModelMap.clear();
        for (String activeTypeName : this.getGrammar().getActiveNames(ResourceKind.TYPE)) {
            ResourceModel<?> resourceModel = this.getGrammar().getResource(ResourceKind.TYPE, activeTypeName);
            this.typeModelMap.put(activeTypeName, (TypeModel)resourceModel);
            for (FormatError error : resourceModel.getErrors()) {
                errors.add("Error in type '%s': %s", activeTypeName, error, resourceModel.getSource());
            }
        }
        errors.throwException();
        if (this.typeModelMap.isEmpty()) {
            result = this.getImplicitTypeGraph();
        } else {
            result = new TypeGraph("combined type");
            HashMap<TypeNode, TypeNode> importNodes = new HashMap<TypeNode, TypeNode>();
            HashMap<TypeNode, TypeModel> importModels = new HashMap<TypeNode, TypeModel>();
            for (TypeModel typeModel : this.typeModelMap.values()) {
                try {
                    TypeGraph graph = (TypeGraph)typeModel.toResource();
                    Map<TypeNode, TypeNode> map = result.add(graph);
                    for (TypeNode node : graph.getImports()) {
                        importNodes.put(node, map.get(node));
                        importModels.put(node, typeModel);
                    }
                }
                catch (FormatException e) {
                    errors.addAll(e.getErrors());
                }
                catch (IllegalArgumentException e) {
                    errors.add(e.getMessage(), new Object[0]);
                }
            }
            for (Map.Entry entry : importNodes.entrySet()) {
                if (!((TypeNode)entry.getValue()).isImported()) continue;
                TypeNode origNode = (TypeNode)entry.getKey();
                TypeModel origModel = (TypeModel)importModels.get(origNode);
                errors.add("Error in type graph '%s': Unresolved type import '%s'", origModel.getFullName(), origNode.label(), this.getInverse(origModel.getMap().nodeMap(), origNode), origModel.getSource());
            }
            result.setFixed();
        }
        errors.throwException();
        return result;
    }

    private TypeGraph getImplicitTypeGraph() {
        if (this.implicitTypeGraph == null) {
            this.implicitTypeGraph = ImplicitTypeGraph.newInstance(this.getLabels());
        }
        return this.implicitTypeGraph;
    }

    @Override
    void notifyWillRebuild() {
        this.implicitTypeGraph = null;
    }

    private Set<TypeLabel> getLabels() {
        HashSet<TypeLabel> result = new HashSet<TypeLabel>();
        for (ResourceKind kind : EnumSet.of(ResourceKind.RULE, ResourceKind.HOST)) {
            for (ResourceModel<?> model : this.getGrammar().getResourceSet(kind)) {
                result.addAll(((GraphBasedModel)model).getLabels());
            }
        }
        HostModel host = this.getGrammar().getStartGraphModel();
        if (host != null) {
            result.addAll(host.getLabels());
        }
        return result;
    }

    private AspectNode getInverse(Map<AspectNode, ?> map, TypeNode image) {
        AspectNode result = null;
        for (Map.Entry<AspectNode, ?> entry : map.entrySet()) {
            if (!entry.getValue().equals(image)) continue;
            return entry.getKey();
        }
        return result;
    }
}

