/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.algebra.Algebra;
import groove.algebra.AlgebraFamily;
import groove.algebra.Constant;
import groove.algebra.SignatureKind;
import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectElement;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectNode;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.type.TypeLabel;
import groove.graph.Element;
import groove.graph.GraphInfo;
import groove.graph.Node;
import groove.gui.dialog.GraphPreviewDialog;
import groove.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HostModel
extends GraphBasedModel<HostGraph> {
    private HostModelMap hostModelMap;
    private GraphBasedModel.TypeModelMap typeMap;
    private AspectGraph normalSource;
    private AspectGraph.AspectGraphMorphism normalMap;
    private Set<TypeLabel> labelSet;
    private AlgebraFamily algebraFamily;
    private static boolean debug;

    public HostModel(GrammarModel grammar, AspectGraph source) {
        super(grammar, source);
        source.testFixed(true);
    }

    public HostGraph toHost() throws FormatException {
        return (HostGraph)this.toResource();
    }

    public HostModelMap getMap() {
        this.synchronise();
        if (this.hasErrors()) {
            throw new IllegalStateException();
        }
        return this.hostModelMap;
    }

    @Override
    public GraphBasedModel.TypeModelMap getTypeMap() {
        this.synchronise();
        return this.typeMap;
    }

    @Override
    public Set<TypeLabel> getLabels() {
        if (this.labelSet == null) {
            this.labelSet = new HashSet<TypeLabel>();
            for (AspectEdge edge : this.getNormalSource().edgeSet()) {
                TypeLabel label = edge.getTypeLabel();
                if (label == null) continue;
                this.labelSet.add(label);
            }
        }
        return this.labelSet;
    }

    private AlgebraFamily getFamily() {
        return this.getGrammar() == null ? AlgebraFamily.DEFAULT : AlgebraFamily.TERM;
    }

    private AspectGraph getNormalSource() {
        if (this.normalSource == null) {
            this.normalMap = new AspectGraph.AspectGraphMorphism(this.getSource().getRole());
            this.normalSource = this.getSource().normalise(this.normalMap);
        }
        return this.normalSource;
    }

    @Override
    void notifyWillRebuild() {
        super.notifyWillRebuild();
        this.labelSet = null;
        this.typeMap = null;
    }

    @Override
    HostGraph compute() throws FormatException {
        this.algebraFamily = this.getFamily();
        GraphInfo.throwException(this.getSource());
        Pair<DefaultHostGraph, HostModelMap> modelPlusMap = this.computeModel(this.getSource());
        HostGraph result = modelPlusMap.one();
        GraphInfo.throwException(result);
        HostModelMap hostModelMap = modelPlusMap.two();
        GraphBasedModel.TypeModelMap typeMap = new GraphBasedModel.TypeModelMap(result.getTypeGraph().getFactory());
        for (Map.Entry nodeEntry : hostModelMap.nodeMap().entrySet()) {
            typeMap.putNode(nodeEntry.getKey(), ((HostNode)nodeEntry.getValue()).getType());
        }
        for (AspectEdge sourceEdge : this.getSource().edgeSet()) {
            HostEdge hostEdge;
            AspectEdge normalEdge = (AspectEdge)this.normalMap.getEdge(sourceEdge);
            if (normalEdge == null) {
                normalEdge = sourceEdge;
            }
            if ((hostEdge = (HostEdge)hostModelMap.getEdge(normalEdge)) == null) continue;
            typeMap.putEdge(sourceEdge, hostEdge.getType());
        }
        this.typeMap = typeMap;
        this.hostModelMap = hostModelMap;
        return result;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private Pair<DefaultHostGraph, HostModelMap> computeModel(AspectGraph source) {
        block16: {
            normalSource = this.getNormalSource();
            if (HostModel.debug) {
                GraphPreviewDialog.showGraph(normalSource);
            }
            errors = new FormatErrorSet((Collection<? extends FormatError>)GraphInfo.getErrors(normalSource));
            result = new DefaultHostGraph(normalSource.getName());
            elementMap = new HostModelMap(result.getFactory());
            for (AspectNode modelNode : normalSource.nodeSet()) {
                if (modelNode /* !! */ .getAttrKind().hasSignature()) continue;
                this.processModelNode(result, elementMap, modelNode /* !! */ );
            }
            for (AspectNode modelNode : normalSource.nodeSet()) {
                if (!modelNode /* !! */ .getAttrKind().hasSignature()) continue;
                this.processModelNode(result, elementMap, modelNode /* !! */ );
            }
            for (AspectEdge modelEdge : normalSource.edgeSet()) {
                try {
                    this.processModelEdge(result, elementMap, modelEdge);
                }
                catch (FormatException exc) {
                    errors.addAll(exc.getErrors());
                }
            }
            for (AspectNode modelNode : elementMap.nodeMap().values()) {
                if (!(modelNode /* !! */  instanceof ValueNode) || !result.edgeSet(modelNode /* !! */ ).isEmpty()) continue;
                result.removeNode(modelNode /* !! */ );
            }
            if (this.getGrammar() != null) {
                try {
                    type = this.getGrammar().getTypeGraph();
                    typing = type.analyzeHost(result);
                    result = typing.createImage(result.getName());
                    newElementMap = new HostModelMap(result.getFactory());
                    for (Map.Entry<AspectNode, N> nodeEntry : elementMap.nodeMap().entrySet()) {
                        typedNode = (HostNode)typing.getNode((Node)nodeEntry.getValue());
                        if (typedNode == null) continue;
                        newElementMap.putNode(nodeEntry.getKey(), typedNode);
                    }
                    for (AspectEdge sourceEdge : this.getSource().edgeSet()) {
                        normalEdge = (AspectEdge)this.normalMap.getEdge(sourceEdge);
                        if (normalEdge == null) {
                            normalEdge = sourceEdge;
                        }
                        if ((hostEdge = (HostEdge)elementMap.getEdge(normalEdge)) == null) continue;
                        newElementMap.putEdge(normalEdge, (HostEdge)typing.getEdge(hostEdge));
                    }
                    elementMap = newElementMap;
                    break block16;
                }
                catch (FormatException e) {
                    inverseMap = new HashMap<Element, Element>();
                    ** for (nodeEntry : elementMap.nodeMap().entrySet())
                }
lbl-1000:
                // 1 sources

                {
                    inverseMap.put((Element)nodeEntry.getValue(), nodeEntry.getKey());
                    continue;
                }
lbl56:
                // 2 sources

                for (Map.Entry<AspectElement, Object> edgeEntry : elementMap.edgeMap().entrySet()) {
                    inverseMap.put((Element)edgeEntry.getValue(), edgeEntry.getKey());
                }
                for (FormatError error : e.getErrors()) {
                    errors.add(error.transfer(inverseMap));
                }
            }
        }
        GraphInfo.transfer(normalSource, result, elementMap);
        GraphInfo.setErrors(result, errors);
        result.setFixed();
        return new Pair<DefaultHostGraph, HostModelMap>(result, elementMap);
    }

    private void processModelNode(DefaultHostGraph result, HostModelMap elementMap, AspectNode modelNode) {
        if (!modelNode.getKind().isMeta()) {
            HostNode nodeImage = null;
            AspectKind attrType = modelNode.getAttrKind();
            if (attrType.hasSignature()) {
                Algebra<?> nodeAlgebra = this.algebraFamily.getAlgebra(SignatureKind.getKind(attrType.getName()));
                Aspect dataType = modelNode.getAttrAspect();
                String symbol = ((Constant)dataType.getContent()).getSymbol();
                nodeImage = result.getFactory().createNodeFromString(nodeAlgebra, symbol);
                result.addNode(nodeImage);
            } else {
                nodeImage = (HostNode)result.addNode(modelNode.getNumber());
            }
            elementMap.putNode(modelNode, nodeImage);
        }
    }

    private void processModelEdge(HostGraph result, HostModelMap elementMap, AspectEdge modelEdge) throws FormatException {
        if (modelEdge.getKind().isMeta()) {
            return;
        }
        HostNode hostSource = (HostNode)elementMap.getNode((Node)modelEdge.source());
        assert (hostSource != null) : String.format("Source of '%s' is not in element map %s", modelEdge.source(), elementMap);
        HostNode hostNode = (HostNode)elementMap.getNode((Node)modelEdge.target());
        assert (hostNode != null) : String.format("Target of '%s' is not in element map %s", modelEdge.target(), elementMap);
        TypeLabel hostLabel = modelEdge.getTypeLabel();
        assert (hostLabel != null && !hostLabel.isDataType()) : String.format("Inappropriate label %s", hostLabel);
        HostEdge hostEdge = (HostEdge)result.addEdge(hostSource, hostLabel, hostNode);
        elementMap.putEdge(modelEdge, hostEdge);
    }

    public static void setDebug(boolean debug) {
        HostModel.debug = debug;
    }

    public static class HostModelMap
    extends GraphBasedModel.ModelMap<HostNode, HostEdge> {
        public HostModelMap(HostFactory factory) {
            super(factory);
        }
    }
}

