/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.graph.GraphRole;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public enum ResourceKind {
    HOST("Graph", "host graph", GraphRole.HOST, FileType.STATE_FILTER, "start"),
    RULE("Rule", "rule", GraphRole.RULE, FileType.RULE_FILTER, null),
    TYPE("Type", "type graph", GraphRole.TYPE, FileType.TYPE_FILTER, "type"),
    CONTROL("Control", "control program", FileType.CONTROL_FILTER, "control"),
    PROLOG("Prolog", "prolog program", FileType.PROLOG_FILTER, null),
    PROPERTIES("Properties", "grammar properties", FileType.PROPERTIES_FILTER, "system"),
    GROOVY("Groovy", "groovy script", FileType.GROOVY_FILTER, null),
    CONFIG("Configuration", "configuration file", FileType.CONFIGURATION_FILTER, null);

    private final GraphRole graphRole;
    private final String name;
    private final String description;
    private final ExtensionFilter filter;
    private final String defaultName;
    private static final Set<ResourceKind> allResources;
    private static final Set<ResourceKind> allNonProperties;
    private static Map<GraphRole, ResourceKind> roleKindMap;

    static {
        allResources = EnumSet.allOf(ResourceKind.class);
        allNonProperties = EnumSet.allOf(ResourceKind.class);
        allNonProperties.remove((Object)PROPERTIES);
        roleKindMap = new EnumMap<GraphRole, ResourceKind>(GraphRole.class);
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            if (kind.isGraphBased()) {
                roleKindMap.put(kind.getGraphRole(), kind);
            }
            ++n2;
        }
    }

    private ResourceKind(String name, String description, ExtensionFilter filter, String defaultName) {
        this(name, description, GraphRole.NONE, filter, defaultName);
    }

    private ResourceKind(String name, String description, GraphRole graphRole, ExtensionFilter filter, String defaultName) {
        this.graphRole = graphRole;
        this.description = description;
        this.name = name;
        this.filter = filter;
        this.defaultName = defaultName;
    }

    public GraphRole getGraphRole() {
        return this.graphRole;
    }

    public boolean isGraphBased() {
        return this.getGraphRole() != GraphRole.NONE;
    }

    public boolean isTextBased() {
        return this != PROPERTIES && !this.isGraphBased();
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getDescription() {
        return this.description;
    }

    public ExtensionFilter getFilter() {
        return this.filter;
    }

    public boolean hasProperties() {
        return this == RULE;
    }

    public boolean isEnableable() {
        return this != PROPERTIES && this != CONFIG && this != GROOVY;
    }

    public boolean hasDisplay() {
        return this != PROPERTIES && this != CONFIG;
    }

    public static ResourceKind toResource(GraphRole graphRole) {
        return roleKindMap.get((Object)graphRole);
    }

    public static Set<ResourceKind> all(boolean withProperties) {
        return withProperties ? allResources : allNonProperties;
    }
}

