/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.algebra.SignatureKind;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectNode;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeEdge;
import groove.grammar.type.TypeFactory;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.graph.GraphInfo;
import groove.graph.Node;
import java.awt.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class TypeModel
extends GraphBasedModel<TypeGraph> {
    private GraphBasedModel.TypeModelMap modelMap;
    private GraphBasedModel.TypeModelMap typeMap;

    public TypeModel(GrammarModel grammar, AspectGraph source) {
        super(grammar, source);
        source.testFixed(true);
    }

    @Override
    void notifyWillRebuild() {
        super.notifyWillRebuild();
        this.typeMap = null;
    }

    @Override
    boolean isShouldRebuild() {
        boolean result = super.isShouldRebuild();
        if (result) {
            result = this.isStale(ResourceKind.TYPE);
        }
        return result;
    }

    public GraphBasedModel.TypeModelMap getMap() {
        this.synchronise();
        if (this.hasErrors()) {
            throw new IllegalStateException();
        }
        return this.modelMap;
    }

    @Override
    public GraphBasedModel.TypeModelMap getTypeMap() {
        this.synchronise();
        return this.typeMap;
    }

    @Override
    public Set<TypeLabel> getLabels() {
        TypeGraph typeGraph = (TypeGraph)this.getResource();
        return typeGraph == null ? Collections.emptySet() : typeGraph.getLabels();
    }

    @Override
    TypeGraph compute() throws FormatException {
        GraphInfo.throwException(this.getSource());
        FormatErrorSet errors = this.createErrors();
        TypeGraph result = new TypeGraph(this.getFullName());
        TypeFactory factory = result.getFactory();
        this.modelMap = new GraphBasedModel.TypeModelMap(factory);
        for (AspectNode modelNode : this.getSource().nodeSet()) {
            AspectKind attrKind = modelNode.getAttrKind();
            if (attrKind == AspectKind.DEFAULT) continue;
            TypeLabel typeLabel = TypeLabel.createLabel(EdgeRole.NODE_TYPE, attrKind.getName());
            try {
                this.addNodeType(modelNode, typeLabel, factory);
            }
            catch (FormatException e) {
                errors.addAll(e.getErrors());
            }
        }
        for (AspectEdge modelEdge : this.getSource().edgeSet()) {
            TypeLabel typeLabel = modelEdge.getTypeLabel();
            if (typeLabel == null || typeLabel.getRole() != EdgeRole.NODE_TYPE) continue;
            AspectNode modelNode = (AspectNode)modelEdge.source();
            try {
                this.addNodeType(modelNode, typeLabel, factory);
            }
            catch (FormatException e) {
                errors.addAll(e.getErrors());
            }
        }
        errors.throwException();
        HashSet untypedNodes = new HashSet(this.getSource().nodeSet());
        untypedNodes.removeAll(this.modelMap.nodeMap().keySet());
        Iterator untypedNodeIter = untypedNodes.iterator();
        while (untypedNodeIter.hasNext()) {
            AspectNode modelNode = (AspectNode)untypedNodeIter.next();
            if (modelNode.getKind().isMeta()) {
                untypedNodeIter.remove();
                continue;
            }
            TypeNode typeNode = factory.getTopNode();
            result.addNode(typeNode);
            this.modelMap.putNode(modelNode, typeNode);
        }
        for (AspectNode untypedNode : untypedNodes) {
            errors.add("Node '%s' has no type label", untypedNode);
        }
        for (AspectEdge modelEdge : this.getSource().edgeSet()) {
            TypeLabel typeLabel = modelEdge.getTypeLabel();
            if (modelEdge.getKind().isMeta() || typeLabel != null && typeLabel.getRole() == EdgeRole.NODE_TYPE) continue;
            try {
                this.processModelEdge(result, this.modelMap, modelEdge);
            }
            catch (FormatException exc) {
                errors.addAll(exc.getErrors());
            }
        }
        this.transferErrors(errors, this.modelMap).throwException();
        GraphInfo.transfer(this.getSource(), result, this.modelMap);
        result.setFixed();
        try {
            result.test();
        }
        catch (FormatException exc) {
            this.transferErrors(exc.getErrors(), this.modelMap).throwException();
        }
        this.typeMap = this.modelMap;
        return result;
    }

    private void addNodeType(AspectNode modelNode, TypeLabel typeLabel, TypeFactory factory) throws FormatException {
        TypeNode oldTypeNode = (TypeNode)this.modelMap.getNode(modelNode);
        if (oldTypeNode != null) {
            throw new FormatException("Duplicate types '%s' and '%s'", typeLabel.text(), oldTypeNode.label().text(), modelNode);
        }
        SignatureKind signature = modelNode.getAttrKind().getSignature();
        TypeNode typeNode = signature == null ? factory.createNode(typeLabel) : factory.getDataType(signature);
        if (modelNode.getKind() == AspectKind.ABSTRACT) {
            if (signature != null) {
                throw new FormatException("Data type '%s' cannot be abstract", typeLabel.text(), modelNode);
            }
            typeNode.setAbstract(true);
        }
        if (modelNode.hasImport()) {
            if (signature != null) {
                throw new FormatException("Data type '%s' cannot be imported", typeLabel.text(), modelNode);
            }
            typeNode.setImported(true);
        }
        if (modelNode.hasColor()) {
            typeNode.setColor((Color)modelNode.getColor().getContent());
        }
        if (modelNode.isEdge()) {
            if (signature != null) {
                throw new FormatException("Data type '%s' cannot be a nodified edge", typeLabel.text(), modelNode);
            }
            typeNode.setLabelPattern(modelNode.getEdgePattern());
        }
        this.modelMap.putNode(modelNode, typeNode);
    }

    private void processModelEdge(TypeGraph model, GraphBasedModel.TypeModelMap elementMap, AspectEdge modelEdge) throws FormatException {
        TypeNode typeSource = (TypeNode)elementMap.getNode((Node)modelEdge.source());
        assert (typeSource != null) : String.format("Source of model edge '%s' not in element map %s", modelEdge.source(), elementMap);
        if (typeSource.isImported()) {
            throw new FormatException("Can't change imported type '%s'", typeSource.label(), modelEdge);
        }
        TypeNode typeTarget = (TypeNode)elementMap.getNode((Node)modelEdge.target());
        assert (typeTarget != null) : String.format("Target of model edge '%s' not in element map %s", modelEdge.source(), elementMap);
        TypeEdge typeEdge = null;
        if (modelEdge.getAttrKind().hasSignature()) {
            TypeNode typeNode = model.getFactory().getDataType(modelEdge.getSignature());
            typeEdge = (TypeEdge)model.addEdge(typeSource, modelEdge.getAttrAspect().getContentString(), typeNode);
        } else if (modelEdge.getKind() == AspectKind.SUBTYPE) {
            model.addInheritance(typeSource, typeTarget);
        } else {
            TypeLabel typeLabel = modelEdge.getTypeLabel();
            typeEdge = (TypeEdge)model.addEdge(typeSource, typeLabel, typeTarget);
            typeEdge.setComposite(modelEdge.isComposite());
            typeEdge.setInMult(modelEdge.getInMult());
            typeEdge.setOutMult(modelEdge.getOutMult());
            typeEdge.setAbstract(modelEdge.getKind() == AspectKind.ABSTRACT);
            typeEdge.setComposite(modelEdge.isComposite());
        }
        if (typeEdge != null) {
            elementMap.putEdge(modelEdge, typeEdge);
        }
    }
}

