/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.grammar.AnchorKind;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleGraph;
import groove.grammar.rule.RuleNode;
import groove.graph.EdgeComparator;
import groove.graph.NodeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Anchor
extends ArrayList<AnchorKey>
implements Comparable<Anchor> {
    private Set<RuleNode> nodeSet;
    private Set<RuleEdge> edgeSet;
    private Set<LabelVar> varSet;

    public Anchor() {
    }

    public Anchor(Collection<? extends AnchorKey> c) {
        super(c);
    }

    public Anchor(RuleGraph graph) {
        this.addAll(graph.nodeSet());
        this.addAll(graph.edgeSet());
        this.addAll(graph.varSet());
    }

    @Override
    public boolean add(AnchorKey e) {
        boolean result;
        boolean bl = result = !this.contains(e);
        if (result) {
            super.add(e);
            if (e.getAnchorKind() == AnchorKind.NODE) {
                this.addAll(AnchorKind.node(e).getVars());
            } else if (e.getAnchorKind() == AnchorKind.EDGE) {
                this.addAll(AnchorKind.edge(e).getVars());
                this.add((AnchorKey)AnchorKind.edge(e).source());
                this.add((AnchorKey)AnchorKind.edge(e).target());
            }
        }
        return result;
    }

    public Set<RuleNode> nodeSet() {
        if (this.nodeSet == null) {
            this.initSets();
        }
        return this.nodeSet;
    }

    public Set<RuleEdge> edgeSet() {
        if (this.edgeSet == null) {
            this.initSets();
        }
        return this.edgeSet;
    }

    public Set<LabelVar> varSet() {
        if (this.varSet == null) {
            this.initSets();
        }
        return this.varSet;
    }

    private void initSets() {
        this.nodeSet = new HashSet<RuleNode>();
        this.edgeSet = new HashSet<RuleEdge>();
        this.varSet = new HashSet<LabelVar>();
        for (AnchorKey key : this) {
            switch (key.getAnchorKind()) {
                case NODE: {
                    this.nodeSet.add(AnchorKind.node(key));
                    break;
                }
                case EDGE: {
                    this.edgeSet.add(AnchorKind.edge(key));
                    break;
                }
                case LABEL: {
                    this.varSet.add(AnchorKind.label(key));
                }
            }
        }
    }

    @Override
    public int compareTo(Anchor other) {
        int result = this.size() - other.size();
        if (result != 0) {
            return result;
        }
        int i = 0;
        while (i < this.size()) {
            result = this.compare((AnchorKey)this.get(i), (AnchorKey)other.get(i));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return result;
    }

    private int compare(AnchorKey one, AnchorKey two) {
        int result = one.getAnchorKind().compareTo(two.getAnchorKind());
        if (result != 0) {
            return result;
        }
        switch (one.getAnchorKind()) {
            case EDGE: {
                result = EdgeComparator.instance().compare(AnchorKind.edge(one), AnchorKind.edge(two));
                break;
            }
            case LABEL: {
                result = AnchorKind.label(one).compareTo(AnchorKind.label(two));
                break;
            }
            case NODE: {
                result = NodeComparator.instance().compare(AnchorKind.node(one), AnchorKind.node(two));
            }
        }
        return result;
    }
}

