/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.grammar.AnchorKind;
import groove.grammar.rule.AnchorKey;
import groove.graph.EdgeRole;

public class LabelVar
implements AnchorKey,
Comparable<LabelVar> {
    private final int nr;
    private final String name;
    private final EdgeRole kind;
    private static int unnamedLabelCounter;

    private LabelVar(int nr, String name, EdgeRole kind) {
        this.nr = nr;
        this.name = name;
        this.kind = kind;
        assert (name != null);
    }

    public LabelVar(String name, EdgeRole kind) {
        this(0, name, kind);
        assert (!name.isEmpty());
    }

    public LabelVar(EdgeRole kind) {
        this(++unnamedLabelCounter, "", kind);
    }

    public final boolean hasName() {
        return this.name.length() > 0;
    }

    public final String getName() {
        return this.name;
    }

    public final String getKey() {
        return String.valueOf(this.getName()) + "-" + this.nr;
    }

    public final EdgeRole getKind() {
        return this.kind;
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.LABEL;
    }

    public String toString() {
        return String.valueOf('?') + this.getName();
    }

    public int hashCode() {
        return this.getKey().hashCode() ^ this.getKind().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelVar other = (LabelVar)obj;
        if (this.getKind() != other.getKind()) {
            return false;
        }
        return this.getKey().equals(other.getKey());
    }

    @Override
    public int compareTo(LabelVar o) {
        int result = this.getName().compareTo(o.getName());
        if (result != 0) {
            return result;
        }
        result = this.getKind().compareTo(o.getKind());
        if (result != 0) {
            return result;
        }
        return this.nr - o.nr;
    }
}

