/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.algebra.Constant;
import groove.algebra.SignatureKind;
import groove.algebra.Term;
import groove.algebra.Variable;
import groove.grammar.AnchorKind;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeNode;
import groove.graph.ANode;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class VariableNode
extends ANode
implements RuleNode,
AnchorKey {
    private final TypeNode type;
    private final Term term;
    public static final String TO_STRING_PREFIX = "x";
    private static final List<TypeGuard> EMPTY_GUARD_LIST = Collections.emptyList();
    private static final Set<LabelVar> EMPTY_VAR_SET = Collections.emptySet();

    public VariableNode(int nr, SignatureKind signature, TypeNode type) {
        super(nr);
        assert (signature != null);
        this.term = new Variable(super.toString(), signature);
        assert (type != null);
        this.type = type;
    }

    public VariableNode(int nr, Term term, TypeNode type) {
        super(nr);
        this.term = term;
        assert (type != null);
        this.type = type;
    }

    @Override
    public String toString() {
        if (this.getConstant() == null) {
            return super.toString();
        }
        return this.getConstant().toString();
    }

    @Override
    protected String getToStringPrefix() {
        return TO_STRING_PREFIX;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VariableNode)) {
            return false;
        }
        VariableNode other = (VariableNode)obj;
        return this.getNumber() == other.getNumber();
    }

    public SignatureKind getSignature() {
        return this.term.getSignature();
    }

    public boolean hasConstant() {
        return this.term instanceof Constant;
    }

    public Term getTerm() {
        return this.term;
    }

    public Constant getConstant() {
        return this.hasConstant() ? (Constant)this.getTerm() : null;
    }

    public Variable getVariable() {
        return this.getTerm() instanceof Variable ? null : (Variable)this.getTerm();
    }

    @Override
    public TypeNode getType() {
        return this.type;
    }

    @Override
    public AnchorKind getAnchorKind() {
        return AnchorKind.NODE;
    }

    @Override
    public List<TypeGuard> getTypeGuards() {
        return EMPTY_GUARD_LIST;
    }

    @Override
    public Set<LabelVar> getVars() {
        return EMPTY_VAR_SET;
    }

    @Override
    public Set<TypeNode> getMatchingTypes() {
        return Collections.singleton(this.type);
    }

    @Override
    public boolean isSharp() {
        return true;
    }
}

