/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.annotation.Help;
import groove.annotation.Syntax;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipHeader;
import groove.annotation.ToolTipPars;
import groove.util.Pair;
import java.lang.reflect.Field;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EdgeRole
extends Enum<EdgeRole> {
    @Syntax(value="NODE_TYPE.COLON.label")
    @ToolTipHeader(value="Node type")
    @ToolTipBody(value={"Represents a node type label"})
    @ToolTipPars(value={"the type name"})
    public static final /* enum */ EdgeRole NODE_TYPE = new EdgeRole("node type", "type");
    @Syntax(value="FLAG.COLON.label")
    @ToolTipHeader(value="Flag")
    @ToolTipBody(value={"Represents a node label (not a type)"})
    @ToolTipPars(value={"the text of the flag"})
    public static final /* enum */ EdgeRole FLAG = new EdgeRole("flag", "flag");
    @Syntax(value="label")
    @ToolTipHeader(value="Binary edge")
    @ToolTipBody(value={"Represents a binary edge between nodes"})
    @ToolTipPars(value={"the edge label"})
    public static final /* enum */ EdgeRole BINARY = new EdgeRole("edge", "");
    private final String description;
    private final String name;
    private final String prefix;
    private static Map<String, String> docMap;
    private static Map<EdgeRole, Pair<String, String>> roleToDocMap;
    private static Map<EdgeRole, Integer> indexMap;
    private static Map<String, EdgeRole> symbolToRoleMap;
    private static Map<String, String> nameToSymbolMap;
    private static final EdgeRole[] rolesArray;
    private static final /* synthetic */ EdgeRole[] ENUM$VALUES;

    static {
        ENUM$VALUES = new EdgeRole[]{NODE_TYPE, FLAG, BINARY};
        indexMap = new EnumMap<EdgeRole, Integer>(EdgeRole.class);
        symbolToRoleMap = new HashMap<String, EdgeRole>();
        nameToSymbolMap = new HashMap<String, String>();
        rolesArray = new EdgeRole[EdgeRole.values().length];
        int index = 0;
        EdgeRole[] edgeRoleArray = EdgeRole.values();
        int n = edgeRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            EdgeRole role = edgeRoleArray[n2];
            indexMap.put(role, index);
            symbolToRoleMap.put(role.getName(), role);
            EdgeRole.rolesArray[index] = role;
            nameToSymbolMap.put(role.name(), role.getName());
            ++index;
            ++n2;
        }
        nameToSymbolMap.put("COLON", ":");
    }

    private EdgeRole(String description, String name) {
        this.description = description;
        this.name = name;
        this.prefix = name.length() == 0 ? name : String.valueOf(name) + ':';
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDescription(boolean capitalised) {
        String result = this.description;
        if (capitalised) {
            char[] resultChars = result.toCharArray();
            resultChars[0] = Character.toUpperCase(resultChars[0]);
            result = new String(resultChars);
        }
        return result;
    }

    public Pair<String, String> getDoc() {
        return EdgeRole.getRoleToDocMap().get((Object)this);
    }

    public static Pair<EdgeRole, String> parseLabel(String text) {
        EdgeRole resultRole = BINARY;
        for (EdgeRole role : EnumSet.of(NODE_TYPE, FLAG)) {
            if (!text.startsWith(role.getPrefix())) continue;
            resultRole = role;
            break;
        }
        return new Pair<EdgeRole, String>(resultRole, text.substring(resultRole.getPrefix().length()));
    }

    public static int getIndex(EdgeRole role) {
        return indexMap.get((Object)role);
    }

    public static EdgeRole getRole(int index) {
        return rolesArray[index];
    }

    public static EdgeRole getRole(String name) {
        assert (name.length() > 0);
        return symbolToRoleMap.get(name);
    }

    public static Map<EdgeRole, Pair<String, String>> getRoleToDocMap() {
        if (roleToDocMap == null) {
            roleToDocMap = EdgeRole.computeRoleToDocMap();
        }
        return roleToDocMap;
    }

    public static Map<String, String> getDocMap() {
        if (docMap == null) {
            docMap = new LinkedHashMap<String, String>();
            for (Pair<String, String> doc : EdgeRole.getRoleToDocMap().values()) {
                docMap.put(doc.one(), doc.two());
            }
        }
        return docMap;
    }

    private static Map<EdgeRole, Pair<String, String>> computeRoleToDocMap() {
        EnumMap<EdgeRole, Pair<String, String>> result = new EnumMap<EdgeRole, Pair<String, String>>(EdgeRole.class);
        Field[] fieldArray = EdgeRole.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isEnumConstant()) {
                ToolTipHeader header;
                Syntax syntax;
                ToolTipPars pars;
                EdgeRole role = symbolToRoleMap.get(nameToSymbolMap.get(field.getName()));
                Help help = EdgeRole.createHelp();
                ToolTipBody body = field.getAnnotation(ToolTipBody.class);
                if (body != null) {
                    help.setBody(body.value());
                }
                if ((pars = field.getAnnotation(ToolTipPars.class)) != null) {
                    help.setPars(pars.value());
                }
                if ((syntax = field.getAnnotation(Syntax.class)) != null) {
                    help.setSyntax(syntax.value());
                }
                if ((header = field.getAnnotation(ToolTipHeader.class)) != null) {
                    help.setHeader(header.value());
                }
                result.put(role, Pair.newPair(help.getItem(), help.getTip()));
            }
            ++n2;
        }
        return result;
    }

    public static Help createHelp() {
        return new Help(nameToSymbolMap);
    }

    public static EdgeRole[] values() {
        EdgeRole[] edgeRoleArray = ENUM$VALUES;
        int n = edgeRoleArray.length;
        EdgeRole[] edgeRoleArray2 = new EdgeRole[n];
        System.arraycopy(ENUM$VALUES, 0, edgeRoleArray2, 0, n);
        return edgeRoleArray2;
    }

    public static EdgeRole valueOf(String string) {
        return Enum.valueOf(EdgeRole.class, string);
    }
}

