/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.gui.dialog.PropertyKey;
import groove.util.DefaultFixable;
import groove.util.ExprParser;
import groove.util.Fixable;
import groove.util.Groove;
import groove.util.Property;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

public class GraphProperties
extends Properties
implements Fixable {
    private final DefaultFixable fixable = new DefaultFixable();
    private static final Map<String, Key> KEYS;

    static {
        LinkedHashMap<String, Key> keys = new LinkedHashMap<String, Key>();
        Key[] keyArray = Key.values();
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray[n2];
            keys.put(key.getName(), key);
            ++n2;
        }
        KEYS = Collections.unmodifiableMap(keys);
    }

    public GraphProperties() {
    }

    public GraphProperties(Map<? extends Object, ? extends Object> properties) {
        this.putAll(properties);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (!GraphProperties.isValidKey(key)) {
            throw new IllegalArgumentException(String.format("User property key '%s' not allowed: use identifier", key));
        }
        return super.put(key, value);
    }

    @Override
    public synchronized String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isEmpty()) {
            result.append("No stored properties");
        } else {
            result.append("Properties:\n");
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                result.append("  " + entry + "\n");
            }
        }
        return result.toString();
    }

    @Override
    public synchronized GraphProperties clone() {
        return new GraphProperties((Map<? extends Object, ? extends Object>)this);
    }

    public String getProperty(Key key) {
        String result = this.getProperty(key.getName());
        if (result == null) {
            result = key.getDefaultValue();
        }
        return result;
    }

    @Override
    public String setProperty(String keyword, String value) {
        this.testFixed(false);
        Key key = KEYS.get(keyword);
        String oldValue = value == null ? (String)this.remove(keyword) : (key != null && !key.isSystem() && key.getDefaultValue().equals(value) ? (String)this.remove(keyword) : (String)super.setProperty(keyword, value));
        return oldValue;
    }

    public String setProperty(Key key, String value) {
        return this.setProperty(key.getName(), value);
    }

    @Override
    public boolean setFixed() {
        return this.fixable.setFixed();
    }

    @Override
    public boolean isFixed() {
        return this.fixable.isFixed();
    }

    @Override
    public void testFixed(boolean fixed) {
        this.fixable.testFixed(fixed);
    }

    private static boolean isSystemKey(String keyword) {
        return GraphProperties.isKey(keyword) && KEYS.get(keyword).isSystem();
    }

    public static boolean isValidUserKey(String key) {
        return ExprParser.isIdentifier(key);
    }

    private static boolean isValidKey(Object key) {
        return key instanceof String && (GraphProperties.isSystemKey((String)key) || GraphProperties.isValidUserKey((String)key));
    }

    public static Map<String, Key> getKeyMap() {
        return Collections.unmodifiableMap(KEYS);
    }

    public static boolean isKey(String key) {
        return KEYS.containsKey(key);
    }

    public static enum Key implements PropertyKey
    {
        PRIORITY("priority", Integer.toString(0), new Property<String>(){

            @Override
            public boolean isSatisfied(String value) {
                try {
                    return Integer.parseInt(value) >= 0;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }

            @Override
            public String getDescription() {
                return "Non-negative number; higher priorities have precedence";
            }

            @Override
            public String getComment() {
                return "Higher-priority rules are evaluated first";
            }
        }),
        ENABLED("enabled", Boolean.toString(true), new Property<String>(){

            @Override
            public boolean isSatisfied(String value) {
                return value.equals("true") || value.equals("false");
            }

            @Override
            public String getDescription() {
                return "Boolean value";
            }

            @Override
            public String getComment() {
                return "Disabled rules are never evaluated";
            }
        }),
        REMARK("remark", "", new Property<String>(){

            @Override
            public boolean isSatisfied(String value) {
                return value.trim().length() > 0;
            }

            @Override
            public String getDescription() {
                return "One-line description of the purpose of the graph or rule";
            }

            @Override
            public String getComment() {
                return "A one-line description of the rule, shown e.g. as tool tip";
            }
        }),
        FORMAT("printFormat", null, "Output format", null, new Property<String>(){

            @Override
            public boolean isSatisfied(String value) {
                return value.trim().length() > 0;
            }

            @Override
            public String getDescription() {
                return "Format string as in String.format, instantiated by rule parameters";
            }

            @Override
            public String getComment() {
                return "If nonempty, rule application prints this (instantiated) string on System.out";
            }
        }, false),
        TRANSITION_LABEL("transitionLabel", new Property<String>(){

            @Override
            public boolean isSatisfied(String value) {
                return true;
            }

            @Override
            public String getDescription() {
                return "Format string as in String.format, instantiated by rule parameters";
            }

            @Override
            public String getComment() {
                return "A string to be used as the transition label in the LTS. If empty, defaults to the rule name.";
            }
        }),
        VERSION("version", "", null, true);

        private final String name;
        private final String category;
        private final String description;
        private final String defaultValue;
        private final boolean system;
        private final Property<String> format;
        private static final char SYSTEM_KEY_START = '$';

        private Key(String name, Property<String> format) {
            this(name, null, format, false);
        }

        private Key(String name, String defaultValue, Property<String> format) {
            this(name, defaultValue, format, false);
        }

        private Key(String name, String defaultValue, Property<String> format, boolean system) {
            this(name, null, Groove.unCamel(name, false), defaultValue, format, system);
        }

        private Key(String name, String category, String description, String defaultValue, Property<String> format, boolean system) {
            this.name = (system ? Character.valueOf('$') : "") + name;
            this.defaultValue = defaultValue == null ? "" : defaultValue;
            this.category = category;
            this.description = description;
            this.system = system;
            this.format = format;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean isSystem() {
            return this.system;
        }

        @Override
        public Property<String> getFormat() {
            return this.format;
        }
    }
}

