/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.Edge;
import groove.graph.ElementFactory;
import groove.graph.Label;
import groove.graph.Node;
import groove.util.collect.TreeHashSet;
import java.util.Arrays;

public abstract class StoreFactory<N extends Node, E extends Edge, L extends Label>
implements ElementFactory<N, E> {
    private int nodeCount;
    private int nextNodeNr;
    private int maxNodeNr = -1;
    private N[] nodes = new Node[100];
    private final TreeHashSet<E> edgeStore = this.createEdgeStore();
    private static final int INIT_CAPACITY = 100;
    private static final float GROWTH_FACTOR = 2.0f;

    protected StoreFactory() {
    }

    public N createNode() {
        return this.createNode(this.getNextNodeNr());
    }

    @Override
    public N createNode(int nr) {
        N result;
        assert (nr >= 0);
        if (nr >= this.nodes.length || this.nodes[nr] == null) {
            result = this.newNode(nr);
            this.addNode((Node)result);
        } else {
            result = this.nodes[nr];
        }
        return result;
    }

    protected abstract N newNode(int var1);

    public N getNode(int nr) {
        assert (nr >= 0 && nr < this.nodes.length);
        N result = this.nodes[nr];
        assert (result != null);
        return result;
    }

    public boolean addNode(Node node) throws IllegalArgumentException {
        int nr = node.getNumber();
        if (nr < this.nodes.length && this.nodes[nr] != null && node != this.nodes[nr]) {
            throw new IllegalArgumentException(String.format("Duplicate nodes %s and %s with the same number %d", node, this.nodes[nr], nr));
        }
        if (nr >= this.nodes.length) {
            int newSize = Math.max((int)((float)this.nodes.length * 2.0f), nr + 1);
            Node[] newNodes = new Node[newSize];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            this.nodes = newNodes;
        }
        if (this.nodes[nr] == null) {
            this.nodes[nr] = node;
            ++this.nodeCount;
            this.maxNodeNr = Math.max(this.maxNodeNr, nr);
            return true;
        }
        return false;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public void clear() {
        Arrays.fill(this.nodes, null);
        this.nodeCount = 0;
        this.nextNodeNr = 0;
        this.maxNodeNr = -1;
        this.edgeStore.clear();
    }

    public int getNextNodeNr() {
        while (this.nextNodeNr < this.nodes.length && this.nodes[this.nextNodeNr] != null) {
            ++this.nextNodeNr;
        }
        return this.nextNodeNr;
    }

    @Override
    public int getMaxNodeNr() {
        return this.maxNodeNr;
    }

    public Node getNodeFromNr(int nr) {
        return this.nodes[nr];
    }

    public abstract L createLabel(String var1);

    @Override
    public E createEdge(N source, String text, N target) {
        return this.createEdge(source, (Label)this.createLabel(text), target);
    }

    @Override
    public E createEdge(N source, Label label, N target) {
        assert (source != null) : "Source node of host edge should not be null";
        assert (target != null) : "Target node of host edge should not be null";
        E edge = this.newEdge(source, label, target, this.getEdgeCount());
        return this.storeEdge(edge);
    }

    protected abstract E newEdge(N var1, Label var2, N var3, int var4);

    protected E storeEdge(E edge) {
        Edge result = (Edge)this.edgeStore.put(edge);
        if (result == null) {
            result = edge;
        }
        return (E)result;
    }

    public boolean addEdge(E edge) throws IllegalArgumentException {
        Edge oldEdge = (Edge)this.edgeStore.put(edge);
        if (oldEdge != null && oldEdge != edge) {
            throw new IllegalArgumentException(String.format("Duplicate edges %s", edge));
        }
        return oldEdge == null;
    }

    public int getEdgeCount() {
        return this.edgeStore.size();
    }

    protected TreeHashSet<E> createEdgeStore() {
        return new TreeHashSet<E>(){

            @Override
            protected final boolean areEqual(E o1, E o2) {
                return o1.source().equals(o2.source()) && o1.target().equals(o2.target()) && o1.label().equals(o2.label());
            }

            @Override
            protected final boolean allEqual() {
                return false;
            }
        };
    }
}

