/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.iso;

import groove.graph.AElementMap;
import groove.graph.AGraph;
import groove.graph.Edge;
import groove.graph.EdgeComparator;
import groove.graph.Element;
import groove.graph.Graph;
import groove.graph.Morphism;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.graph.iso.PartitionMap;
import groove.graph.iso.PartitionRefiner;
import groove.graph.plain.PlainEdge;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainMorphism;
import groove.graph.plain.PlainNode;
import groove.util.Groove;
import groove.util.Reporter;
import groove.util.collect.HashBag;
import groove.util.collect.SmallCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class IsoChecker {
    private final boolean strong;
    private static IsoChecker strongInstance;
    private static IsoChecker weakInstance;
    private static int totalCheckCount;
    private static int distinctSizeCount;
    private static int equalGraphsCount;
    private static int equalCertsCount;
    private static int distinctCertsCount;
    private static int equalSimCount;
    private static int intCertOverlap;
    private static int distinctSimCount;
    private static final boolean ISO_PRINT = false;
    private static final boolean TEST_FALSE_NEGATIVES = false;
    private static final boolean SAVE_FALSE_NEGATIVES = false;
    private static final boolean ISO_ASSERT = false;
    public static final Reporter reporter;
    public static final Reporter areIsoReporter;
    static final Reporter isoCertCheckReporter;
    static final Reporter isoSimCheckReporter;
    static final Reporter equalsTestReporter;
    private final CertificateStrategy certificateFactory = new PartitionRefiner(null);

    static {
        intCertOverlap = 0;
        reporter = Reporter.register(IsoChecker.class);
        areIsoReporter = reporter.register("areIsomorphic(Graph,Graph)");
        isoCertCheckReporter = reporter.register("Isomorphism by certificates");
        isoSimCheckReporter = reporter.register("Isomorphism by simulation");
        equalsTestReporter = reporter.register("Equality test");
    }

    protected IsoChecker(boolean strong) {
        this.strong = strong;
    }

    public <N extends Node, E extends Edge> boolean areIsomorphic(Graph dom, Graph cod) {
        return this.areIsomorphic(dom, cod, null, null);
    }

    public <N extends Node, E extends Edge> boolean areIsomorphic(Graph dom, Graph cod, Node[] domNodes, Node[] codNodes) {
        boolean result;
        if (domNodes == null != (codNodes == null) || domNodes != null && domNodes.length != codNodes.length) {
            result = false;
        } else if (this.areGraphEqual(dom, cod, domNodes, codNodes)) {
            ++equalGraphsCount;
            result = true;
        } else {
            areIsoReporter.start();
            CertificateStrategy domCertifier = this.getCertifier(dom, true);
            CertificateStrategy codCertifier = this.getCertifier(cod, true);
            result = this.areIsomorphic(domCertifier, codCertifier, domNodes, codNodes);
            areIsoReporter.stop();
        }
        ++totalCheckCount;
        return result;
    }

    private <N extends Node, E extends Edge> boolean areGraphEqual(Graph dom, Graph cod, Node[] domNodes, Node[] codNodes) {
        boolean result;
        equalsTestReporter.start();
        boolean bl = result = domNodes == null || Arrays.equals(domNodes, codNodes);
        if (result) {
            CertificateStrategy domCertifier = this.getCertifier(dom, false);
            CertificateStrategy codCertifier = this.getCertifier(cod, false);
            int domNodeCount = domCertifier == null ? dom.nodeCount() : domCertifier.getNodeCertificates().length;
            int codNodeCount = codCertifier == null ? cod.nodeCount() : codCertifier.getNodeCertificates().length;
            boolean bl2 = result = domNodeCount == codNodeCount;
            if (result) {
                Set<Element> domEdgeSet;
                Set<Element> codEdgeSet;
                if (domCertifier == null || codCertifier == null) {
                    codEdgeSet = new HashSet<Edge>(cod.edgeSet());
                    domEdgeSet = dom.edgeSet();
                } else {
                    codEdgeSet = codCertifier.getCertificateMap().keySet();
                    domEdgeSet = domCertifier.getCertificateMap().keySet();
                }
                result = domEdgeSet.equals(codEdgeSet);
            }
        }
        equalsTestReporter.stop();
        return result;
    }

    private <N extends Node, E extends Edge> boolean areIsomorphic(CertificateStrategy domCertifier, CertificateStrategy codCertifier, N[] domNodes, N[] codNodes) {
        boolean result;
        if (!domCertifier.getGraphCertificate().equals(codCertifier.getGraphCertificate())) {
            ++intCertOverlap;
            result = false;
        } else if (this.hasDiscreteCerts(codCertifier)) {
            isoCertCheckReporter.start();
            if (this.hasDiscreteCerts(domCertifier)) {
                result = this.areCertEqual(domCertifier, codCertifier, (Node[])domNodes, (Node[])codNodes);
            } else {
                ++distinctCertsCount;
                result = false;
            }
            isoCertCheckReporter.stop();
            if (result) {
                ++equalCertsCount;
            } else {
                ++distinctCertsCount;
            }
        } else {
            isoSimCheckReporter.start();
            if (this.getNodePartitionCount(domCertifier) == this.getNodePartitionCount(codCertifier)) {
                result = this.hasIsomorphism(domCertifier, codCertifier, (Node[])domNodes, (Node[])codNodes);
            } else {
                ++distinctCertsCount;
                result = false;
            }
            isoSimCheckReporter.stop();
            if (result) {
                ++equalSimCount;
            } else {
                ++distinctSimCount;
            }
        }
        return result;
    }

    private boolean areCertEqual(CertificateStrategy dom, CertificateStrategy cod, Node[] domNodes, Node[] codNodes) {
        boolean result;
        Morphism<Node, Edge> iso = this.getCertEqualIsomorphism(dom, cod);
        boolean bl = result = iso != null;
        if (result && domNodes != null) {
            int i = 0;
            while (result && i < domNodes.length) {
                result = iso.getNode(domNodes[i]).equals(codNodes[i]);
                ++i;
            }
        }
        return result;
    }

    private Morphism<Node, Edge> getCertEqualIsomorphism(CertificateStrategy dom, CertificateStrategy cod) {
        Morphism<Node, Edge> result = dom.getGraph().getFactory().createMorphism();
        CertificateStrategy.EdgeCertificate[] edgeCerts = dom.getEdgeCertificates();
        PartitionMap<Edge> codPartitionMap = cod.getEdgePartitionMap();
        int edgeCount = edgeCerts.length;
        int i = 0;
        while (i < edgeCount && edgeCerts[i] != null) {
            CertificateStrategy.EdgeCertificate domEdgeCert = edgeCerts[i];
            SmallCollection<Edge> image = codPartitionMap.get(domEdgeCert);
            if (image == null) {
                result = null;
                break;
            }
            Edge edgeKey = (Edge)domEdgeCert.getElement();
            Edge edgeImage = image.getSingleton();
            Node imageSource = edgeImage.source();
            Node oldImageSource = result.putNode(edgeKey.source(), imageSource);
            if (oldImageSource != null && !oldImageSource.equals(imageSource)) {
                result = null;
                break;
            }
            Node imageTarget = edgeImage.target();
            Node oldImageTarget = result.putNode(edgeKey.target(), imageTarget);
            if (oldImageTarget != null && !oldImageTarget.equals(imageTarget)) {
                result = null;
                break;
            }
            result.putEdge(edgeKey, edgeImage);
            ++i;
        }
        return result;
    }

    private boolean hasIsomorphism(CertificateStrategy domCertifier, CertificateStrategy codCertifier, Node[] domNodes, Node[] codNodes) {
        boolean result;
        IsoCheckerState state = new IsoCheckerState();
        do {
            Morphism iso;
            boolean bl = result = (iso = this.computeIsomorphism(domCertifier, codCertifier, state)) != null;
            if (!result || domNodes == null) break;
            int i = 0;
            while (result && i < domNodes.length) {
                result = iso.getNode(domNodes[i]).equals(codNodes[i]);
                ++i;
            }
        } while (!result);
        return result;
    }

    public <N extends Node, E extends Edge> Morphism<N, E> getIsomorphism(Graph dom, Graph cod) {
        return this.getIsomorphism(this.getCertifier(dom, true), this.getCertifier(cod, true), null);
    }

    public <N extends Node, E extends Edge> Morphism<N, E> getIsomorphism(Graph dom, Graph cod, IsoCheckerState state) {
        return this.getIsomorphism(this.getCertifier(dom, true), this.getCertifier(cod, true), state);
    }

    private <N extends Node, E extends Edge> Morphism<N, E> getIsomorphism(CertificateStrategy domCertifier, CertificateStrategy codCertifier, IsoCheckerState state) {
        Morphism<N, E> result = this.computeIsomorphism(domCertifier, codCertifier, state);
        if (result != null && result.nodeMap().size() != domCertifier.getGraph().nodeCount()) {
            CertificateStrategy.NodeCertificate[] nodeCerts;
            PartitionMap<Node> codPartitionMap = codCertifier.getNodePartitionMap();
            HashSet<Node> usedNodeImages = new HashSet<Node>();
            CertificateStrategy.NodeCertificate[] nodeCertificateArray = nodeCerts = domCertifier.getNodeCertificates();
            int n = nodeCerts.length;
            int n2 = 0;
            while (n2 < n) {
                CertificateStrategy.NodeCertificate nodeCert = nodeCertificateArray[n2];
                Node node = (Node)nodeCert.getElement();
                if (!result.nodeMap().containsKey(node)) {
                    SmallCollection<Node> nodeImages = codPartitionMap.get(nodeCert);
                    if (nodeImages.isSingleton()) {
                        result.putNode(node, nodeImages.getSingleton());
                        break;
                    }
                    for (Node nodeImage : nodeImages) {
                        if (!usedNodeImages.add(nodeImage)) continue;
                        result.putNode(node, nodeImage);
                        break;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private <N extends Node, E extends Edge> Morphism<N, E> computeIsomorphism(CertificateStrategy domCertifier, CertificateStrategy codCertifier, IsoCheckerState state) {
        Object result;
        HashSet<Node> usedNodeImages;
        List<IsoSearchItem> plan;
        Graph dom = domCertifier.getGraph();
        Graph cod = codCertifier.getGraph();
        if (dom.nodeCount() != cod.nodeCount() || dom.edgeCount() != cod.edgeCount()) {
            return null;
        }
        if (domCertifier.getNodeCertificates().length != codCertifier.getNodeCertificates().length || domCertifier.getEdgeCertificates().length != codCertifier.getEdgeCertificates().length) {
            return null;
        }
        if (this.hasDiscreteCerts(domCertifier)) {
            if (state != null) {
                if (state.foundCertBijection) {
                    return null;
                }
                state.foundCertBijection = true;
            }
            return this.getCertEqualIsomorphism(domCertifier, codCertifier);
        }
        if (state != null && state.plan != null) {
            plan = state.plan;
            if (state.result == null || state.i == plan.size()) {
                return null;
            }
            usedNodeImages = new HashSet<Node>(state.usedNodeImages);
            result = state.result.clone();
        } else {
            result = domCertifier.getGraph().getFactory().createMorphism();
            usedNodeImages = new HashSet<Node>();
            plan = this.computePlan(domCertifier, codCertifier, (Morphism<Node, Edge>)result, (Set<Node>)usedNodeImages);
        }
        if (plan == null) {
            return null;
        }
        Iterator[] records = state != null && state.records != null ? state.records : new Iterator[plan.size()];
        Node[] sourceImages = state != null && state.sourceImages != null ? state.sourceImages : new Node[plan.size()];
        Node[] targetImages = state != null && state.targetImages != null ? state.targetImages : new Node[plan.size()];
        int i = state != null ? state.i : 0;
        while (i >= 0 && i < records.length) {
            IsoSearchItem item = plan.get(i);
            if (records[i] == null) {
                records[i] = item.images.iterator();
            } else {
                boolean removed;
                if (!item.sourcePreMatched && sourceImages[i] != null) {
                    removed = usedNodeImages.remove(sourceImages[i]);
                    assert (removed) : String.format("Image %s for source %s not present in used node set %s", sourceImages[i], item.key.source(), usedNodeImages);
                    sourceImages[i] = null;
                }
                if (!item.targetPreMatched && targetImages[i] != null) {
                    removed = usedNodeImages.remove(targetImages[i]);
                    assert (removed) : String.format("Image %s for target %s not present in used node set %s", targetImages[i], item.key.target(), usedNodeImages);
                    targetImages[i] = null;
                }
            }
            if (!records[i].hasNext()) {
                records[i] = null;
                --i;
                continue;
            }
            Edge key = item.key;
            Node keyTarget = key.target();
            Node keySource = key.source();
            Edge image = (Edge)records[i].next();
            Node imageSource = image.source();
            Node imageTarget = image.target();
            if (item.sourcePreMatched) {
                if (!((AElementMap)result).getNode(keySource).equals(imageSource)) {
                    continue;
                }
            } else {
                if (!usedNodeImages.add(imageSource)) continue;
                ((AElementMap)result).putNode(keySource, imageSource);
                sourceImages[i] = imageSource;
            }
            if (item.targetPreMatched) {
                if (!((AElementMap)result).getNode(keyTarget).equals(imageTarget)) {
                    if (item.sourcePreMatched) continue;
                    usedNodeImages.remove(sourceImages[i]);
                    sourceImages[i] = null;
                    continue;
                }
            } else {
                if (!usedNodeImages.add(imageTarget)) {
                    if (item.sourcePreMatched) continue;
                    usedNodeImages.remove(sourceImages[i]);
                    sourceImages[i] = null;
                    continue;
                }
                ((AElementMap)result).putNode(keyTarget, imageTarget);
                targetImages[i] = imageTarget;
            }
            ((AElementMap)result).putEdge(key, image);
            ++i;
        }
        if (i < 0) {
            return null;
        }
        assert (this.checkIsomorphism(domCertifier.getGraph(), (Morphism<Node, Edge>)result)) : String.format("Erronous result using plan %s", plan);
        if (state != null) {
            state.plan = plan;
            state.result = ((Morphism)result).clone();
            state.usedNodeImages = new HashSet<Node>(usedNodeImages);
            state.sourceImages = sourceImages;
            state.targetImages = targetImages;
            state.records = records;
            state.i = i - 1;
        }
        return result;
    }

    private List<IsoSearchItem> computePlan(CertificateStrategy domCertifier, CertificateStrategy codCertifier, Morphism<Node, Edge> resultMap, Set<Node> usedNodeImages) {
        Graph dom = domCertifier.getGraph();
        ArrayList<IsoSearchItem> result = new ArrayList<IsoSearchItem>();
        PartitionMap<Edge> codPartitionMap = codCertifier.getEdgePartitionMap();
        HashMap<Edge, SmallCollection<Edge>> remainingEdgeSet = new HashMap<Edge, SmallCollection<Edge>>();
        HashSet<Node> connectedNodes = new HashSet<Node>();
        CertificateStrategy.EdgeCertificate[] edgeCerts = domCertifier.getEdgeCertificates();
        int edgeCount = edgeCerts.length;
        int i = 0;
        while (i < edgeCount && edgeCerts[i] != null) {
            CertificateStrategy.EdgeCertificate edgeCert = edgeCerts[i];
            SmallCollection<Edge> images = codPartitionMap.get(edgeCert);
            if (images == null) {
                return null;
            }
            if (images.isSingleton()) {
                if (!this.setEdge((Edge)edgeCert.getElement(), images.getSingleton(), resultMap, connectedNodes, usedNodeImages)) {
                    return null;
                }
            } else {
                remainingEdgeSet.put((Edge)edgeCert.getElement(), images);
            }
            ++i;
        }
        while (!remainingEdgeSet.isEmpty()) {
            Iterator remainingEdgeIter = remainingEdgeSet.entrySet().iterator();
            Map.Entry first = remainingEdgeIter.next();
            remainingEdgeIter.remove();
            TreeSet<IsoSearchItem> subPlan = new TreeSet<IsoSearchItem>();
            subPlan.add(new IsoSearchItem((Edge)first.getKey(), (Collection)first.getValue()));
            while (!subPlan.isEmpty()) {
                Node node;
                Iterator subIter = subPlan.iterator();
                IsoSearchItem next = (IsoSearchItem)subIter.next();
                subIter.remove();
                Node keySource = next.key.source();
                boolean bl = next.sourcePreMatched = !connectedNodes.add(keySource);
                if (!next.sourcePreMatched) {
                    for (Edge edge : dom.edgeSet(keySource)) {
                        Collection images = (Collection)remainingEdgeSet.remove(edge);
                        if (images == null) continue;
                        subPlan.add(new IsoSearchItem(edge, images));
                    }
                }
                boolean bl2 = next.targetPreMatched = !connectedNodes.add(node = next.key.target());
                if (!next.targetPreMatched) {
                    for (Edge edge : dom.edgeSet(node)) {
                        Collection images = (Collection)remainingEdgeSet.remove(edge);
                        if (images == null) continue;
                        subPlan.add(new IsoSearchItem(edge, images));
                    }
                }
                result.add(next);
            }
        }
        return result;
    }

    private boolean setEdge(Edge key, Edge value, Morphism<Node, Edge> result, Set<Node> connectedNodes, Set<Node> usedCodNodes) {
        if (!this.setNode(key.source(), value.source(), result, connectedNodes, usedCodNodes)) {
            return false;
        }
        if (!this.setNode(key.target(), value.target(), result, connectedNodes, usedCodNodes)) {
            return false;
        }
        result.putEdge(key, value);
        return true;
    }

    private boolean setNode(Node end, Node endImage, Morphism<Node, Edge> result, Set<Node> connectedNodes, Set<Node> usedCodNodes) {
        Node oldEndImage = result.putNode(end, endImage);
        if (oldEndImage == null ? !usedCodNodes.add(endImage) : oldEndImage != endImage) {
            return false;
        }
        connectedNodes.add(end);
        return true;
    }

    private boolean hasDiscreteCerts(CertificateStrategy certifier) {
        return certifier.getNodePartitionMap().isOneToOne();
    }

    private int getNodePartitionCount(CertificateStrategy certifier) {
        return certifier.getNodePartitionCount();
    }

    public CertificateStrategy getCertifier(Graph graph, boolean always) {
        CertificateStrategy result = null;
        if (graph instanceof AGraph) {
            if (always || ((AGraph)graph).hasCertifier(this.isStrong())) {
                result = ((AGraph)graph).getCertifier(this.isStrong());
            }
        } else if (always) {
            result = AGraph.getCertificateFactory().newInstance(graph, this.isStrong());
        }
        return result;
    }

    private boolean checkIsomorphism(Graph dom, Morphism<Node, Edge> map) {
        for (Edge edge : dom.edgeSet()) {
            if (edge.source() == edge.target() || map.edgeMap().containsKey(edge)) continue;
            System.out.printf("Result contains no image for %s%n", edge);
            return false;
        }
        for (Map.Entry entry : map.edgeMap().entrySet()) {
            Edge key = (Edge)entry.getKey();
            Node keySource = key.source();
            Node keyTarget = key.target();
            Edge value = (Edge)entry.getValue();
            if (!map.getNode(keySource).equals(value.source())) {
                System.out.printf("Edge %s mapped to %s, but source mapped to %s%n", key, value, keySource, map.getNode(keySource));
                return false;
            }
            if (map.getNode(keyTarget).equals(value.target())) continue;
            System.out.printf("Edge %s mapped to %s, but end %s mapped to %s%n", key, value, key.target(), map.getNode(keyTarget));
            return false;
        }
        if (map.nodeMap().size() != new HashSet<Node>(map.nodeMap().values()).size()) {
            for (Map.Entry entry : map.nodeMap().entrySet()) {
                for (Map.Entry<Node, Node> second : map.nodeMap().entrySet()) {
                    if (entry == second || entry.getValue() != second.getValue()) continue;
                    System.out.printf("Image of %s and %s both %s%n", entry.getKey(), second.getKey(), entry.getValue());
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkBisimulator(Graph dom, Graph cod, boolean result) {
        if (result && this.isStrong()) {
            PartitionRefiner domBis = new PartitionRefiner(dom, this.isStrong());
            PartitionRefiner codBis = new PartitionRefiner(cod, this.isStrong());
            HashBag<CertificateStrategy.NodeCertificate> domNodes = new HashBag<CertificateStrategy.NodeCertificate>(Arrays.asList(domBis.getNodeCertificates()));
            HashBag<CertificateStrategy.EdgeCertificate> domEdges = new HashBag<CertificateStrategy.EdgeCertificate>(Arrays.asList(domBis.getEdgeCertificates()));
            HashBag<CertificateStrategy.NodeCertificate> codNodes = new HashBag<CertificateStrategy.NodeCertificate>(Arrays.asList(codBis.getNodeCertificates()));
            HashBag<CertificateStrategy.EdgeCertificate> codEdges = new HashBag<CertificateStrategy.EdgeCertificate>(Arrays.asList(codBis.getEdgeCertificates()));
            HashBag<CertificateStrategy.NodeCertificate> domMinCodNodes = new HashBag<CertificateStrategy.NodeCertificate>(domNodes);
            domMinCodNodes.removeAll(codNodes);
            assert (domMinCodNodes.isEmpty()) : String.format("Node certificates %s in dom but not cod", domMinCodNodes);
            HashBag<CertificateStrategy.NodeCertificate> codMinDomNodes = new HashBag<CertificateStrategy.NodeCertificate>(codNodes);
            codMinDomNodes.removeAll(domNodes);
            assert (codMinDomNodes.isEmpty()) : String.format("Node certificates %s in cod but not cod", codMinDomNodes);
            HashBag<CertificateStrategy.EdgeCertificate> domMinCodEdges = new HashBag<CertificateStrategy.EdgeCertificate>(domEdges);
            domMinCodEdges.removeAll(codEdges);
            assert (domMinCodEdges.isEmpty()) : String.format("Edge certificates %s in dom but not cod", domMinCodEdges);
            HashBag<CertificateStrategy.EdgeCertificate> codMinDomEdges = new HashBag<CertificateStrategy.EdgeCertificate>(codEdges);
            codMinDomEdges.removeAll(domEdges);
            assert (codMinDomEdges.isEmpty()) : String.format("Edge certificates %s in cod but not cod", codMinDomEdges);
        }
        return true;
    }

    public synchronized boolean isStrong() {
        return this.strong;
    }

    public static IsoChecker getInstance(boolean strong) {
        if (strongInstance == null) {
            strongInstance = new IsoChecker(true);
            weakInstance = new IsoChecker(false);
        }
        return strong ? strongInstance : weakInstance;
    }

    public static int getIntCertOverlap() {
        return intCertOverlap;
    }

    public static long getTotalTime() {
        return IsoChecker.getIsoCheckTime() + IsoChecker.getCertifyingTime();
    }

    public static long getCertifyingTime() {
        return PartitionRefiner.computeCertReporter.getTotalTime() + PartitionRefiner.getPartitionReporter.getTotalTime();
    }

    public static long getIsoCheckTime() {
        return areIsoReporter.getTotalTime();
    }

    public static long getEqualCheckTime() {
        return equalsTestReporter.getTotalTime();
    }

    public static long getCertCheckTime() {
        return isoCertCheckReporter.getTotalTime();
    }

    public static long getSimCheckTime() {
        return isoSimCheckReporter.getTotalTime();
    }

    public static int getTotalCheckCount() {
        return totalCheckCount;
    }

    public static int getDistinctSizeCount() {
        return distinctSizeCount;
    }

    public static int getEqualGraphsCount() {
        return equalGraphsCount;
    }

    public static int getEqualCertsCount() {
        return equalCertsCount;
    }

    public static int getDistinctCertsCount() {
        return distinctCertsCount;
    }

    public static int getEqualSimCount() {
        return equalSimCount;
    }

    public static int getDistinctSimCount() {
        return distinctSimCount;
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            IsoChecker.testIso(args[0]);
        } else if (args.length == 2) {
            IsoChecker.compareGraphs(args[0], args[1]);
        } else {
            System.out.println("Usage: DefaultIsoChecker file1 file2");
            return;
        }
    }

    private static void testIso(String name) {
        try {
            PlainGraph graph1 = Groove.loadGraph(name);
            IsoChecker checker = IsoChecker.getInstance(true);
            System.out.printf("Graph certificate: %s%n", checker.getCertifier(graph1, true).getGraphCertificate());
            int i = 0;
            while (i < 1000) {
                PlainGraph graph2 = new PlainGraph(name);
                PlainMorphism nodeMap = new PlainMorphism();
                for (PlainNode plainNode : graph1.nodeSet()) {
                    PlainNode newNode = (PlainNode)graph2.addNode();
                    nodeMap.putNode(plainNode, newNode);
                }
                for (PlainEdge plainEdge : graph1.edgeSet()) {
                    graph2.addEdgeContext((PlainEdge)nodeMap.mapEdge(plainEdge));
                }
                if (!checker.areIsomorphic(graph1, graph2)) {
                    System.out.println("Error! Graph not isomorphic to itself");
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void compareGraphs(String name1, String name2) {
        try {
            PlainGraph graph1 = Groove.loadGraph(name1);
            PlainGraph graph2 = Groove.loadGraph(name2);
            System.out.printf("Graphs '%s' and '%s' isomorphic?%n", name1, name2);
            System.out.printf("Done. Result: %b%n", IsoChecker.getInstance(true).areIsomorphic(graph1, graph2));
            System.out.printf("Certification time: %d%n", IsoChecker.getCertifyingTime());
            System.out.printf("Simulation time: %d%n", IsoChecker.getSimCheckTime());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class IsoCheckerState {
        List<IsoSearchItem> plan = null;
        Set<Node> usedNodeImages = null;
        Iterator<Edge>[] records = null;
        Node[] sourceImages = null;
        Node[] targetImages = null;
        Morphism<Node, Edge> result = null;
        int i = 0;
        boolean foundCertBijection;

        public boolean isPlanEmpty() {
            return this.plan == null || this.plan.size() == 0;
        }
    }

    private class IsoSearchItem
    extends IsoSearchPair {
        boolean sourcePreMatched;
        boolean targetPreMatched;

        public IsoSearchItem(Edge key, Collection<Edge> images) {
            super(key, images);
        }

        @Override
        public int compareTo(IsoSearchPair o) {
            int result = ((IsoSearchItem)o).getPreMatchCount() - this.getPreMatchCount();
            if (result == 0) {
                result = super.compareTo(o);
            }
            return result;
        }

        private int getPreMatchCount() {
            int preMatchCount = 0;
            if (this.sourcePreMatched) {
                ++preMatchCount;
            }
            if (this.targetPreMatched) {
                ++preMatchCount;
            }
            return preMatchCount;
        }

        public String toString() {
            return String.format("(%s,%s,%s,%s)", this.key, this.images, this.sourcePreMatched, this.targetPreMatched);
        }
    }

    private class IsoSearchPair
    implements Comparable<IsoSearchPair> {
        final Edge key;
        final Collection<Edge> images;

        public IsoSearchPair(Edge key, Collection<Edge> images) {
            this.key = key;
            this.images = images;
        }

        @Override
        public int compareTo(IsoSearchPair o) {
            int result = this.images.size() - o.images.size();
            if (result == 0) {
                result = EdgeComparator.instance().compare(this.key, o.key);
            }
            return result;
        }
    }
}

