/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.plain;

import groove.graph.Label;
import groove.graph.Morphism;
import groove.graph.StoreFactory;
import groove.graph.plain.PlainEdge;
import groove.graph.plain.PlainLabel;
import groove.graph.plain.PlainNode;
import java.util.HashMap;
import java.util.Map;

public class PlainFactory
extends StoreFactory<PlainNode, PlainEdge, PlainLabel> {
    private final Map<String, PlainLabel> labelMap = new HashMap<String, PlainLabel>();
    private int freshLabelIndex;
    private static PlainFactory instance;

    protected PlainFactory() {
    }

    @Override
    protected PlainNode newNode(int nr) {
        return new PlainNode(nr);
    }

    public PlainLabel createFreshLabel() {
        String text;
        do {
            ++this.freshLabelIndex;
        } while (this.labelMap.get(text = "L" + this.freshLabelIndex) != null);
        return this.createLabel(text);
    }

    @Override
    public PlainLabel createLabel(String text) {
        PlainLabel result = this.labelMap.get(text);
        if (result == null) {
            int index = this.labelMap.size();
            result = new PlainLabel(text, index);
            this.labelMap.put(text, result);
            return result;
        }
        return result;
    }

    @Override
    public Morphism<PlainNode, PlainEdge> createMorphism() {
        return new Morphism<PlainNode, PlainEdge>(this);
    }

    @Override
    public void clear() {
        super.clear();
        this.labelMap.clear();
    }

    @Override
    protected PlainEdge newEdge(PlainNode source, Label label, PlainNode target, int nr) {
        return new PlainEdge(source, (PlainLabel)label, target, nr);
    }

    public static PlainFactory instance() {
        if (instance == null) {
            instance = new PlainFactory();
        }
        return instance;
    }
}

