/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import groove.grammar.model.FormatException;
import groove.grammar.model.ResourceKind;
import groove.gui.BehaviourOption;
import groove.io.store.EditType;
import groove.util.ExprParser;
import groove.util.Groove;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.jgraph.graph.GraphConstants;

public class Options
implements Cloneable {
    private final Map<String, JMenuItem> itemMap = new LinkedHashMap<String, JMenuItem>();
    public static final Font DEFAULT_FONT;
    public static final Font LABEL_FONT;
    public static final Font SYMBOL_FONT;
    public static final String EDIT_MENU_NAME = "Edit";
    public static final int EDIT_MENU_MNEMONIC = 69;
    public static final String DISPLAY_MENU_NAME = "View";
    public static final int DISPLAY_MENU_MNEMONIC = 86;
    public static final String EXPLORE_MENU_NAME = "Explore";
    public static final int EXPLORE_MENU_MNEMONIC = 88;
    public static final String FILE_MENU_NAME = "File";
    public static final int FILE_MENU_MNEMONIC = 70;
    public static final String NEW_MENU_NAME = "New";
    public static final String OPEN_RECENT_MENU_NAME = "Load Recent Grammar";
    public static final int OPEN_RECENT_MENU_MNEMONIC = 82;
    public static final String HELP_MENU_NAME = "Help";
    public static final int HELP_MENU_MNEMONIC = 72;
    public static final String CREATE_MENU_NAME = "New";
    public static final int CREATE_MENU_MNEMONIC = 78;
    public static final String OPTIONS_MENU_NAME = "Options";
    public static final int OPTIONS_MENU_MNEMONIC = 79;
    public static final String PROPERTIES_MENU_NAME = "Properties";
    public static final int PROPERTIES_MENU_MNEMONIC = 80;
    public static final String SET_LINE_STYLE_MENU = "Set Line Style";
    public static final String SET_LAYOUT_MENU_NAME = "Set layouter";
    public static final String SHOW_HIDE_MENU_NAME = "Show/Hide";
    public static final int SHOW_HIDE_MENU_MNEMONIC = 83;
    public static final String VERIFY_MENU_NAME = "Verify";
    public static final int VERIFY_MENU_MNEMONIC = 89;
    public static final String EXTERNAL_MENU_NAME = "External";
    public static final String OK_BUTTON = "OK";
    public static final String CANCEL_BUTTON = "Cancel";
    public static final String USE_BUTTON = "Use";
    public static final String YES_BUTTON = "Yes";
    public static final String NO_BUTTON = "No";
    public static final String ALWAYS_BUTTON = "Always";
    public static final String NEVER_BUTTON = "Never";
    public static final String ASK_BUTTON = "Ask";
    public static final String LABEL_PANE_TITLE = "Labels";
    public static final String RULE_TREE_PANE_TITLE = "Rule nesting";
    public static final String STATES_PANE_TITLE = "Graphs";
    public static final String RULES_PANE_TITLE = "Rules";
    public static final String ABOUT_ACTION_NAME = "About";
    public static final String ADD_POINT_ACTION = "Add Point";
    public static final String ANIMATE_ACTION_NAME = "Animate State Exploration";
    public static final String APPLY_MATCH_ACTION_NAME = "Apply selected match";
    public static final String BACK_ACTION_NAME = "Step Back";
    public static final String CANCEL_EDIT_ACTION_NAME = "Cancel Edit";
    public static final String CHANGE_GRAPHS_ACTION_NAME = "Change Graphs";
    public static final String CHANGE_RULES_ACTION_NAME = "Change Rules";
    public static final String CHECK_CTL_FULL_ACTION_NAME = "Check CTL property (full state space)";
    public static final String CHECK_CTL_AS_IS_ACTION_NAME = "Check CTL property (current state space)";
    public static final String CHECK_LTL_ACTION_NAME = "Check LTL property (full state space)";
    public static final String CHECK_LTL_BOUNDED_ACTION_NAME = "Check LTL property (bounded state space)";
    public static final String CHECK_LTL_POCKET_ACTION_NAME = "Check LTL property (bounded pocket strategy)";
    public static final String CHECK_LTL_OPTIMIZED_ACTION_NAME = "Check LTL property (optimised bounded state space)";
    public static final String CHECK_LTL_OPTMIZED_POCKET_ACTION_NAME = "Check LTL property (optimised bounded pocket strategy)";
    public static final String CLOSE_ACTION_NAME = "Close";
    public static final String CLOSE_ALL_ACTION_NAME = "Close All Editors";
    public static final String CLOSE_THIS_ACTION_NAME = "Close This Editor";
    public static final String CLOSE_OTHER_ACTION_NAME = "Close Other Editors";
    public static final String COPY_ACTION_NAME = "Copy";
    public static final String CUT_ACTION_NAME = "Cut";
    public static final String EXPLORE_ACTION_NAME = "Explore State Space";
    public static final String DETACH_ACTION_NAME = "Detach";
    public static final String DELETE_ACTION_NAME = "Delete";
    public static final String EDIT_MODE_NAME = "Edit mode";
    public static final String EDIT_ACTION_NAME = "Edit ...";
    public static final String EDIT_LABEL_ACTION = "Edit Label";
    public static final String EDIT_STATE_ACTION_NAME = "Edit State ...";
    public static final String EXPLORATION_DIALOG_ACTION_NAME = "Customize Exploration ...";
    public static final String EXPLORATION_STATS_DIALOG_ACTION_NAME = "Last Exploration Statistics ...";
    public static final String LAYOUT_DIALOG_ACTION_NAME = "Customize Layout ...";
    public static final String EXPLORE_STATE_ACTION_NAME = "Explore current state";
    public static final String EXPORT_ACTION_NAME = "Export ...";
    public static final String EXPORT_CONTROL_ACTION_NAME = "Export Control Automaton ...";
    public static final String EXPORT_RULE_ACTION_NAME = "Export Rule ...";
    public static final String EXPORT_LTS_ACTION_NAME = "Export LTS ...";
    public static final String EXPORT_GRAPH_ACTION_NAME = "Export Graph ...";
    public static final String EXPORT_STATE_ACTION_NAME = "Export State ...";
    public static final String EXPORT_TYPE_ACTION_NAME = "Export Type ...";
    public static final String FILTER_ACTION_NAME = "Filter labels";
    public static final String FILTER_LTS_ACTION_NAME = "Filter LTS";
    public static final String FILTER_TYPE_ACTION_NAME = "Filter type graph";
    public static final String FORWARD_ACTION_NAME = "Step Forward";
    public static final String GOTO_FINAL_STATE_ACTION_NAME = "Go to Final State";
    public static final String GOTO_START_STATE_ACTION_NAME = "Go to Start State";
    public static final String HIDE_LTS_ACTION_NAME = "Hide LTS";
    public static final String LIST_ATOMIC_PROPOSITIONS_ACTION_NAME = "List Atom. Prop.";
    public static final String LOAD_CONTROL_FILE_ACTION_NAME = "Load Control ...";
    public static final String LOAD_START_STATE_ACTION_NAME = "Load External Start State ...";
    public static final String IMPORT_ACTION_NAME = "Import ...";
    public static final String LOAD_GRAMMAR_ACTION_NAME = "Load Grammar ...";
    public static final String LOAD_URL_GRAMMAR_ACTION_NAME = "Load Grammar from URL ...";
    public static final String LOWER_PRIORITY_ACTION_NAME = "Lower Priority";
    public static final String MODEL_CHECK_ACTION_NAME = "Verify";
    public static final String NEW_ACTION_NAME = "New";
    public static final String NEW_GRAMMAR_ACTION_NAME = "New Grammar ...";
    public static final String NODE_MODE_NAME = "Node Mode";
    public static final String OPEN_ACTION_NAME = "Open ...";
    public static final String PASTE_ACTION_NAME = "Paste";
    public static final String PREVIEW_CONTROL_ACTION_NAME = "Preview Control ...";
    public static final String QUIT_ACTION_NAME = "Quit";
    public static final String PROLOG_FIRST_ACTION_NAME = "Start Query";
    public static final String PROLOG_NEXT_ACTION_NAME = "Next Result";
    public static final String RAISE_PRIORITY_ACTION_NAME = "Raise Priority";
    public static final String REDO_ACTION_NAME = "Redo";
    public static final String REFRESH_GRAMMAR_ACTION_NAME = "Refresh Grammar";
    public static final String RELOAD_LTS_ACTION_NAME = "Reload LTS";
    public static final String FIND_REPLACE_ACTION_NAME = "Find/Replace Label...";
    public static final String REPLACE_ACTION_NAME = "Replace Label";
    public static final String REMOVE_POINT_ACTION = "Remove Point";
    public static final String RENUMBER_ACTION_NAME = "Renumber Nodes";
    public static final String RESET_LABEL_POSITION_ACTION = "Reset Label";
    public static final String RESTART_ACTION_NAME = "Restart simulation";
    public static final String RULE_PROPERTIES_ACTION_NAME = "Rule Properties ...";
    public static final String SELECT_COLOR_ACTION_NAME = "Select Color...";
    public static final String START_GRAPH_ACTION_NAME = "Use as Start Graph";
    public static final String START_SIMULATION_ACTION_NAME = "Restart simulation";
    public static final String TOGGLE_TO_ABS_ACTION_NAME = "Enter Abstraction Mode";
    public static final String TOGGLE_TO_CONC_ACTION_NAME = "Return to Concrete Mode";
    private static final String SAVE_NAME_TEMPLATE = "Save %s";
    private static final String SAVE_AS_NAME_TEMPLATE = "Save %s As ...";
    public static final String SAVE_ACTION_NAME = "Save";
    public static final String SAVE_AS_ACTION_NAME = "Save As ...";
    public static final String SAVE_GRAMMAR_ACTION_NAME = "Save Grammar As ...";
    public static final String SAVE_LTS_ACTION_NAME = "Save LTS As ...";
    public static final String SCROLL_TO_ACTION_NAME = "Scroll to current";
    public static final String SET_PRIORITY_ACTION_NAME = "Set Priority";
    public static final String SHOW_ALL_LABELS_ACTION_NAME = "Show all labels";
    public static final String SHOW_EXISTING_LABELS_ACTION_NAME = "Show only existing labels";
    public static final String SHOW_SUBTYPES_ACTION_NAME = "Show subtypes";
    public static final String SHOW_SUPERTYPES_ACTION_NAME = "Show supertypes";
    public static final String COLLAPSE_ALL = "Collapse All";
    public static final String SNAP_TO_GRID_NAME = "Snap to grid";
    public static final String SEARCH_ACTION_NAME = "Search ...";
    public static final String SYSTEM_PROPERTIES_ACTION_NAME = "Grammar Properties ...";
    public static final String UNDO_ACTION_NAME = "Undo";
    public static final String UNFILTER_ACTION_NAME = "Reset label filter";
    public static final String UNFILTER_TYPE_ACTION_NAME = "Reset type graph filter";
    public static final String PAN_MODE_NAME = "Pan and Zoom mode";
    public static final String PREVIEW_MODE_NAME = "Preview mode";
    public static final String SELECT_MODE_NAME = "Selection mode";
    public static final KeyStroke ADD_POINT_KEY;
    public static final KeyStroke APPLY_KEY;
    public static final KeyStroke BACK_KEY;
    public static final KeyStroke CANCEL_KEY;
    public static final KeyStroke CLOSE_KEY;
    public static final KeyStroke COPY_KEY;
    public static final KeyStroke CUT_KEY;
    public static final KeyStroke DEFAULT_EXPLORATION_KEY;
    public static final KeyStroke DELETE_KEY;
    public static final KeyStroke EDIT_MODE_KEY;
    public static final KeyStroke EDIT_KEY;
    public static final KeyStroke EXPORT_KEY;
    public static final KeyStroke FORWARD_KEY;
    public static final KeyStroke GOTO_FINAL_STATE_KEY;
    public static final KeyStroke GOTO_START_STATE_KEY;
    public static final KeyStroke INSERT_KEY;
    public static final KeyStroke LAYOUT_KEY;
    public static final KeyStroke NEW_KEY;
    public static final KeyStroke NODE_MODE_KEY;
    public static final KeyStroke OPEN_KEY;
    public static final KeyStroke OPEN_URL_KEY;
    public static final KeyStroke OPEN_GRAPH_KEY;
    public static final KeyStroke PAN_MODE_KEY;
    public static final KeyStroke PASTE_KEY;
    public static final KeyStroke PREVIEW_MODE_KEY;
    public static final KeyStroke QUIT_KEY;
    public static final KeyStroke REDO_KEY;
    public static final KeyStroke REFRESH_KEY;
    public static final KeyStroke RELABEL_KEY;
    public static final KeyStroke RENAME_KEY;
    public static final KeyStroke REMOVE_POINT_KEY;
    public static final KeyStroke SAVE_KEY;
    public static final KeyStroke SAVE_GRAMMAR_AS_KEY;
    public static final KeyStroke SEARCH_KEY;
    public static final KeyStroke SELECT_MODE_KEY;
    public static final KeyStroke START_SIMULATION_KEY;
    public static final KeyStroke TOGGLE_EXP_MODE_KEY;
    public static final KeyStroke UNDO_KEY;
    public static final KeyStroke ORTHOGONAL_LINE_STYLE_KEY;
    public static final KeyStroke SPLINE_LINE_STYLE_KEY;
    public static final KeyStroke BEZIER_LINE_STYLE_KEY;
    public static final KeyStroke MANHATTAN_LINE_STYLE_KEY;
    public static final int NEW_MNEMONIC = 78;
    public static final int QUIT_MNEMONIC = 81;
    public static final int OPEN_MNEMONIC = 79;
    public static final int SAVE_MNEMONIC = 83;
    public static final String EMPTY_LABEL_TEXT = "(empty)";
    public static final String SUBTYPE_LABEL_TEXT = "(subtype)";
    public static final String NO_LABEL_TEXT = "(none)";
    public static final String IMAGE_ACTION_NAME = "Image";
    private static final Map<ResourceKind, String> showTabOptionMap;
    private static final Set<ResourceKind> optionalTabs;
    public static final String SHOW_ANCHORS_OPTION = "Show anchors";
    public static final String SHOW_ASPECTS_OPTION = "Show aspect prefixes";
    public static final String SHOW_BIDIRECTIONAL_EDGES_OPTION = "Show bidirectional edges";
    public static final String SHOW_NODE_IDS_OPTION = "Show node identities";
    public static final String SHOW_STATE_IDS_OPTION = "Show state identities";
    public static final String SHOW_PARTIAL_GTS_OPTION = "Show partial transitions";
    public static final String SHOW_UNFILTERED_EDGES_OPTION = "Show all unfiltered edges";
    public static final String SHOW_VALUE_NODES_OPTION = "Show data values as nodes";
    public static final String SHOW_ARROWS_ON_LABELS_OPTION = "Show arrows on labels";
    public static final String DELETE_RESOURCE_OPTION = "Delete seletected resource?";
    public static final String VERIFY_ALL_STATES_OPTION = "Check CTL on all states?";
    private static final Map<String, Boolean> boolOptionDefaults;
    private static final Map<String, Integer> intOptionDefaults;
    public static final Preferences userPrefs;
    private static boolean lookAndFeelInit;

    static {
        ADD_POINT_KEY = KeyStroke.getKeyStroke(155, 8);
        APPLY_KEY = KeyStroke.getKeyStroke(10, 2);
        BACK_KEY = KeyStroke.getKeyStroke("alt LEFT");
        CANCEL_KEY = KeyStroke.getKeyStroke("ESCAPE");
        CLOSE_KEY = KeyStroke.getKeyStroke("control W");
        COPY_KEY = KeyStroke.getKeyStroke("control C");
        CUT_KEY = KeyStroke.getKeyStroke("control X");
        DEFAULT_EXPLORATION_KEY = KeyStroke.getKeyStroke("control shift X");
        DELETE_KEY = KeyStroke.getKeyStroke("DELETE");
        EDIT_MODE_KEY = KeyStroke.getKeyStroke("alt E");
        EDIT_KEY = KeyStroke.getKeyStroke("control E");
        EXPORT_KEY = KeyStroke.getKeyStroke("control alt S");
        FORWARD_KEY = KeyStroke.getKeyStroke("alt RIGHT");
        GOTO_FINAL_STATE_KEY = KeyStroke.getKeyStroke("control shift END");
        GOTO_START_STATE_KEY = KeyStroke.getKeyStroke("control shift HOME");
        INSERT_KEY = KeyStroke.getKeyStroke("INSERT");
        LAYOUT_KEY = KeyStroke.getKeyStroke("control L");
        NEW_KEY = KeyStroke.getKeyStroke("control N");
        NODE_MODE_KEY = KeyStroke.getKeyStroke("alt N");
        OPEN_KEY = KeyStroke.getKeyStroke("control O");
        OPEN_URL_KEY = KeyStroke.getKeyStroke("control alt O");
        OPEN_GRAPH_KEY = KeyStroke.getKeyStroke("control shift O");
        PAN_MODE_KEY = KeyStroke.getKeyStroke("alt Z");
        PASTE_KEY = KeyStroke.getKeyStroke("control V");
        PREVIEW_MODE_KEY = KeyStroke.getKeyStroke("alt P");
        QUIT_KEY = KeyStroke.getKeyStroke("control Q");
        REDO_KEY = KeyStroke.getKeyStroke("control Y");
        REFRESH_KEY = KeyStroke.getKeyStroke("F5");
        RELABEL_KEY = KeyStroke.getKeyStroke("control R");
        RENAME_KEY = KeyStroke.getKeyStroke("F2");
        REMOVE_POINT_KEY = KeyStroke.getKeyStroke(127, 8);
        SAVE_KEY = KeyStroke.getKeyStroke("control S");
        SAVE_GRAMMAR_AS_KEY = KeyStroke.getKeyStroke("control shift S");
        SEARCH_KEY = KeyStroke.getKeyStroke("control F");
        SELECT_MODE_KEY = KeyStroke.getKeyStroke("alt S");
        START_SIMULATION_KEY = KeyStroke.getKeyStroke("F11");
        TOGGLE_EXP_MODE_KEY = KeyStroke.getKeyStroke("control B");
        UNDO_KEY = KeyStroke.getKeyStroke("control Z");
        ORTHOGONAL_LINE_STYLE_KEY = KeyStroke.getKeyStroke("alt 1");
        SPLINE_LINE_STYLE_KEY = KeyStroke.getKeyStroke("alt 2");
        BEZIER_LINE_STYLE_KEY = KeyStroke.getKeyStroke("alt 3");
        MANHATTAN_LINE_STYLE_KEY = KeyStroke.getKeyStroke("alt 4");
        showTabOptionMap = new EnumMap<ResourceKind, String>(ResourceKind.class);
        optionalTabs = EnumSet.of(ResourceKind.CONTROL, ResourceKind.PROLOG, ResourceKind.TYPE, ResourceKind.GROOVY);
        boolOptionDefaults = new HashMap<String, Boolean>();
        intOptionDefaults = new HashMap<String, Integer>();
        for (ResourceKind optionalTab : optionalTabs) {
            boolOptionDefaults.put(Options.getShowTabOption(optionalTab), false);
        }
        boolOptionDefaults.put(SHOW_ANCHORS_OPTION, false);
        boolOptionDefaults.put(SHOW_NODE_IDS_OPTION, false);
        boolOptionDefaults.put(SHOW_STATE_IDS_OPTION, true);
        boolOptionDefaults.put(SHOW_PARTIAL_GTS_OPTION, true);
        boolOptionDefaults.put(SHOW_ASPECTS_OPTION, false);
        boolOptionDefaults.put(SHOW_VALUE_NODES_OPTION, false);
        boolOptionDefaults.put(SHOW_UNFILTERED_EDGES_OPTION, false);
        boolOptionDefaults.put(SHOW_ARROWS_ON_LABELS_OPTION, false);
        boolOptionDefaults.put(SHOW_BIDIRECTIONAL_EDGES_OPTION, true);
        intOptionDefaults.put(DELETE_RESOURCE_OPTION, 0);
        intOptionDefaults.put(VERIFY_ALL_STATES_OPTION, 2);
        userPrefs = Preferences.userNodeForPackage(Options.class);
        try {
            HashSet<String> keys = new HashSet<String>(Arrays.asList(userPrefs.keys()));
            for (Map.Entry<String, Boolean> entry : boolOptionDefaults.entrySet()) {
                if (keys.contains(entry.getKey())) continue;
                userPrefs.putBoolean(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Comparable<Boolean>> entry : intOptionDefaults.entrySet()) {
                if (keys.contains(entry.getKey())) continue;
                userPrefs.putInt(entry.getKey(), (Integer)entry.getValue());
            }
        }
        catch (BackingStoreException backingStoreException) {}
        Options.initLookAndFeel();
        DEFAULT_FONT = Options.getDefaultFont();
        LABEL_FONT = Options.getLabelFont();
        SYMBOL_FONT = Options.getSymbolFont();
    }

    public Options() {
        for (ResourceKind resource : Options.getOptionalTabs()) {
            this.addCheckbox(Options.getShowTabOption(resource));
        }
        this.addCheckbox(SHOW_NODE_IDS_OPTION);
        this.addCheckbox(SHOW_ANCHORS_OPTION);
        this.addCheckbox(SHOW_ASPECTS_OPTION);
        this.addCheckbox(SHOW_VALUE_NODES_OPTION);
        this.addCheckbox(SHOW_PARTIAL_GTS_OPTION);
        this.addCheckbox(SHOW_STATE_IDS_OPTION);
        this.addCheckbox(SHOW_UNFILTERED_EDGES_OPTION);
        this.addCheckbox(SHOW_ARROWS_ON_LABELS_OPTION);
        this.addCheckbox(SHOW_BIDIRECTIONAL_EDGES_OPTION);
        this.addBehaviour(DELETE_RESOURCE_OPTION, 2);
        this.addBehaviour(VERIFY_ALL_STATES_OPTION, 3);
    }

    private final JCheckBoxMenuItem addCheckbox(final String name) {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem(name);
        boolean selected = userPrefs.getBoolean(name, boolOptionDefaults.get(name));
        boolean enabled = this.isEnabled(name);
        result.setSelected(selected & enabled);
        this.itemMap.put(name, result);
        if (enabled) {
            result.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    userPrefs.putBoolean(name, e.getStateChange() == 1);
                }
            });
        } else {
            result.setEnabled(false);
        }
        return result;
    }

    private boolean isEnabled(String name) {
        boolean result = true;
        if (SHOW_ARROWS_ON_LABELS_OPTION.equals(name)) {
            result = Options.isSupportsLabelArrows();
        }
        return result;
    }

    private final BehaviourOption addBehaviour(final String name, int optionCount) {
        BehaviourOption result = new BehaviourOption(name, optionCount);
        result.setValue(userPrefs.getInt(name, intOptionDefaults.get(name)));
        result.addPropertyChangeListener("selection", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                userPrefs.putInt(name, (Integer)e.getNewValue());
            }
        });
        this.itemMap.put(name, result);
        return result;
    }

    public JMenuItem getItem(String name) {
        return this.itemMap.get(name);
    }

    public Collection<JMenuItem> getItemSet() {
        return this.itemMap.values();
    }

    public boolean isSelected(String name) {
        return this.itemMap.get(name).isSelected();
    }

    public void setSelected(String name, boolean selected) {
        this.itemMap.get(name).setSelected(selected);
    }

    public int getValue(String name) {
        JMenuItem item = this.itemMap.get(name);
        if (item instanceof BehaviourOption) {
            return ((BehaviourOption)item).getValue();
        }
        return item.isSelected() ? 1 : 0;
    }

    public void setValue(String name, int value) {
        JMenuItem item = this.itemMap.get(name);
        if (item instanceof BehaviourOption) {
            ((BehaviourOption)item).setValue(value);
        } else {
            item.setSelected(value > 0);
        }
    }

    public String toString() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Map.Entry<String, JMenuItem> entry : this.itemMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().isSelected());
        }
        return ((Object)result).toString();
    }

    public static boolean isSupportsLabelArrows() {
        return SYMBOL_FONT != null;
    }

    public static boolean isEdgeEditEvent(MouseEvent evt) {
        return evt.getButton() == 1 && evt.isAltDown();
    }

    public static void setLAF(final AbstractButton button) {
        button.setHideActionText(true);
        button.setFocusable(false);
        button.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 2, 3, 2)));
        button.setBorderPainted(button.isEnabled());
        button.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                button.setBorderPainted(button.isEnabled());
            }
        });
    }

    public static JButton createButton(Action action) {
        JButton result = new JButton(action);
        Options.setLAF(result);
        return result;
    }

    public static JToggleButton createToggleButton(Action action) {
        JToggleButton result = new JToggleButton(action);
        Options.setLAF(result);
        return result;
    }

    public static JToolBar createToolBar() {
        JToolBar result = new JToolBar(){

            @Override
            protected JButton createActionComponent(Action a) {
                JButton result = super.createActionComponent(a);
                Options.setLAF(result);
                return result;
            }
        };
        result.setFloatable(false);
        result.setAlignmentX(0.0f);
        ToolTipManager.sharedInstance().registerComponent(result);
        return result;
    }

    public static String getEditActionName(EditType edit, ResourceKind resource, boolean dots) {
        StringBuilder result = new StringBuilder(edit.getName());
        result.append(' ');
        result.append(resource.getName());
        if (dots) {
            result.append(" ...");
        }
        return result.toString();
    }

    public static String getEnableName(ResourceKind resource, boolean enable) {
        StringBuilder result = new StringBuilder(EditType.getEnableName(enable));
        result.append(' ');
        result.append(resource.getName());
        return result.toString();
    }

    public static String getNewResourceName(ResourceKind resource) {
        String result = resource.getDefaultName();
        if (result == null) {
            result = "new" + resource.getName();
        }
        return result;
    }

    private static final String getSaveActionName(String item, boolean saveAs) {
        return String.format(saveAs ? SAVE_AS_NAME_TEMPLATE : SAVE_NAME_TEMPLATE, item);
    }

    public static final String getSaveActionName(ResourceKind resource, boolean saveAs) {
        return Options.getSaveActionName(resource.getName(), saveAs);
    }

    public static final String getSaveStateActionName(boolean saveAs) {
        return Options.getSaveActionName("State", saveAs);
    }

    public static String getShowTabOption(ResourceKind kind) {
        String result = showTabOptionMap.get((Object)kind);
        if (result == null) {
            result = String.format("Show %ss", kind.getDescription());
            showTabOptionMap.put(kind, result);
        }
        return result;
    }

    public static final Set<ResourceKind> getOptionalTabs() {
        return Collections.unmodifiableSet(optionalTabs);
    }

    public static String[] getUserPrefs(String key) {
        String[] result;
        block6: {
            result = new String[]{};
            String storedValue = userPrefs.get(key, "");
            try {
                result = ExprParser.splitExpr(storedValue, ",");
            }
            catch (FormatException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError((Object)String.format("Format error in user preference string %s: %s", storedValue, e.getMessage()));
            }
        }
        int i = 0;
        while (i < result.length) {
            block7: {
                try {
                    String newValue = ExprParser.toUnquoted(result[i], '\"');
                    assert (result[i] != null) : String.format("User preference string %s is not correctly quoted", result[i]);
                    result[i] = newValue;
                }
                catch (FormatException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)String.format("Format error in user preference string %s: %s", result[i], e.getMessage()));
                }
            }
            ++i;
        }
        return result;
    }

    public static void storeUserPrefs(String key, String[] values) {
        StringBuilder result = new StringBuilder();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (result.length() > 0) {
                result.append(",");
            }
            value = ExprParser.toQuoted(value, '\"');
            result.append(value);
            ++n2;
        }
        userPrefs.put(key, result.toString());
    }

    public static void initLookAndFeel() {
        if (!lookAndFeelInit) {
            lookAndFeelInit = true;
            try {
                MetalLookAndFeel.setCurrentTheme((MetalTheme)new DesertBlue());
                UIManager.setLookAndFeel((LookAndFeel)new PlasticLookAndFeel());
            }
            catch (Exception e) {
                System.out.println("Exception");
                e.printStackTrace();
            }
        }
    }

    private static Font getDefaultFont() {
        return MetalLookAndFeel.getCurrentTheme().getUserTextFont();
    }

    private static Font getLabelFont() {
        Font result = GraphConstants.DEFAULTFONT;
        if (result == null) {
            result = UIManager.getDefaults().getFont("SansSerif");
        }
        return result;
    }

    private static Font getSymbolFont() {
        Font result = Options.getLabelFont();
        if (!result.canDisplay('\u25be')) {
            result = UIManager.getDefaults().getFont("SansSerif");
        }
        if (result == null || !result.canDisplay('\u25be')) {
            result = Options.loadFont("stixgeneralregular.ttf").deriveFont(Options.getLabelFont().getSize2D());
        }
        return result;
    }

    public static Font loadFont(String name) {
        Font result = null;
        try {
            result = Font.createFont(0, Groove.getResource(name).openStream());
            result = result.deriveFont(Options.getLabelFont().getSize2D());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (FontFormatException fontFormatException) {
        }
        catch (IOException iOException) {}
        return result;
    }
}

