/*
 * Decompiled with CFR 0.152.
 */
package groove.gui;

import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.action.LoadGrammarFromHistoryAction;
import groove.io.store.SystemStore;
import groove.io.store.SystemStoreFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JMenu;

class SimulatorHistory
implements SimulatorListener {
    private final Simulator simulator;
    private final JMenu menu = new JMenu();
    private final ArrayList<LoadGrammarFromHistoryAction> history = new ArrayList();
    public static final String HISTORY_KEY = "open_history";

    public SimulatorHistory(Simulator simulator) {
        String[] savedLocations;
        this.simulator = simulator;
        simulator.getModel().addListener(this, new SimulatorModel.Change[0]);
        String[] stringArray = savedLocations = Options.userPrefs.get(HISTORY_KEY, "").split(",");
        int n = savedLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String location = stringArray[n2];
            try {
                this.history.add(this.createLoadAction(location));
            }
            catch (IOException iOException) {}
            ++n2;
        }
        this.menu.setText("Load Recent Grammar");
        this.menu.setMnemonic(82);
        this.synchMenu();
    }

    public JMenu getOpenRecentMenu() {
        return this.menu;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (changes.contains((Object)SimulatorModel.Change.GRAMMAR)) {
            try {
                Object location = source.getStore().getLocation();
                LoadGrammarFromHistoryAction newAction = this.createLoadAction(location.toString());
                this.history.remove(newAction);
                this.history.add(0, newAction);
                while (this.history.size() > 10) {
                    this.history.remove(10);
                }
                this.synch();
            }
            catch (IOException iOException) {}
        }
    }

    private LoadGrammarFromHistoryAction createLoadAction(String location) throws IOException {
        SystemStore store = SystemStoreFactory.newStore(location);
        return new LoadGrammarFromHistoryAction(this.simulator, location, store);
    }

    private void synch() {
        this.synchPrefs();
        this.synchMenu();
    }

    private void synchPrefs() {
        String newStr = this.makeHistoryString();
        Options.userPrefs.put(HISTORY_KEY, newStr);
    }

    private void synchMenu() {
        this.menu.removeAll();
        for (LoadGrammarFromHistoryAction action : this.history) {
            this.menu.add(action);
        }
    }

    private String makeHistoryString() {
        StringBuilder result = new StringBuilder();
        for (LoadGrammarFromHistoryAction action : this.history) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(action.getLocation());
        }
        return result.toString();
    }
}

