/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.action.ApplyMatchAction;
import groove.gui.action.CancelEditAction;
import groove.gui.action.CheckCTLAction;
import groove.gui.action.CopyAction;
import groove.gui.action.DeleteAction;
import groove.gui.action.EditAction;
import groove.gui.action.EditRulePropertiesAction;
import groove.gui.action.EditStateAction;
import groove.gui.action.EditSystemPropertiesAction;
import groove.gui.action.EnableAction;
import groove.gui.action.EnableUniqueAction;
import groove.gui.action.ExecGroovyAction;
import groove.gui.action.ExplorationDialogAction;
import groove.gui.action.ExplorationStatsDialogAction;
import groove.gui.action.ExploreAction;
import groove.gui.action.ExportAction;
import groove.gui.action.FilterLTSAction;
import groove.gui.action.FindReplaceAction;
import groove.gui.action.GotoFinalStateAction;
import groove.gui.action.GotoStartStateAction;
import groove.gui.action.ImportAction;
import groove.gui.action.LayoutDialogAction;
import groove.gui.action.LoadGrammarAction;
import groove.gui.action.LoadGrammarFromURLAction;
import groove.gui.action.LoadStartGraphAction;
import groove.gui.action.NewAction;
import groove.gui.action.NewGrammarAction;
import groove.gui.action.PreviewControlAction;
import groove.gui.action.PrologFirstResultAction;
import groove.gui.action.PrologNextResultAction;
import groove.gui.action.QuitAction;
import groove.gui.action.RedoSimulatorAction;
import groove.gui.action.RefreshGrammarAction;
import groove.gui.action.Refreshable;
import groove.gui.action.ReloadLTSAction;
import groove.gui.action.RenameAction;
import groove.gui.action.RenumberGrammarAction;
import groove.gui.action.SaveAction;
import groove.gui.action.SaveGrammarAction;
import groove.gui.action.SaveLTSAsAction;
import groove.gui.action.SaveStateAction;
import groove.gui.action.SelectColorAction;
import groove.gui.action.SetPriorityAction;
import groove.gui.action.ShiftPriorityAction;
import groove.gui.action.SimulatorAction;
import groove.gui.action.SnapToGridAction;
import groove.gui.action.StartSimulationAction;
import groove.gui.action.ToggleExplorationStateAction;
import groove.gui.action.UndoSimulatorAction;
import groove.gui.display.DisplayKind;
import groove.gui.display.StateDisplay;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;

public class ActionStore
implements SimulatorListener {
    private final Simulator simulator;
    private final List<Refreshable> refreshables = new ArrayList<Refreshable>();
    private ExploreAction animateAction;
    private ApplyMatchAction applyMatchAction;
    private Action backAction;
    private final Map<ResourceKind, CancelEditAction> cancelEditActionMap = new EnumMap<ResourceKind, CancelEditAction>(ResourceKind.class);
    private CheckCTLAction checkCTLFreshAction;
    private CheckCTLAction checkCTLAsIsAction;
    private final Map<ResourceKind, CopyAction> copyActionMap = new EnumMap<ResourceKind, CopyAction>(ResourceKind.class);
    private final Map<ResourceKind, SimulatorAction> deleteActionMap = new EnumMap<ResourceKind, SimulatorAction>(ResourceKind.class);
    private final Map<ResourceKind, EditAction> editActionMap = new EnumMap<ResourceKind, EditAction>(ResourceKind.class);
    private EditStateAction editStateAction;
    private EditRulePropertiesAction editRulePropertiesAction;
    private EditSystemPropertiesAction editSystemPropertiesAction;
    private final Map<ResourceKind, EnableAction> enableActionMap = new EnumMap<ResourceKind, EnableAction>(ResourceKind.class);
    private ExploreAction exploreAction;
    private FilterLTSAction filterLTSAction;
    private ExplorationDialogAction explorationDialogAction;
    private ExplorationStatsDialogAction explorationStatsDialogAction;
    private final Map<DisplayKind, ExportAction> exportActionMap = new EnumMap<DisplayKind, ExportAction>(DisplayKind.class);
    private ExportAction exportStateAction;
    private Action forwardAction;
    private GotoFinalStateAction gotoFinalStateAction;
    private GotoStartStateAction gotoStartStateAction;
    private ImportAction importAction;
    private LoadGrammarAction loadGrammarAction;
    private LoadGrammarFromURLAction loadGrammarFromURLAction;
    private LoadStartGraphAction loadStartGraphAction;
    private final Map<ResourceKind, SimulatorAction> newActionMap = new EnumMap<ResourceKind, SimulatorAction>(ResourceKind.class);
    private NewGrammarAction newGrammarAction;
    private PreviewControlAction previewControlAction;
    private QuitAction quitAction;
    private PrologFirstResultAction prologFirstResultAction;
    private PrologNextResultAction prologNexttResultAction;
    private RedoSimulatorAction redoAction;
    private ReloadLTSAction reloadLTSAction;
    private RefreshGrammarAction refreshGrammarAction;
    private FindReplaceAction findReplaceAction;
    private final Map<ResourceKind, RenameAction> renameActionMap = new EnumMap<ResourceKind, RenameAction>(ResourceKind.class);
    private RenumberGrammarAction renumberAction;
    private SaveGrammarAction saveGrammarAction;
    private Map<ResourceKind, SaveAction> saveActionMap = new EnumMap<ResourceKind, SaveAction>(ResourceKind.class);
    private Map<ResourceKind, SaveAction> saveAsActionMap = new EnumMap<ResourceKind, SaveAction>(ResourceKind.class);
    private SaveStateAction saveStateAction;
    private SaveStateAction saveStateAsAction;
    private SaveLTSAsAction saveLtsAsAction;
    private SelectColorAction selectColorAction;
    private SetPriorityAction setPriorityAction;
    private ShiftPriorityAction raisePriorityAction;
    private ShiftPriorityAction lowerPriorityAction;
    private final Map<ResourceKind, EnableUniqueAction> enableUniqueActionMap = new EnumMap<ResourceKind, EnableUniqueAction>(ResourceKind.class);
    private SnapToGridAction snapToGridAction;
    private StartSimulationAction startSimulationAction;
    private ToggleExplorationStateAction toggleExplorationStateAction;
    private UndoSimulatorAction undoAction;
    private LayoutDialogAction layoutDialogAction;
    private ExecGroovyAction execGroovyAction;

    public ActionStore(Simulator simulator) {
        this.simulator = simulator;
        simulator.getModel().addListener(this, new SimulatorModel.Change[0]);
    }

    public final Simulator getSimulator() {
        return this.simulator;
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        this.refreshActions();
    }

    public void addRefreshable(Refreshable element) {
        this.refreshables.add(element);
    }

    public void removeRefreshable(Refreshable element) {
        this.refreshables.remove(element);
    }

    public void refreshActions() {
        for (Refreshable action : new ArrayList<Refreshable>(this.refreshables)) {
            action.refresh();
        }
    }

    public ExploreAction getAnimateAction() {
        if (this.animateAction == null) {
            this.animateAction = new ExploreAction(this.simulator, true);
        }
        return this.animateAction;
    }

    public ApplyMatchAction getApplyMatchAction() {
        if (this.applyMatchAction == null) {
            this.applyMatchAction = new ApplyMatchAction(this.simulator);
        }
        return this.applyMatchAction;
    }

    public Action getBackAction() {
        if (this.backAction == null) {
            this.backAction = this.simulator.getSimulationHistory().getBackAction();
        }
        return this.backAction;
    }

    public CancelEditAction getCancelEditAction(ResourceKind resource) {
        CancelEditAction result = this.cancelEditActionMap.get((Object)resource);
        if (result == null) {
            result = new CancelEditAction(this.simulator, resource);
            this.cancelEditActionMap.put(resource, result);
            result.refresh();
        }
        return result;
    }

    public Action getCheckCTLAction(boolean full) {
        CheckCTLAction result;
        CheckCTLAction checkCTLAction = result = full ? this.checkCTLFreshAction : this.checkCTLAsIsAction;
        if (result == null) {
            result = new CheckCTLAction(this.simulator, full);
            if (full) {
                this.checkCTLFreshAction = result;
            } else {
                this.checkCTLAsIsAction = result;
            }
        }
        return result;
    }

    public CopyAction getCopyAction(ResourceKind resource) {
        CopyAction result = this.copyActionMap.get((Object)resource);
        if (result == null) {
            result = new CopyAction(this.simulator, resource);
            this.copyActionMap.put(resource, result);
        }
        return result;
    }

    public SimulatorAction getDeleteAction(ResourceKind resource) {
        SimulatorAction result = this.deleteActionMap.get((Object)resource);
        if (result == null) {
            result = new DeleteAction(this.simulator, resource);
            this.deleteActionMap.put(resource, result);
        }
        return result;
    }

    public EditAction getEditAction(ResourceKind resource) {
        EditAction result = this.editActionMap.get((Object)resource);
        if (result == null) {
            result = new EditAction(this.simulator, resource);
            this.editActionMap.put(resource, result);
        }
        return result;
    }

    public EditStateAction getEditStateAction() {
        if (this.editStateAction == null) {
            this.editStateAction = new EditStateAction(this.simulator);
        }
        return this.editStateAction;
    }

    public EditRulePropertiesAction getEditRulePropertiesAction() {
        if (this.editRulePropertiesAction == null) {
            this.editRulePropertiesAction = new EditRulePropertiesAction(this.simulator);
        }
        return this.editRulePropertiesAction;
    }

    public SimulatorAction getEditSystemPropertiesAction() {
        if (this.editSystemPropertiesAction == null) {
            this.editSystemPropertiesAction = new EditSystemPropertiesAction(this.simulator);
        }
        return this.editSystemPropertiesAction;
    }

    public EnableAction getEnableAction(ResourceKind resource) {
        EnableAction result = this.enableActionMap.get((Object)resource);
        if (result == null) {
            result = new EnableAction(this.simulator, resource);
            this.enableActionMap.put(resource, result);
        }
        return result;
    }

    public ExploreAction getExploreAction() {
        if (this.exploreAction == null) {
            this.exploreAction = new ExploreAction(this.simulator, false);
        }
        return this.exploreAction;
    }

    public FilterLTSAction getFilterLTSAction() {
        if (this.filterLTSAction == null) {
            this.filterLTSAction = new FilterLTSAction(this.simulator);
        }
        return this.filterLTSAction;
    }

    public ExplorationDialogAction getExplorationDialogAction() {
        if (this.explorationDialogAction == null) {
            this.explorationDialogAction = new ExplorationDialogAction(this.simulator);
        }
        return this.explorationDialogAction;
    }

    public ExplorationStatsDialogAction getExplorationStatsDialogAction() {
        if (this.explorationStatsDialogAction == null) {
            this.explorationStatsDialogAction = new ExplorationStatsDialogAction(this.simulator);
        }
        return this.explorationStatsDialogAction;
    }

    public ExportAction getExportAction(DisplayKind kind) {
        if (!this.exportActionMap.containsKey((Object)kind)) {
            ExportAction result = new ExportAction(this.getSimulator(), kind);
            this.exportActionMap.put(kind, result);
        }
        return this.exportActionMap.get((Object)kind);
    }

    public ExportAction getExportStateAction() {
        if (this.exportStateAction == null) {
            StateDisplay display = (StateDisplay)this.simulator.getDisplaysPanel().getDisplay(DisplayKind.STATE);
            this.exportStateAction = display.getJGraph().getExportAction();
        }
        return this.exportStateAction;
    }

    public Action getForwardAction() {
        if (this.forwardAction == null) {
            this.forwardAction = this.simulator.getSimulationHistory().getForwardAction();
        }
        return this.forwardAction;
    }

    public GotoFinalStateAction getGotoFinalStateAction() {
        if (this.gotoFinalStateAction == null) {
            this.gotoFinalStateAction = new GotoFinalStateAction(this.simulator, false);
        }
        return this.gotoFinalStateAction;
    }

    public GotoStartStateAction getGotoStartStateAction() {
        if (this.gotoStartStateAction == null) {
            this.gotoStartStateAction = new GotoStartStateAction(this.simulator);
        }
        return this.gotoStartStateAction;
    }

    public ImportAction getImportAction() {
        if (this.importAction == null) {
            this.importAction = new ImportAction(this.simulator);
        }
        return this.importAction;
    }

    public LoadGrammarAction getLoadGrammarAction() {
        if (this.loadGrammarAction == null) {
            this.loadGrammarAction = new LoadGrammarAction(this.simulator);
        }
        return this.loadGrammarAction;
    }

    public Action getLoadGrammarFromURLAction() {
        if (this.loadGrammarFromURLAction == null) {
            this.loadGrammarFromURLAction = new LoadGrammarFromURLAction(this.simulator);
        }
        return this.loadGrammarFromURLAction;
    }

    public LoadStartGraphAction getLoadStartGraphAction() {
        if (this.loadStartGraphAction == null) {
            this.loadStartGraphAction = new LoadStartGraphAction(this.simulator);
        }
        return this.loadStartGraphAction;
    }

    public SimulatorAction getNewAction(ResourceKind resource) {
        SimulatorAction result = this.newActionMap.get((Object)resource);
        if (result == null) {
            result = new NewAction(this.simulator, resource);
            this.newActionMap.put(resource, result);
        }
        return result;
    }

    public NewGrammarAction getNewGrammarAction() {
        if (this.newGrammarAction == null) {
            this.newGrammarAction = new NewGrammarAction(this.simulator);
        }
        return this.newGrammarAction;
    }

    public PreviewControlAction getPreviewControlAction() {
        if (this.previewControlAction == null) {
            this.previewControlAction = new PreviewControlAction(this.simulator);
        }
        return this.previewControlAction;
    }

    public SimulatorAction getQuitAction() {
        if (this.quitAction == null) {
            this.quitAction = new QuitAction(this.simulator);
        }
        return this.quitAction;
    }

    public PrologFirstResultAction getPrologFirstResultAction() {
        if (this.prologFirstResultAction == null) {
            this.prologFirstResultAction = new PrologFirstResultAction(this.simulator);
        }
        return this.prologFirstResultAction;
    }

    public PrologNextResultAction getPrologNextResultAction() {
        if (this.prologNexttResultAction == null) {
            this.prologNexttResultAction = new PrologNextResultAction(this.simulator);
        }
        return this.prologNexttResultAction;
    }

    public RedoSimulatorAction getRedoAction() {
        if (this.redoAction == null) {
            this.redoAction = new RedoSimulatorAction(this.simulator);
        }
        return this.redoAction;
    }

    public ReloadLTSAction getReloadLTSAction() {
        if (this.reloadLTSAction == null) {
            this.reloadLTSAction = new ReloadLTSAction(this.simulator);
        }
        return this.reloadLTSAction;
    }

    public RefreshGrammarAction getRefreshGrammarAction() {
        if (this.refreshGrammarAction == null) {
            this.refreshGrammarAction = new RefreshGrammarAction(this.simulator);
        }
        return this.refreshGrammarAction;
    }

    public FindReplaceAction getFindReplaceAction() {
        if (this.findReplaceAction == null) {
            this.findReplaceAction = new FindReplaceAction(this.simulator);
        }
        return this.findReplaceAction;
    }

    public RenameAction getRenameAction(ResourceKind resource) {
        RenameAction result = this.renameActionMap.get((Object)resource);
        if (result == null) {
            result = new RenameAction(this.simulator, resource);
            this.renameActionMap.put(resource, result);
        }
        return result;
    }

    public RenumberGrammarAction getRenumberAction() {
        if (this.renumberAction == null) {
            this.renumberAction = new RenumberGrammarAction(this.simulator);
        }
        return this.renumberAction;
    }

    public SaveGrammarAction getSaveGrammarAction() {
        if (this.saveGrammarAction == null) {
            this.saveGrammarAction = new SaveGrammarAction(this.simulator);
        }
        return this.saveGrammarAction;
    }

    public SaveAction getSaveAction(ResourceKind resource) {
        SaveAction result = this.saveActionMap.get((Object)resource);
        if (result == null) {
            result = new SaveAction(this.simulator, resource, false);
            this.saveActionMap.put(resource, result);
        }
        return result;
    }

    public SaveAction getSaveAsAction(ResourceKind resource) {
        SaveAction result = this.saveAsActionMap.get((Object)resource);
        if (result == null) {
            result = new SaveAction(this.simulator, resource, true);
            this.saveAsActionMap.put(resource, result);
            result.refresh();
        }
        return result;
    }

    public SaveStateAction getSaveStateAction() {
        if (this.saveStateAction == null) {
            this.saveStateAction = new SaveStateAction(this.simulator, false);
        }
        return this.saveStateAction;
    }

    public SaveStateAction getSaveStateAsAction() {
        if (this.saveStateAsAction == null) {
            this.saveStateAsAction = new SaveStateAction(this.simulator, true);
        }
        return this.saveStateAsAction;
    }

    public SaveLTSAsAction getSaveLTSAsAction() {
        if (this.saveLtsAsAction == null) {
            this.saveLtsAsAction = new SaveLTSAsAction(this.simulator);
        }
        return this.saveLtsAsAction;
    }

    public Action getSelectColorAction() {
        if (this.selectColorAction == null) {
            this.selectColorAction = new SelectColorAction(this.simulator);
        }
        return this.selectColorAction;
    }

    public SetPriorityAction getSetPriorityAction() {
        if (this.setPriorityAction == null) {
            this.setPriorityAction = new SetPriorityAction(this.simulator);
            this.setPriorityAction.refresh();
        }
        return this.setPriorityAction;
    }

    public ShiftPriorityAction getShiftPriorityAction(boolean up) {
        ShiftPriorityAction result;
        ShiftPriorityAction shiftPriorityAction = result = up ? this.raisePriorityAction : this.lowerPriorityAction;
        if (result == null) {
            result = new ShiftPriorityAction(this.simulator, up);
            if (up) {
                this.raisePriorityAction = result;
            } else {
                this.lowerPriorityAction = result;
            }
        }
        return result;
    }

    public EnableUniqueAction getEnableUniqueAction(ResourceKind resource) {
        EnableUniqueAction result = this.enableUniqueActionMap.get((Object)resource);
        if (result == null) {
            result = new EnableUniqueAction(this.simulator, resource);
            this.enableUniqueActionMap.put(resource, result);
        }
        return result;
    }

    public SnapToGridAction getSnapToGridAction() {
        if (this.snapToGridAction == null) {
            this.snapToGridAction = new SnapToGridAction(this.simulator);
        }
        return this.snapToGridAction;
    }

    public StartSimulationAction getStartSimulationAction() {
        if (this.startSimulationAction == null) {
            this.startSimulationAction = new StartSimulationAction(this.simulator);
        }
        return this.startSimulationAction;
    }

    public Action getToggleExplorationStateAction() {
        if (this.toggleExplorationStateAction == null) {
            this.toggleExplorationStateAction = new ToggleExplorationStateAction(this.simulator);
        }
        return this.toggleExplorationStateAction;
    }

    public UndoSimulatorAction getUndoAction() {
        if (this.undoAction == null) {
            this.undoAction = new UndoSimulatorAction(this.simulator);
        }
        return this.undoAction;
    }

    public LayoutDialogAction getLayoutDialogAction() {
        if (this.layoutDialogAction == null) {
            this.layoutDialogAction = new LayoutDialogAction(this.simulator);
        }
        return this.layoutDialogAction;
    }

    public ExecGroovyAction getExecGroovyAction() {
        if (this.execGroovyAction == null) {
            this.execGroovyAction = new ExecGroovyAction(this.simulator);
        }
        return this.execGroovyAction;
    }

    public void initialiseRemainingActions() {
        this.getFilterLTSAction();
    }
}

