/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.explore.AcceptorValue;
import groove.explore.Exploration;
import groove.explore.StrategyValue;
import groove.explore.encode.Serialized;
import groove.explore.strategy.Boundary;
import groove.grammar.model.FormatException;
import groove.gui.Simulator;
import groove.gui.action.ExploreAction;
import groove.gui.dialog.BoundedModelCheckingDialog;
import groove.gui.dialog.StringDialog;
import groove.lts.GraphState;
import groove.verify.FormulaParser;
import groove.verify.ParseException;
import java.util.Collection;
import javax.swing.JOptionPane;

public class CheckLTLAction
extends ExploreAction {
    private StringDialog ltlFormulaDialog;
    private final StrategyValue strategyType;

    public CheckLTLAction(Simulator simulator, StrategyValue strategyType, String name) {
        super(simulator, false);
        assert (StrategyValue.LTL_STRATEGIES.contains(strategyType));
        this.putValue("Name", name);
        this.putValue("ShortDescription", strategyType.getDescription());
        this.putValue("AcceleratorKey", null);
        this.putValue("SmallIcon", null);
        this.strategyType = strategyType;
    }

    @Override
    public void execute() {
        Serialized strategy;
        String property = this.getLtlFormulaDialog().showDialog(this.getFrame());
        if (property == null) {
            return;
        }
        if (this.strategyType == StrategyValue.LTL) {
            strategy = this.strategyType.getTemplate().toSerialized(property);
        } else {
            BoundedModelCheckingDialog dialog = new BoundedModelCheckingDialog();
            dialog.setGrammar(this.getSimulatorModel().getGts().getGrammar());
            dialog.showDialog(this.getFrame());
            Boundary boundary = dialog.getBoundary();
            if (boundary == null) {
                return;
            }
            strategy = this.strategyType.getTemplate().toSerialized(property, boundary);
        }
        Exploration exploration = new Exploration(strategy, AcceptorValue.CYCLE.toSerialized(), 1);
        this.getActions().getExploreAction().explore(exploration, true, true);
        Collection<GraphState> result = exploration.getLastResult().getValue();
        if (result.isEmpty()) {
            JOptionPane.showMessageDialog(this.getFrame(), String.format("The property %s holds for this system", property));
        } else {
            JOptionPane.showMessageDialog(this.getFrame(), String.format("A counter-example to %s is highlighted", property));
        }
    }

    private StringDialog getLtlFormulaDialog() {
        if (this.ltlFormulaDialog == null) {
            this.ltlFormulaDialog = new StringDialog("Enter the LTL Formula", FormulaParser.getDocMap(false)){

                @Override
                public String parse(String text) throws FormatException {
                    try {
                        FormulaParser.parse(text).toLtlFormula();
                    }
                    catch (ParseException e) {
                        throw new FormatException(e.getMessage(), new Object[0]);
                    }
                    return text;
                }
            };
        }
        return this.ltlFormulaDialog;
    }
}

