/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import java.io.IOException;
import java.util.Set;

public class DeleteAction
extends SimulatorAction {
    public DeleteAction(Simulator simulator, ResourceKind resource) {
        super(simulator, EditType.DELETE, resource);
    }

    @Override
    public void execute() {
        String question;
        ResourceKind resource = this.getResourceKind();
        Set<String> names = this.getSimulatorModel().getSelectSet(resource);
        boolean enabled = false;
        for (String name : names) {
            if (enabled |= this.getGrammarModel().getResource(resource, name).isEnabled()) break;
        }
        if (names.size() == 1) {
            String description = resource == ResourceKind.HOST && enabled ? "start graph" : resource.getDescription();
            String name = names.iterator().next();
            question = String.format("Delete %s '%s'?", description, name);
        } else {
            String addendum = enabled && resource == ResourceKind.HOST ? " (including start graph)" : "";
            question = String.format("Delete these %d %ss%s?", names.size(), resource.getDescription(), addendum);
        }
        if (this.confirmBehaviour("Delete seletected resource?", question)) {
            try {
                this.getSimulatorModel().doDelete(resource, names);
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, String.format("Error while deleting %s%s", resource.getDescription(), names.size() == 1 ? "" : "s"), new Object[0]);
            }
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().getSelected(this.getResourceKind()) != null && this.getSimulatorModel().getStore().isModifiable());
    }
}

