/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class EditStateAction
extends SimulatorAction {
    public EditStateAction(Simulator simulator) {
        super(simulator, "Edit State ...", Icons.EDIT_STATE_ICON, null, ResourceKind.HOST);
        this.putValue("AcceleratorKey", Options.EDIT_KEY);
    }

    @Override
    public void execute() {
        AspectGraph graph = this.getStateDisplay().getStateGraph();
        final String newGraphName = this.askNewName(graph.getName(), true);
        if (newGraphName != null) {
            AspectGraph newGraph = graph.rename(newGraphName);
            try {
                this.getSimulatorModel().doAddGraph(this.getResourceKind(), newGraph, false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditStateAction.this.getHostDisplay().startEditResource(newGraphName);
                    }
                });
            }
            catch (IOException e) {
                this.showErrorDialog(e, "Can't edit state '%s'", graph.getName());
            }
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().hasState());
    }
}

