/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeLabel;
import groove.graph.Label;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.display.GraphTab;
import groove.gui.display.ResourceDisplay;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraph;
import groove.gui.list.SearchResult;
import groove.gui.tree.LabelTree;
import groove.util.Duo;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;

public class FindReplaceAction
extends SimulatorAction
implements GraphSelectionListener,
TreeSelectionListener {
    private TypeLabel oldLabel;

    public FindReplaceAction(Simulator simulator) {
        super(simulator, "Find/Replace Label...", Icons.SEARCH_ICON);
        this.putValue("AcceleratorKey", Options.SEARCH_KEY);
        this.addAsListener(this.getHostDisplay());
        this.addAsListener(this.getRuleDisplay());
        this.addAsListener(this.getTypeDisplay());
    }

    private void addAsListener(ResourceDisplay display) {
        AspectJGraph jGraph = ((GraphTab)display.getMainTab()).getJGraph();
        jGraph.addGraphSelectionListener(this);
        jGraph.getLabelTree().addTreeSelectionListener(this);
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getGrammarStore() != null && this.getGrammarStore().isModifiable() && !this.getGrammarModel().getTypeGraph().getLabels().isEmpty());
    }

    @Override
    public void execute() {
        Duo<TypeLabel> result;
        if (this.getDisplaysPanel().saveAllEditors(false) && (result = this.askFindSearch(this.oldLabel)) != null) {
            if (result.two() == null) {
                List<SearchResult> searchResults = this.getSimulatorModel().searchLabel((TypeLabel)result.one());
                this.getSimulator().setSearchResults(searchResults);
            } else {
                try {
                    this.getSimulatorModel().doRelabel((TypeLabel)result.one(), (TypeLabel)result.two());
                }
                catch (IOException exc) {
                    this.showErrorDialog(exc, String.format("Error while renaming '%s' into '%s':", result.one(), result.two()), new Object[0]);
                }
            }
        }
    }

    public void valueChanged(GraphSelectionEvent e) {
        Label selectedEntry;
        Collection<Label> selectedEntries;
        this.oldLabel = null;
        Object[] selection = ((JGraph)((Object)e.getSource())).getSelectionCells();
        if (selection != null && selection.length > 0 && (selectedEntries = ((JCell)selection[0]).getKeys()).size() > 0 && (selectedEntry = selectedEntries.iterator().next()) instanceof TypeElement) {
            this.oldLabel = ((TypeElement)selectedEntry).label();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Label selectedLabel;
        Object treeNode;
        this.oldLabel = null;
        TreePath[] selection = ((LabelTree)e.getSource()).getSelectionPaths();
        if (selection != null && selection.length > 0 && (treeNode = selection[0].getLastPathComponent()) instanceof LabelTree.EntryNode && (selectedLabel = ((LabelTree.EntryNode)treeNode).getEntry().getLabel()) instanceof TypeLabel) {
            this.oldLabel = (TypeLabel)selectedLabel;
        }
    }
}

