/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.GrammarProperties;
import groove.grammar.QualName;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.graph.GraphInfo;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.dialog.VersionDialog;
import groove.io.store.SystemStore;
import groove.io.store.SystemStoreFactory;
import groove.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class LoadGrammarAction
extends SimulatorAction {
    public LoadGrammarAction(Simulator simulator) {
        super(simulator, "Load Grammar ...", null);
        this.putValue("AcceleratorKey", Options.OPEN_KEY);
        simulator.addAccelerator(this);
    }

    @Override
    public void execute() {
        JFileChooser fileChooser = this.getGrammarFileChooser(true);
        int approve = fileChooser.showOpenDialog(this.getFrame());
        if (approve == 0) {
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile == null) {
                this.showErrorDialog(null, "No file selected", new Object[0]);
            } else {
                try {
                    this.load(selectedFile);
                }
                catch (IOException exc) {
                    String msg = exc.getMessage();
                    if (msg.endsWith("is not a JAR or ZIP file")) {
                        this.execute();
                        return;
                    }
                    this.showErrorDialog(exc, exc.getMessage(), new Object[0]);
                }
            }
        }
    }

    public boolean load(File grammarFile) throws IOException {
        boolean result = false;
        SystemStore store = SystemStoreFactory.newStore(grammarFile, false);
        result = this.load(store);
        this.getGrammarFileChooser().setSelectedFile(grammarFile);
        this.getRuleFileChooser().setCurrentDirectory(grammarFile);
        this.getStateFileChooser().setSelectedFile(null);
        this.getStateFileChooser().setCurrentDirectory(grammarFile);
        return result;
    }

    public boolean load(SystemStore store) throws IOException {
        boolean success;
        File newGrammarFile;
        boolean saveAfterLoading;
        String fileGrammarVersion;
        block15: {
            int compare;
            GrammarProperties props;
            block16: {
                block14: {
                    if (!this.getDisplaysPanel().saveAllEditors(true)) {
                        return false;
                    }
                    store.reload();
                    props = store.getProperties();
                    if (store.isEmpty()) {
                        this.showErrorDialog(null, store.getLocation() + " is not a GROOVE production system.", new Object[0]);
                        return false;
                    }
                    fileGrammarVersion = props.getGrammarVersion();
                    compare = Version.compareGrammarVersion(fileGrammarVersion);
                    boolean bl = saveAfterLoading = compare != 0;
                    if (compare >= 0) break block14;
                    if (!VersionDialog.showNew(this.getFrame(), props)) {
                        return false;
                    }
                    newGrammarFile = null;
                    break block15;
                }
                if (compare <= 0 || !(store.getLocation() instanceof File)) break block16;
                File grammarFile = (File)store.getLocation();
                switch (VersionDialog.showOldFile(this.getFrame(), props)) {
                    case 0: {
                        newGrammarFile = grammarFile;
                        break block15;
                    }
                    case 1: {
                        newGrammarFile = this.selectSaveAs(grammarFile);
                        if (newGrammarFile == null) {
                            return false;
                        }
                        break block15;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (compare > 0) {
                if (!VersionDialog.showOldURL(this.getFrame(), props)) {
                    return false;
                }
                newGrammarFile = this.selectSaveAs(null);
                if (newGrammarFile == null) {
                    return false;
                }
            } else {
                newGrammarFile = null;
            }
        }
        if (Version.compareGrammarVersions(fileGrammarVersion, "3.1") == -1 && !(success = this.makeIdentifiersValid(store))) {
            return false;
        }
        GrammarModel grammar = store.toGrammarModel();
        this.getSimulatorModel().setGrammar(grammar);
        grammar.getProperties().setCurrentVersionProperties();
        if (saveAfterLoading && newGrammarFile != null) {
            this.getActions().getSaveGrammarAction().save(newGrammarFile, !newGrammarFile.equals(store.getLocation()));
        }
        return true;
    }

    private File selectSaveAs(File oldGrammarFile) {
        int result;
        if (oldGrammarFile != null) {
            this.getGrammarFileChooser().getSelectedFile();
            this.getGrammarFileChooser().setSelectedFile(oldGrammarFile);
        }
        if ((result = this.getGrammarFileChooser().showSaveDialog(this.getFrame())) != 0) {
            return null;
        }
        File selected = this.getGrammarFileChooser().getSelectedFile();
        if (selected.exists()) {
            if (this.confirmOverwriteGrammar(selected)) {
                return selected;
            }
            return this.selectSaveAs(oldGrammarFile);
        }
        return selected;
    }

    private boolean makeIdentifiersValid(SystemStore store) throws IOException {
        boolean result = true;
        boolean confirmed = false;
        store.setUndoSuspended(true);
        block0: for (ResourceKind kind : ResourceKind.all(false)) {
            HashSet<String> newNames = new HashSet<String>();
            Set<String> oldNames = kind.isGraphBased() ? store.getGraphs(kind).keySet() : store.getTexts(kind).keySet();
            HashMap<String, String> renameMap = new HashMap<String, String>();
            for (String name : oldNames) {
                StringBuilder legal;
                if (QualName.isValid(name, legal = new StringBuilder(), null)) continue;
                if (!confirmed && !this.askReplaceNames()) {
                    result = false;
                    break block0;
                }
                confirmed = true;
                String newName = legal.toString();
                while (oldNames.contains(newName) || newNames.contains(newName)) {
                    newName = String.valueOf(newName) + "_";
                }
                newNames.add(newName);
                renameMap.put(name, newName);
            }
            if (renameMap.isEmpty()) continue;
            if (kind.isGraphBased()) {
                this.replaceGraphs(store, kind, renameMap);
                continue;
            }
            this.replaceTexts(store, kind, renameMap);
        }
        store.setUndoSuspended(false);
        return result;
    }

    private void replaceGraphs(SystemStore store, ResourceKind kind, Map<String, String> renameMap) throws IOException {
        Map<String, AspectGraph> oldGraphMap = store.getGraphs(kind);
        ArrayList<AspectGraph> newGraphs = new ArrayList<AspectGraph>();
        for (Map.Entry<String, String> e : renameMap.entrySet()) {
            String oldName = e.getKey();
            String newName = e.getValue();
            AspectGraph oldGraph = oldGraphMap.get(oldName);
            AspectGraph newGraph = oldGraph.clone();
            newGraph.setName(newName);
            if (kind == ResourceKind.RULE && GraphInfo.getTransitionLabel(newGraph) == null) {
                GraphInfo.setTransitionLabel(newGraph, oldName);
            }
            newGraph.setFixed();
            newGraphs.add(newGraph);
        }
        store.deleteGraphs(kind, renameMap.keySet());
        store.putGraphs(kind, newGraphs, false);
    }

    private void replaceTexts(SystemStore store, ResourceKind kind, Map<String, String> renameMap) throws IOException {
        Map<String, String> oldTextMap = store.getTexts(kind);
        HashMap<String, String> newTextMap = new HashMap<String, String>();
        for (Map.Entry<String, String> e : renameMap.entrySet()) {
            String oldName = e.getKey();
            String newName = e.getValue();
            String text = oldTextMap.get(oldName);
            newTextMap.put(newName, text);
        }
        store.deleteTexts(kind, renameMap.keySet());
        store.putTexts(kind, newTextMap);
    }

    private boolean askReplaceNames() {
        Object[] options = new String[]{"Continue", "Abort"};
        return JOptionPane.showOptionDialog(this.getFrame(), "Warning: the grammar contains resources with invalid (since grammar version 3.1) names.\nThese will be renamed automatically.", "Warning: invalid identifiers", 0, 2, null, options, "Continue") == 0;
    }
}

