/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.graph.GraphRole;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.ExtensionFilter;
import groove.io.graph.AttrGraph;
import groove.io.graph.GxlIO;
import java.io.File;
import java.io.IOException;

public class LoadStartGraphAction
extends SimulatorAction {
    public LoadStartGraphAction(Simulator simulator) {
        super(simulator, "Load External Start State ...", null);
    }

    @Override
    public void execute() {
        int approve = this.getStateFileChooser().showOpenDialog(this.getFrame());
        if (approve == 0) {
            File file = this.getStateFileChooser().getSelectedFile();
            try {
                AttrGraph xmlGraph = GxlIO.getInstance().loadGraph(file);
                xmlGraph.setRole(GraphRole.HOST);
                xmlGraph.setName(ExtensionFilter.getPureName(file));
                this.getSimulatorModel().doSetStartGraph(xmlGraph.toAspectGraph());
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Could not load start graph from " + file.getName(), new Object[0]);
            }
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getGrammarModel() != null);
    }
}

