/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorUndoManager;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import groove.io.store.SystemStore;

public class RedoSimulatorAction
extends SimulatorAction {
    private final SimulatorUndoManager undoManager;

    public RedoSimulatorAction(Simulator simulator) {
        super(simulator, "Redo", Icons.REDO_ICON);
        this.putValue("ShortDescription", "Redo");
        this.putValue("AcceleratorKey", Options.REDO_KEY);
        this.setEnabled(false);
        this.undoManager = simulator.getUndoManager();
    }

    @Override
    public void execute() {
        SystemStore.Edit edit = this.undoManager.editToBeRedone();
        this.undoManager.redo();
        this.getSimulatorModel().synchronize(edit.getType() != EditType.LAYOUT);
    }

    @Override
    public void refresh() {
        if (this.undoManager.canRedo()) {
            this.setEnabled(true);
            this.putValue("Name", this.undoManager.getRedoPresentationName());
        } else {
            this.setEnabled(false);
            this.putValue("Name", "Redo");
        }
    }
}

