/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.TextBasedModel;
import groove.graph.Graph;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SaveStateAction;
import groove.gui.action.SimulatorAction;
import groove.gui.display.GraphEditorTab;
import groove.gui.display.ResourceTab;
import groove.gui.display.TextTab;
import groove.io.ExtensionFilter;
import groove.io.graph.GxlIO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class SaveAction
extends SimulatorAction {
    private final boolean saveAs;
    private final SaveStateAction saveStateAction;

    public SaveAction(Simulator simulator, ResourceKind resource, boolean saveAs) {
        super(simulator, saveAs ? "Save As ..." : "Save", saveAs ? Icons.SAVE_AS_ICON : Icons.SAVE_ICON, null, resource);
        if (!saveAs) {
            this.putValue("AcceleratorKey", Options.SAVE_KEY);
        }
        this.saveAs = saveAs;
        this.saveStateAction = saveAs ? this.getActions().getSaveStateAsAction() : this.getActions().getSaveStateAction();
    }

    @Override
    public void execute() {
        if (this.isForState()) {
            this.saveStateAction.execute();
        } else {
            boolean saved = false;
            ResourceKind resourceKind = this.getResourceKind();
            String name = this.getSimulatorModel().getSelected(resourceKind);
            ResourceTab editor = this.getDisplay().getEditor(name);
            if (resourceKind.isGraphBased()) {
                boolean minor;
                AspectGraph graph;
                if (editor == null) {
                    graph = this.getGrammarStore().getGraphs(resourceKind).get(name);
                    minor = true;
                } else {
                    graph = ((GraphEditorTab)editor).getGraph();
                    minor = ((GraphEditorTab)editor).isDirtMinor();
                }
                saved = this.saveAs ? this.doSaveGraphAs(graph) : this.doSaveGraph(graph, minor);
            } else {
                assert (resourceKind.isTextBased());
                String text = editor == null ? this.getGrammarStore().getTexts(resourceKind).get(name) : ((TextTab)editor).getProgram();
                boolean bl = saved = this.saveAs ? this.doSaveTextAs(name, text) : this.doSaveText(name, text);
            }
            if (editor != null && saved) {
                editor.setClean();
            }
        }
    }

    public boolean doSaveGraph(AspectGraph graph, boolean minor) {
        boolean result = false;
        ResourceKind resource = ResourceKind.toResource(graph.getRole());
        try {
            this.getSimulatorModel().doAddGraph(resource, graph, minor);
            result = true;
        }
        catch (IOException exc) {
            this.showErrorDialog(exc, "Error while saving %s '%s'", this.getResourceKind().getDescription(), graph.getName());
        }
        return result;
    }

    public boolean doSaveGraphAs(AspectGraph graph) {
        boolean result = false;
        File selectedFile = this.askSaveResource(graph.getName());
        if (selectedFile != null) {
            try {
                String nameInGrammar = this.getNameInGrammar(selectedFile);
                if (nameInGrammar == null) {
                    ExtensionFilter filter = this.getResourceKind().getFilter();
                    String newName = filter.stripExtension(selectedFile.getName());
                    GxlIO.getInstance().saveGraph((Graph)graph.rename(newName).toPlainGraph(), selectedFile);
                } else {
                    result = this.doSaveGraph(graph.rename(nameInGrammar), false);
                }
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error while writing %s to '%s'", this.getResourceKind().getDescription(), selectedFile);
            }
        }
        return result;
    }

    public boolean doSaveText(String name, String text) {
        boolean result = false;
        if (this.isForPrologProgram() && this.endsInGarbage(text)) {
            this.showErrorDialog(null, "The last non-empty characted of a Prolog program must be a dot: '.'", new Object[0]);
        } else {
            try {
                this.getSimulatorModel().doAddText(this.getResourceKind(), name, text);
                result = true;
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error saving %s '%s'", this.getResourceKind().getDescription(), name);
            }
        }
        return result;
    }

    public boolean doSaveTextAs(String name, String text) {
        boolean result = false;
        File selectedFile = this.askSaveResource(name);
        if (selectedFile != null) {
            try {
                String nameInGrammar = this.getNameInGrammar(selectedFile);
                if (nameInGrammar == null) {
                    TextBasedModel.store(text, new FileOutputStream(selectedFile));
                } else {
                    result = this.doSaveText(nameInGrammar, text);
                }
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, "Error while writing %s to '%s'", this.getResourceKind().getDescription(), selectedFile);
            }
        }
        return result;
    }

    @Override
    public void refresh() {
        String name;
        boolean enabled = false;
        ResourceKind resource = this.getResourceKind();
        if (this.isForState()) {
            enabled = this.getSimulatorModel().hasState();
        } else {
            name = this.getSimulatorModel().getSelected(resource);
            if (name != null) {
                ResourceTab editor = this.getDisplay().getEditor(name);
                enabled = this.saveAs || editor != null && editor.isDirty();
            }
        }
        this.setEnabled(enabled);
        name = this.isForState() ? Options.getSaveStateActionName(this.saveAs) : Options.getSaveActionName(resource, this.saveAs);
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }

    private boolean isForState() {
        return this.getDisplaysPanel().getSelectedDisplay() == this.getLtsDisplay() && this.getLtsDisplay().isActive();
    }

    private boolean isForPrologProgram() {
        return this.getDisplaysPanel().getSelectedDisplay() == this.getPrologDisplay() && this.getPrologDisplay().isActive();
    }

    private boolean endsInGarbage(String text) {
        int lastDotIndex = text.lastIndexOf(".");
        boolean result = false;
        int i = lastDotIndex + 1;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r') {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }
}

