/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.gui.layout.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SpringLayout;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class BugReportDialog
extends JDialog
implements ActionListener,
HyperlinkListener {
    private static final String DIALOG_TITLE = "Uncaught Exception in GROOVE";
    private static final String CANCEL_COMMAND = "Close GROOVE";
    private static final String ERROR_MSG = "<HTML><BODY><FONT FACE=\"Arial\", SIZE=4>Oops, it seems that GROOVE just crashed on you. Sorry...<BR>This undesired behaviour was probably caused by a bug in the code.<BR>Please help the developers to improve the tool by submitting a <I>Bug Report</i> at the GROOVE project page on SourceForge: <A HREF=\"http://sourceforge.net/projects/groove/develop\">http://sourceforge.net/projects/groove/develop</A><BR>In the link given, select menu 'Tracker' and option 'Bugs' to create a new entry.<BR>While submitting your report please describe the steps that led to the crash and include the exception stack trace shown below.</FONT></HTML>";

    public BugReportDialog(Throwable e) {
        super((Frame)null, DIALOG_TITLE, true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        JPanel dialogContent = new JPanel(new SpringLayout());
        dialogContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                BugReportDialog.this.closeDialog();
            }
        });
        dialogContent.add(this.getErrorMessage());
        dialogContent.add(this.getStackTracePane(e));
        dialogContent.add(this.getButtonPanel());
        SpringUtilities.makeCompactGrid(dialogContent, 3, 1, 0, 0, 0, 0);
        this.add(dialogContent);
        this.pack();
        this.setVisible(true);
    }

    private JEditorPane getErrorMessage() {
        JEditorPane errorMsg = new JEditorPane();
        errorMsg.setEditable(false);
        errorMsg.setPreferredSize(new Dimension(700, 130));
        errorMsg.setBackground(null);
        Font font = new Font("Sans", 0, 6);
        errorMsg.setFont(font);
        errorMsg.setEditorKit(new HTMLEditorKit());
        errorMsg.addHyperlinkListener(this);
        errorMsg.setText(ERROR_MSG);
        return errorMsg;
    }

    private JScrollPane getStackTracePane(Throwable e) {
        JTextPane stackTracePane = new JTextPane();
        stackTracePane.setEditable(false);
        Font font = new Font("Serif", 0, 12);
        stackTracePane.setFont(font);
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        stackTracePane.setText("Exception in GROOVE " + sw.toString());
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        noWrapPanel.add(stackTracePane);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(700, 300));
        scrollPane.setBorder(BorderFactory.createTitledBorder(null, "Exception Stack Trace:", 0, 0));
        scrollPane.setViewportView(noWrapPanel);
        return scrollPane;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton cancelButton = new JButton(CANCEL_COMMAND);
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals(CANCEL_COMMAND)) {
            this.closeDialog();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                Desktop.getDesktop().browse(evt.getURL().toURI());
            }
            catch (Exception exception) {}
        }
    }

    private void closeDialog() {
        this.dispose();
    }
}

