/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import java.awt.Dimension;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class ExploreWarningDialog {
    private JOptionPane optionPane;
    private JPanel messagePanel;
    private JLabel messageLabel;
    private JPanel choiceComponent;
    private JRadioButton boundedButton;
    private JRadioButton unboundedButton;
    private JSpinner boundSpinner;
    private SpinnerNumberModel boundSpinnerModel;
    private boolean answer;
    private final MyPropertyListener listener = new MyPropertyListener();
    private int bound;
    private static ExploreWarningDialog instance = new ExploreWarningDialog();

    private ExploreWarningDialog() {
    }

    public boolean ask(Frame owner) {
        this.getMessageLabel().setText(String.format("Exploration has generated %s states", this.getBound()));
        this.getBoundSpinnerModel().setMinimum(Integer.valueOf(this.getBound() + 1));
        this.getBoundSpinnerModel().setValue(this.getBound() * 2);
        JDialog dialog = this.createDialog(owner);
        dialog.setVisible(true);
        dialog.dispose();
        return this.answer;
    }

    private JDialog createDialog(Frame owner) {
        JDialog result = this.getOptionPane().createDialog(owner, "Exploration Progress");
        this.getListener().setDialog(result);
        return result;
    }

    private JOptionPane getOptionPane() {
        if (this.optionPane == null) {
            this.optionPane = new JOptionPane(this.getMessagePanel(), 3, 2);
            this.optionPane.addPropertyChangeListener(this.listener);
        }
        return this.optionPane;
    }

    private JPanel getMessagePanel() {
        if (this.messagePanel == null) {
            this.messagePanel = new JPanel();
            this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 1));
            this.messagePanel.add(this.getMessageLabel());
            this.messagePanel.add(Box.createRigidArea(new Dimension(0, 5)));
            this.messagePanel.add(this.getChoiceComponent());
        }
        return this.messagePanel;
    }

    private JLabel getMessageLabel() {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setFont(this.messageLabel.getFont().deriveFont(1));
            this.messageLabel.setAlignmentX(0.0f);
        }
        return this.messageLabel;
    }

    private JPanel getChoiceComponent() {
        JPanel result = this.choiceComponent;
        if (result == null) {
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.getBoundedButton());
            buttons.add(this.getUnboundedButton());
            JPanel boundedPanel = new JPanel();
            boundedPanel.setLayout(new BoxLayout(boundedPanel, 0));
            boundedPanel.add(this.getBoundedButton());
            boundedPanel.add(Box.createRigidArea(new Dimension(3, 0)));
            boundedPanel.add(this.getBoundSpinner());
            boundedPanel.add(Box.createGlue());
            boundedPanel.setAlignmentX(0.0f);
            result = new JPanel();
            result.setLayout(new BoxLayout(result, 1));
            result.add(boundedPanel);
            result.add(this.getUnboundedButton());
            result.setAlignmentX(0.0f);
            this.choiceComponent = result;
        }
        return result;
    }

    private JRadioButton getBoundedButton() {
        if (this.boundedButton == null) {
            this.boundedButton = new JRadioButton("Continue up to", true);
        }
        return this.boundedButton;
    }

    private JRadioButton getUnboundedButton() {
        if (this.unboundedButton == null) {
            this.unboundedButton = new JRadioButton("Do unbounded exploration");
            this.unboundedButton.setAlignmentX(0.0f);
        }
        return this.unboundedButton;
    }

    private JSpinner getBoundSpinner() {
        if (this.boundSpinner == null) {
            this.boundSpinner = new JSpinner(this.getBoundSpinnerModel());
            Dimension d = this.boundSpinner.getPreferredSize();
            d.width = 30;
            this.boundSpinner.setPreferredSize(d);
            this.boundSpinner.setPreferredSize(d);
        }
        return this.boundSpinner;
    }

    private SpinnerNumberModel getBoundSpinnerModel() {
        if (this.boundSpinnerModel == null) {
            this.boundSpinnerModel = new SpinnerNumberModel();
            this.boundSpinnerModel.setValue(100000);
            this.boundSpinnerModel.setStepSize(100);
        }
        return this.boundSpinnerModel;
    }

    boolean isAnswer() {
        return this.answer;
    }

    void setAnswer(boolean answer) {
        this.answer = answer;
    }

    private MyPropertyListener getListener() {
        return this.listener;
    }

    public void setBound(int bound) {
        this.bound = bound;
    }

    public int getBound() {
        return this.bound;
    }

    public static ExploreWarningDialog instance() {
        return instance;
    }

    private class MyPropertyListener
    implements PropertyChangeListener {
        private JDialog dialog;

        MyPropertyListener() {
        }

        void setDialog(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.dialog != null && this.dialog.isVisible() && evt.getNewValue() instanceof Integer && evt.getPropertyName().equals("value")) {
                Integer value = (Integer)evt.getNewValue();
                ExploreWarningDialog.this.setAnswer(value == 0);
                if (ExploreWarningDialog.this.getBoundedButton().isSelected()) {
                    ExploreWarningDialog.this.setBound((Integer)ExploreWarningDialog.this.getBoundSpinnerModel().getValue());
                } else {
                    ExploreWarningDialog.this.setBound(Integer.MAX_VALUE);
                }
                this.dialog.setVisible(false);
                this.dialog = null;
            }
        }
    }
}

