/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.grammar.model.FormatException;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.grammar.type.TypeNode;
import groove.graph.EdgeRole;
import groove.io.HTMLConverter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindReplaceDialog {
    public static final int CANCEL = 0;
    public static final int FIND = 1;
    public static final int REPLACE = 2;
    private JOptionPane optionPane;
    private JButton replaceButton;
    private JButton findButton;
    private JButton cancelButton;
    private JComboBox oldField;
    private JTextField newField;
    private CloseListener nameFieldListener;
    private JLabel errorLabel;
    private JLabel oldTypeLabel;
    private JComboBox newTypeChoice;
    private final TypeGraph typeGraph;
    private final TypeLabel suggestedLabel;
    private static String DEFAULT_TITLE = "Find/Replace Labels";
    private static String OLD_TEXT = "Find label: ";
    private static String NEW_TEXT = "Replace with: ";

    public FindReplaceDialog(TypeGraph typeGraph, TypeLabel oldLabel) {
        this.typeGraph = typeGraph;
        this.suggestedLabel = oldLabel;
    }

    public int showDialog(JFrame frame, String title) {
        if (this.suggestedLabel != null) {
            this.getOldField().setSelectedItem(this.suggestedLabel);
            this.propagateSelection();
        }
        this.setReplaceEnabled();
        JDialog dialog = this.getOptionPane().createDialog(frame, title == null ? DEFAULT_TITLE : title);
        dialog.setVisible(true);
        Object response = this.getOptionPane().getValue();
        int result = response == this.getReplaceButton() || response == this.getNewField() ? 2 : (response == this.getFindButton() ? 1 : 0);
        return result;
    }

    private void propagateSelection() {
        TypeLabel selection = (TypeLabel)this.getOldField().getSelectedItem();
        this.getOldTypeLabel().setText(selection.getRole().getDescription(true));
        this.getNewTypeCombobox().setSelectedIndex(EdgeRole.getIndex(selection.getRole()));
        this.getNewField().setText(selection.text());
        this.getNewField().setSelectionStart(0);
        this.getNewField().setSelectionEnd(selection.text().length());
        this.getNewField().requestFocus();
    }

    public TypeLabel getOldLabel() {
        return (TypeLabel)this.getOldField().getSelectedItem();
    }

    public TypeLabel getNewLabel() {
        TypeLabel result;
        try {
            result = this.getNewLabelWithErrors();
        }
        catch (FormatException formatException) {
            result = null;
        }
        return result;
    }

    private TypeLabel getNewLabelWithErrors() throws FormatException {
        TypeLabel result = null;
        String text = this.getNewField().getText();
        if (text.length() > 0) {
            TypeLabel oldLabel;
            int labelType = this.getNewTypeCombobox().getSelectedIndex();
            result = TypeLabel.createLabel(EdgeRole.getRole(labelType), text);
            if (result.equals(oldLabel = this.getOldLabel())) {
                throw new FormatException("Old and new labels coincide", new Object[0]);
            }
            if (this.typeGraph.isNodeType(oldLabel) && this.typeGraph.isNodeType(result)) {
                TypeNode oldType = this.typeGraph.getNode(oldLabel);
                TypeNode newType = this.typeGraph.getNode(result);
                if (newType != null) {
                    if (this.typeGraph.isSubtype(oldType, newType)) {
                        throw new FormatException("New label '%s' is an existing supertype of '%s'", result, oldLabel);
                    }
                    if (this.typeGraph.isSubtype(newType, oldType)) {
                        throw new FormatException("New label '%s' is an existing subtype of '%s'", result, oldLabel);
                    }
                }
            }
        } else {
            throw new FormatException("Empty replacement label not allowed", new Object[0]);
        }
        return result;
    }

    private void setReplaceEnabled() {
        boolean enabled;
        try {
            this.getNewLabelWithErrors();
            this.getErrorLabel().setText("");
            enabled = true;
        }
        catch (FormatException exc) {
            this.getErrorLabel().setText(exc.getMessage());
            enabled = false;
        }
        this.getReplaceButton().setEnabled(enabled);
        this.getNameFieldListener().setEnabled(enabled);
    }

    private JOptionPane getOptionPane() {
        if (this.optionPane == null) {
            JLabel oldLabel = new JLabel(OLD_TEXT);
            JLabel newLabel = new JLabel(NEW_TEXT);
            oldLabel.setPreferredSize(newLabel.getPreferredSize());
            JPanel oldPanel = new JPanel(new BorderLayout());
            oldPanel.add((Component)oldLabel, "West");
            oldPanel.add((Component)this.getOldField(), "Center");
            oldPanel.add((Component)this.getOldTypeLabel(), "East");
            JPanel newPanel = new JPanel(new BorderLayout());
            newPanel.add((Component)newLabel, "West");
            newPanel.add((Component)this.getNewField(), "Center");
            newPanel.add((Component)this.getNewTypeCombobox(), "East");
            JPanel errorPanel = new JPanel(new BorderLayout());
            errorPanel.add(this.getErrorLabel());
            errorPanel.setPreferredSize(oldPanel.getPreferredSize());
            this.optionPane = new JOptionPane(new Object[]{oldPanel, newPanel, errorPanel}, -1, 2, null, new Object[]{this.getFindButton(), this.getReplaceButton(), this.getCancelButton()});
        }
        return this.optionPane;
    }

    private JButton getReplaceButton() {
        if (this.replaceButton == null) {
            this.replaceButton = new JButton("Replace");
            this.replaceButton.addActionListener(new CloseListener());
        }
        return this.replaceButton;
    }

    private JButton getFindButton() {
        if (this.findButton == null) {
            this.findButton = new JButton("Find");
            this.findButton.addActionListener(new CloseListener());
        }
        return this.findButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new CloseListener());
        }
        return this.cancelButton;
    }

    private JComboBox getOldField() {
        if (this.oldField == null) {
            JComboBox result = this.oldField = this.getLabelComboBox(this.typeGraph);
            result.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FindReplaceDialog.this.propagateSelection();
                }
            });
        }
        return this.oldField;
    }

    private JTextField getNewField() {
        if (this.newField == null) {
            this.newField = new JTextField();
            this.newField.getDocument().addDocumentListener(new OverlapListener());
            this.newField.addActionListener(this.getNameFieldListener());
        }
        return this.newField;
    }

    private CloseListener getNameFieldListener() {
        if (this.nameFieldListener == null) {
            this.nameFieldListener = new CloseListener();
        }
        return this.nameFieldListener;
    }

    private JLabel getErrorLabel() {
        if (this.errorLabel == null) {
            JLabel result = this.errorLabel = new JLabel();
            result.setForeground(Color.RED);
            result.setMinimumSize(this.getReplaceButton().getPreferredSize());
        }
        return this.errorLabel;
    }

    private JLabel getOldTypeLabel() {
        if (this.oldTypeLabel == null) {
            JLabel result = this.oldTypeLabel = new JLabel();
            result.setText(this.getOldLabel().getRole().getDescription(true));
            result.setPreferredSize(this.getNewTypeCombobox().getPreferredSize());
            result.setBorder(new EtchedBorder());
            result.setEnabled(true);
            result.setFocusable(false);
        }
        return this.oldTypeLabel;
    }

    private JComboBox getLabelComboBox(TypeGraph typeGraph) {
        JComboBox<Object> result = new JComboBox<Object>();
        result.setFocusable(false);
        result.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof TypeLabel) {
                    value = HTMLConverter.HTML_TAG.on(TypeLabel.toHtmlString((TypeLabel)value));
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        for (TypeLabel label : this.sortLabels(typeGraph.getLabels())) {
            if (label.isDataType() || label == TypeLabel.NODE) continue;
            result.addItem(label);
        }
        return result;
    }

    private List<TypeLabel> sortLabels(Set<TypeLabel> labels) {
        ArrayList<TypeLabel> result = new ArrayList<TypeLabel>(labels.size());
        ArrayList<TypeLabel> nodeTypes = new ArrayList<TypeLabel>();
        ArrayList<TypeLabel> flags = new ArrayList<TypeLabel>();
        ArrayList<TypeLabel> binary = new ArrayList<TypeLabel>();
        for (TypeLabel label : labels) {
            switch (label.getRole()) {
                case NODE_TYPE: {
                    nodeTypes.add(label);
                    break;
                }
                case FLAG: {
                    flags.add(label);
                    break;
                }
                case BINARY: {
                    binary.add(label);
                }
            }
        }
        Collections.sort(nodeTypes);
        Collections.sort(flags);
        Collections.sort(binary);
        result.addAll(nodeTypes);
        result.addAll(flags);
        result.addAll(binary);
        return result;
    }

    private JComboBox getNewTypeCombobox() {
        if (this.newTypeChoice == null) {
            final JComboBox<String> result = this.newTypeChoice = new JComboBox<String>();
            EdgeRole[] edgeRoleArray = EdgeRole.values();
            int n = edgeRoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                EdgeRole kind = edgeRoleArray[n2];
                result.addItem(kind.getDescription(true));
                ++n2;
            }
            result.setSelectedIndex(EdgeRole.getIndex(this.getOldLabel().getRole()));
            result.setEnabled(true);
            result.setFocusable(false);
            result.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int fontProperty;
                    Font font = FindReplaceDialog.this.getNewField().getFont();
                    switch (EdgeRole.getRole(result.getSelectedIndex())) {
                        case NODE_TYPE: {
                            fontProperty = 1;
                            break;
                        }
                        case FLAG: {
                            fontProperty = 2;
                            break;
                        }
                        default: {
                            fontProperty = 0;
                        }
                    }
                    font = font.deriveFont(fontProperty);
                    FindReplaceDialog.this.getNewField().setFont(font);
                    FindReplaceDialog.this.setReplaceEnabled();
                }
            });
        }
        return this.newTypeChoice;
    }

    private class CloseListener
    implements ActionListener {
        private boolean enabled = true;

        CloseListener() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.enabled) {
                FindReplaceDialog.this.getOptionPane().setValue(e.getSource());
                FindReplaceDialog.this.getOptionPane().setVisible(false);
            }
        }
    }

    private class OverlapListener
    implements DocumentListener {
        OverlapListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.testRenaming();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.testRenaming();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.testRenaming();
        }

        private void testRenaming() {
            FindReplaceDialog.this.setReplaceEnabled();
        }
    }
}

