/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.gui.Simulator;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.io.GrooveFileChooser;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SaveLTSAsDialog {
    private String currentDirectory;
    private JButton okButton;
    private JButton cancelButton;
    public static final String DIALOG_TITLE = "Save LTS As";
    private JOptionPane pane;
    private JDialog dialog;
    private Simulator simulator;
    private JTextField dirField;
    private JCheckBox startCheck;
    private JCheckBox finalCheck;
    private JCheckBox openCheck;
    private JCheckBox nameCheck;
    JRadioButton list0;
    JRadioButton list1;
    JRadioButton list2;
    public static final int STATES_NONE = 0;
    public static final int STATES_FINAL = 1;
    public static final int STATES_ALL = 2;

    public SaveLTSAsDialog(Simulator simulator) {
    }

    public void setCurrentDirectory(String value) {
        this.currentDirectory = value;
    }

    public boolean showDialog(Simulator simulator) {
        this.simulator = simulator;
        this.getContentPane().setVisible(true);
        this.dialog = this.getContentPane().createDialog(simulator.getFrame(), this.createTitle());
        this.dialog.setVisible(true);
        return this.getContentPane().getValue() == this.getOkButton();
    }

    JOptionPane getContentPane() {
        Object[] buttons = new Object[]{this.getOkButton(), this.getCancelButton()};
        if (this.pane == null) {
            this.pane = new JOptionPane(this.createPanel(), -1, 2, null, buttons);
        }
        return this.pane;
    }

    private JPanel createPanel() {
        JPanel result = new JPanel();
        JPanel panel = new JPanel();
        JPanel buttons = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel exportLabel = new JLabel("Target directory:");
        panel.add(exportLabel);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new FlowLayout());
        this.dirField = new JTextField(this.currentDirectory);
        filePanel.add(this.dirField);
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new BrowseButtonListener());
        filePanel.add(browseButton);
        panel.add(filePanel);
        panel.add(new JLabel(" "));
        panel.add(new JLabel("Saving options:"));
        this.startCheck = new JCheckBox("Label start state");
        this.finalCheck = new JCheckBox("Label final states");
        this.openCheck = new JCheckBox("Label open states");
        this.nameCheck = new JCheckBox("Save state names");
        panel.add(this.startCheck);
        panel.add(this.finalCheck);
        panel.add(this.openCheck);
        panel.add(this.nameCheck);
        panel.add(new JLabel(" "));
        panel.add(new JLabel("Save States:"));
        this.list0 = new JRadioButton("None", true);
        this.list1 = new JRadioButton("All states", false);
        this.list2 = new JRadioButton("Final states", false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.list0);
        group.add(this.list1);
        group.add(this.list2);
        panel.add(this.list0);
        panel.add(this.list1);
        panel.add(this.list2);
        panel.add(new JLabel(" "));
        this.okButton = this.getOkButton();
        this.cancelButton = this.getCancelButton();
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        result.add(panel);
        result.add(buttons);
        result.add(panel);
        return result;
    }

    private String createTitle() {
        return DIALOG_TITLE;
    }

    JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(new CloseListener());
        }
        return this.okButton;
    }

    JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new CloseListener());
        }
        return this.cancelButton;
    }

    public int getExportStates() {
        if (this.list0.isSelected()) {
            return 0;
        }
        if (this.list1.isSelected()) {
            return 2;
        }
        if (this.list2.isSelected()) {
            return 1;
        }
        return -1;
    }

    public File getFile() {
        return new File(this.dirField.getText());
    }

    public boolean showOpen() {
        return this.openCheck.isSelected();
    }

    public boolean showFinal() {
        return this.finalCheck.isSelected();
    }

    public boolean showNames() {
        return this.nameCheck.isSelected();
    }

    public boolean showStart() {
        return this.startCheck.isSelected();
    }

    class BrowseButtonListener
    implements ActionListener {
        BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtensionFilter filter = FileType.GXL_FILTER;
            GrooveFileChooser chooser = GrooveFileChooser.getFileChooser(filter);
            int result = chooser.showOpenDialog(SaveLTSAsDialog.this.simulator.getFrame());
            if (result == 0) {
                SaveLTSAsDialog.this.dirField.setText(((JFileChooser)chooser).getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class CloseListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            Object value = e.getSource();
            SaveLTSAsDialog.this.getContentPane().setValue(value);
            SaveLTSAsDialog.this.getContentPane().setVisible(false);
        }
    }
}

