/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.dialog;

import groove.grammar.GrammarProperties;
import groove.gui.dialog.ContributorsTable;
import groove.gui.dialog.LibrariesTable;
import groove.io.HTMLConverter;
import groove.util.Version;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.CompoundBorder;

public class VersionDialog {
    public static boolean showNew(Component parent, GrammarProperties grammarProperties) {
        String msg = "<HTML><FONT color=#770000>Warning: </FONT>loading grammar from newer GROOVE version (<FONT color=#000077>" + grammarProperties.getGrooveVersion() + "</FONT>, current is " + "<FONT color=#000077>" + Version.getCurrentGrooveVersion() + "</FONT>).\nOpening this grammar may cause errors. " + "Continue anyway?\n\n";
        int buttonPressed = JOptionPane.showConfirmDialog(parent, msg, "Warning: loading new grammar", 0);
        return buttonPressed == 0;
    }

    public static int showOldFile(Component parent, GrammarProperties grammarProperties) {
        StringBuilder msg = new StringBuilder(HTMLConverter.HTML_TAG.tagBegin);
        msg.append("<FONT color=#770000>Warning: </FONT>");
        if (grammarProperties.getGrooveVersion().equals("0.0.0")) {
            msg.append("loading unrecognized grammar version (absent or outdated system properties file).\n");
        } else {
            msg.append("loading grammar from old GROOVE version (<FONT color=#000077>" + grammarProperties.getGrooveVersion() + "</FONT>, current is " + "<FONT color=#000077>" + Version.getCurrentGrooveVersion() + "</FONT>).\n");
        }
        msg.append("Loading this grammar will automatically convert it to the current version.");
        String overwrite_text = "Convert";
        String save_as_text = "Convert As";
        String cancel_text = "Cancel";
        Object[] options = new String[]{overwrite_text, save_as_text, cancel_text};
        switch (JOptionPane.showOptionDialog(parent, msg.toString().toString(), "Warning: loading old grammar", 1, 3, null, options, overwrite_text)) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return -1;
    }

    public static boolean showOldURL(Component parent, GrammarProperties grammarProperties) {
        String msg = "<HTML><FONT color=#770000>Warning: </FONT>loading grammar from old GROOVE version (<FONT color=#000077>" + grammarProperties.getGrooveVersion() + "</FONT>, current is " + "<FONT color=#000077>" + Version.getCurrentGrooveVersion() + "</FONT>).\nLoading this grammar will automatically convert " + "it (as a new grammar) to the current version.\n\n";
        String save_as_text = "Convert As";
        String cancel_text = "Cancel";
        Object[] options = new String[]{save_as_text, cancel_text};
        int buttonPressed = JOptionPane.showOptionDialog(parent, msg, "Warning: loading old grammar", 0, 3, null, options, save_as_text);
        return buttonPressed == 0;
    }

    public static void showAbout(final Component parent) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(null);
        buttonPanel.add(new JButton(new AbstractAction("External Libraries"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibrariesTable.instance().showDialog(parent);
            }
        }));
        buttonPanel.add(new JButton(new AbstractAction("Contributors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContributorsTable.instance().showDialog(parent, "Contributors");
            }
        }));
        CompoundBorder aboutBorder = new CompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JTextPane aboutLabel = new JTextPane();
        aboutLabel.setBorder(aboutBorder);
        aboutLabel.setContentType("text/html");
        aboutLabel.setText(Version.getAboutHTML());
        aboutLabel.setEditable(false);
        JPanel aboutPanel = new JPanel(new BorderLayout());
        aboutPanel.add(aboutLabel);
        aboutPanel.add((Component)buttonPanel, "South");
        JOptionPane.showMessageDialog(parent, aboutPanel, "About", 1);
    }
}

