/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.algebra.Algebras;
import groove.annotation.Help;
import groove.automaton.RegExpr;
import groove.grammar.aspect.AspectGraph;
import groove.grammar.aspect.AspectKind;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.GraphBasedModel;
import groove.grammar.model.ResourceModel;
import groove.graph.EdgeRole;
import groove.graph.GraphInfo;
import groove.graph.GraphProperties;
import groove.graph.GraphRole;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.action.SnapToGridAction;
import groove.gui.dialog.PropertiesTable;
import groove.gui.display.JGraphPanel;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.ResourceTab;
import groove.gui.display.TitledPanel;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.AspectJModel;
import groove.gui.jgraph.JAttr;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraphMode;
import groove.gui.tree.TypeTree;
import groove.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphUndoManager;

public final class GraphEditorTab
extends ResourceTab
implements GraphModelListener,
PropertyChangeListener {
    private AspectJGraph jgraph;
    private JGraphPanel<AspectGraph> editArea;
    private JTabbedPane upperInfoPanel;
    private TitledPanel labelPanel;
    private TypeTree labelTree;
    private PropertiesTable propertiesPanel;
    private boolean listenToPropertiesPanel;
    private JComponent syntaxHelp;
    private Map<String, String> docMap;
    private Set<String> nodeKeys;
    private Set<String> edgeKeys;
    transient JToggleButton snapToGridButton;
    private int dirtCount;
    private boolean dirtMinor;
    private transient GraphUndoManager undoManager;
    private transient boolean refreshing;
    private final GraphRole role;
    private static boolean clipboardFilled;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action redoAction;
    private Action undoAction;
    private Action deleteAction;

    public GraphEditorTab(ResourceDisplay parent, GraphRole role) {
        super(parent);
        this.role = role;
        this.setFocusCycleRoot(true);
        this.setSnapToGrid();
        this.initListeners();
        this.start();
    }

    public void setGraph(AspectGraph graph) {
        AspectJModel oldModel = this.getJModel();
        if (oldModel != null) {
            oldModel.removeUndoableEditListener((UndoableEditListener)this.getUndoManager());
            oldModel.removeGraphModelListener(this);
        }
        this.setName(graph.getName());
        AspectJModel newModel = this.getJGraph().newModel();
        newModel.setBeingEdited(true);
        AspectGraph graphClone = graph.clone();
        graphClone.setFixed();
        newModel.loadGraph(graphClone);
        this.getJGraph().setModel((GraphModel)newModel);
        this.loadProperties(graphClone, true);
        newModel.addUndoableEditListener((UndoableEditListener)this.getUndoManager());
        newModel.addGraphModelListener(this);
        this.setClean();
        this.getUndoManager().discardAllEdits();
        this.updateHistoryButtons();
        this.updateStatus();
    }

    public AspectGraph getGraph() {
        return this.getJModel().getGraph();
    }

    @Override
    protected Observer createErrorListener() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                JCell errorCell;
                if (arg != null && (errorCell = (JCell)GraphEditorTab.this.getJModel().getErrorMap().get(arg)) != null) {
                    GraphEditorTab.this.getJGraph().setSelectionCell(errorCell);
                }
            }
        };
    }

    @Override
    protected JToolBar createToolBar() {
        JToolBar result = super.createToolBar();
        result.addSeparator();
        result.add(this.getJGraph().getModeButton(JGraphMode.EDIT_MODE));
        result.add(this.getJGraph().getModeButton(JGraphMode.PREVIEW_MODE));
        result.addSeparator();
        result.add(this.getUndoAction());
        result.add(this.getRedoAction());
        result.addSeparator();
        result.add(this.getCopyAction());
        result.add(this.getPasteAction());
        result.add(this.getCutAction());
        result.add(this.getDeleteAction());
        result.addSeparator();
        result.add(this.getSnapToGridButton());
        this.processToolBar(result);
        return result;
    }

    private void processToolBar(JToolBar toolBar) {
        int i = 0;
        while (i < toolBar.getComponentCount()) {
            JButton button;
            Action action;
            Component element = toolBar.getComponent(i);
            if (element instanceof JButton && (action = (button = (JButton)element).getAction()) != null) {
                this.getJGraph().addAccelerator(action);
            }
            ++i;
        }
        toolBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GraphEditorTab.this.getJGraph().requestFocus();
            }
        });
    }

    public GraphRole getRole() {
        return this.role;
    }

    @Override
    public void updateGrammar(GrammarModel grammar) {
        AspectGraph source;
        GraphBasedModel graphModel = (GraphBasedModel)grammar.getResource(this.getResourceKind(), this.getName());
        AspectGraph aspectGraph = source = graphModel == null ? null : graphModel.getSource();
        if (source == null) {
            this.dispose();
        } else if (this.isDirty() || source == this.getGraph()) {
            GraphProperties properties = GraphInfo.getProperties(source);
            if (!properties.equals(GraphInfo.getProperties(this.getGraph()))) {
                this.changeProperties(properties, true);
            } else {
                this.getJModel().setGraphModified();
                this.getJGraph().refresh();
            }
            this.updateStatus();
        } else {
            this.setGraph(source);
        }
    }

    @Override
    public void setClean() {
        this.dirtCount = 0;
        this.dirtMinor = true;
        this.updateDirty();
    }

    public void setDirty(boolean minor) {
        this.dirtCount = Math.abs(this.dirtCount) + 1;
        this.dirtMinor &= minor;
        this.updateDirty();
    }

    @Override
    public boolean isDirty() {
        return this.dirtCount != 0;
    }

    public boolean isDirtMinor() {
        return this.dirtMinor;
    }

    public void rename(String newName) {
        AspectGraph newGraph = this.getGraph().clone();
        newGraph.setName(newName);
        newGraph.setFixed();
        this.getJModel().loadGraph(newGraph);
        this.loadProperties(newGraph, true);
        this.setName(newName);
        this.updateStatus();
    }

    private void changeProperties(Map<?, ?> propertiesMap, boolean updatePropertiesPanel) {
        AspectGraph newGraph = this.getGraph().clone();
        GraphProperties newProperties = new GraphProperties((Map<? extends Object, ? extends Object>)propertiesMap);
        GraphInfo.setProperties(newGraph, newProperties);
        newGraph.setFixed();
        this.getJModel().loadGraph(newGraph);
        this.loadProperties(newGraph, updatePropertiesPanel);
        this.updateStatus();
    }

    private void loadProperties(AspectGraph newGraph, boolean updatePropertiesPanel) {
        if (updatePropertiesPanel) {
            this.listenToPropertiesPanel = false;
            this.getPropertiesPanel().setProperties(GraphInfo.getProperties(newGraph));
            this.listenToPropertiesPanel = true;
        }
    }

    @Override
    public boolean setResource(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeResource(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ResourceModel<?> getResource() {
        return this.getJModel().getResourceModel();
    }

    @Override
    protected void saveResource() {
        this.getSaveAction().doSaveGraph(this.getGraph(), this.isDirtMinor());
        this.setClean();
    }

    public AspectJGraph getJGraph() {
        AspectJGraph result = this.jgraph;
        if (result == null) {
            result = this.jgraph = new AspectJGraph(this.getSimulator(), this.getDisplay().getKind(), true);
            result.setLabelTree(this.getLabelTree());
        }
        return result;
    }

    public AspectJModel getJModel() {
        return this.getJGraph().getModel();
    }

    public void graphChanged(GraphModelEvent e) {
        boolean changed;
        boolean bl = changed = e.getChange().getInserted() != null || e.getChange().getRemoved() != null || e.getChange().getAttributes() != null;
        if (changed) {
            this.updateStatus();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        assert (evt.getPropertyName().equals("JGraphMode"));
        JGraphMode mode = this.getJGraph().getMode();
        if (mode == JGraphMode.PREVIEW_MODE || evt.getOldValue() == JGraphMode.PREVIEW_MODE) {
            this.refreshing = true;
            this.getJModel().syncGraph();
            this.getJGraph().setEditable(mode != JGraphMode.PREVIEW_MODE);
            this.getJGraph().refreshAllCells();
            this.getJGraph().refresh();
            this.refreshing = false;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getSnapToGridAction().removeSnapListener(this);
        this.getJGraph().removeListeners();
    }

    private void initListeners() {
        this.getJGraph().setToolTipEnabled(true);
        this.getJGraph().getSelectionModel().addGraphSelectionListener(new GraphSelectionListener(){

            public void valueChanged(GraphSelectionEvent e) {
                boolean selected = !GraphEditorTab.this.getJGraph().isSelectionEmpty();
                GraphEditorTab.this.getDeleteAction().setEnabled(selected);
                GraphEditorTab.this.getCopyAction().setEnabled(selected);
                GraphEditorTab.this.getCutAction().setEnabled(selected);
            }
        });
        this.getJGraph().addJGraphModeListener(this);
        this.getSnapToGridAction().addSnapListener(this);
    }

    private GraphUndoManager getUndoManager() {
        if (this.undoManager == null) {
            this.undoManager = new GraphUndoManager(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    boolean relevant = true;
                    boolean minor = true;
                    if (GraphEditorTab.this.refreshing || GraphEditorTab.this.getJGraph().isModelRefreshing()) {
                        relevant = false;
                    } else if (e.getEdit() instanceof GraphLayoutCacheEvent.GraphLayoutCacheChange) {
                        GraphModelEvent.GraphModelChange edit = (GraphModelEvent.GraphModelChange)e.getEdit();
                        Object[] inserted = edit.getInserted();
                        Object[] removed = edit.getRemoved();
                        Object[] changed = edit.getChanged();
                        ConnectionSet connections = edit.getConnectionSet();
                        relevant = inserted != null && inserted.length > 0 || removed != null && removed.length > 0 || changed != null && changed.length > 0;
                        boolean bl = minor = !(connections != null && !connections.isEmpty() || inserted != null && inserted.length != 0 || removed != null && removed.length != 0);
                        if (minor && changed != null) {
                            Object[] objectArray = changed;
                            int n = changed.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object in = objectArray[n2];
                                AttributeMap attrs = (AttributeMap)edit.getAttributes().get(in);
                                if (GraphConstants.getValue((Map)attrs) != null) {
                                    minor = false;
                                    break;
                                }
                                ++n2;
                            }
                        }
                    } else {
                        minor = false;
                    }
                    if (relevant) {
                        super.undoableEditHappened(e);
                        GraphEditorTab.this.setDirty(minor);
                        GraphEditorTab.this.updateHistoryButtons();
                    }
                }
            };
        }
        return this.undoManager;
    }

    @Override
    protected JGraphPanel<?> getEditArea() {
        JGraphPanel<AspectGraph> result = this.editArea;
        if (result == null) {
            result = this.editArea = new JGraphPanel<AspectGraph>(this.getJGraph());
            result.setEnabledBackground(JAttr.EDITOR_BACKGROUND);
            result.initialise();
            result.setEnabled(true);
        }
        return result;
    }

    @Override
    protected JComponent getUpperInfoPanel() {
        JTabbedPane result = this.upperInfoPanel;
        if (result == null) {
            this.upperInfoPanel = result = new JTabbedPane();
            result.add(this.getLabelPanel());
            if (this.getResourceKind().hasProperties()) {
                PropertiesTable propertiesPanel = this.getPropertiesPanel();
                JScrollPane scrollPanel = new JScrollPane(propertiesPanel);
                scrollPanel.setName(propertiesPanel.getName());
                scrollPanel.getViewport().setBackground(propertiesPanel.getBackground());
                result.add(scrollPanel);
                result.addChangeListener(this.createInfoListener(true));
            }
        }
        if (this.getResourceKind().hasProperties()) {
            result.setSelectedIndex(this.getDisplay().getInfoTabIndex(true));
        }
        return result;
    }

    private TitledPanel getLabelPanel() {
        TitledPanel result = this.labelPanel;
        if (result == null) {
            TypeTree labelTree = this.getLabelTree();
            this.labelPanel = result = new TitledPanel("Labels", labelTree, labelTree.createToolBar(), true);
            result.setTitled(false);
            result.setEnabledBackground(JAttr.EDITOR_BACKGROUND);
        }
        return result;
    }

    private TypeTree getLabelTree() {
        TypeTree result = this.labelTree;
        if (result == null) {
            result = this.labelTree = new TypeTree(this.getJGraph(), false);
        }
        return result;
    }

    private PropertiesTable getPropertiesPanel() {
        PropertiesTable result = this.propertiesPanel;
        if (result == null) {
            this.propertiesPanel = result = new PropertiesTable(GraphProperties.getKeyMap(), true);
            result.setName("Properties");
            result.setBackground(JAttr.EDITOR_BACKGROUND);
            result.setProperties(GraphInfo.getProperties(this.getGraph()));
            result.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    if (GraphEditorTab.this.listenToPropertiesPanel) {
                        GraphEditorTab.this.changeProperties(GraphEditorTab.this.propertiesPanel.getProperties(), false);
                        GraphEditorTab.this.setDirty(false);
                    }
                }
            });
            this.listenToPropertiesPanel = true;
        }
        return result;
    }

    @Override
    protected JComponent getLowerInfoPanel() {
        JComponent result = this.syntaxHelp;
        if (result == null) {
            this.syntaxHelp = result = this.createSyntaxHelp();
        }
        return result;
    }

    private JComponent createSyntaxHelp() {
        this.initSyntax();
        final JTabbedPane tabbedPane = new JTabbedPane();
        final int nodeTabIndex = tabbedPane.getTabCount();
        tabbedPane.addTab("Nodes", null, this.createSyntaxList(this.nodeKeys), "Label prefixes that are allowed on nodes");
        final int edgeTabIndex = tabbedPane.getTabCount();
        tabbedPane.addTab("Edges", null, this.createSyntaxList(this.edgeKeys), "Label prefixes that are allowed on edges");
        if (this.role == GraphRole.RULE) {
            tabbedPane.addTab("RegExpr", null, this.createSyntaxList(RegExpr.getDocMap().keySet()), "Syntax for regular expressions over labels");
            tabbedPane.addTab("Expr", null, this.createSyntaxList(Algebras.getDocMap().keySet()), "Available attribute operators");
        }
        TitledPanel result = new TitledPanel("Label syntax help", tabbedPane, null, false);
        this.getJGraph().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "editedCell") {
                    int index = evt.getNewValue() instanceof AspectJEdge ? edgeTabIndex : nodeTabIndex;
                    tabbedPane.setSelectedIndex(index);
                }
            }
        });
        return result;
    }

    private JComponent createSyntaxList(Collection<String> data) {
        final JList<Object> list = new JList<Object>();
        list.setCellRenderer(new SyntaxCellRenderer());
        list.setBackground(JAttr.EDITOR_BACKGROUND);
        list.setListData(data.toArray());
        list.addMouseListener(new MouseAdapter(){
            private final ToolTipManager manager = ToolTipManager.sharedInstance();
            private final int standardDelay = this.manager.getDismissDelay();

            @Override
            public void mouseEntered(MouseEvent e) {
                if (e.getSource() == list) {
                    this.manager.setDismissDelay(Integer.MAX_VALUE);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (e.getSource() == list) {
                    this.manager.setDismissDelay(this.standardDelay);
                }
            }
        });
        list.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
            }

            @Override
            public void setLeadSelectionIndex(int leadIndex) {
            }
        });
        return new JScrollPane(list);
    }

    private void initSyntax() {
        if (this.nodeKeys != null) {
            return;
        }
        this.nodeKeys = new TreeSet<String>(AspectKind.getNodeDocMap(this.role).keySet());
        this.edgeKeys = new TreeSet<String>(AspectKind.getEdgeDocMap(this.role).keySet());
        Help extra = null;
        block4: for (Map.Entry<EdgeRole, Pair<String, String>> entry : EdgeRole.getRoleToDocMap().entrySet()) {
            String item = entry.getValue().one();
            switch (entry.getKey()) {
                case BINARY: {
                    if (this.role == GraphRole.RULE) {
                        extra = EdgeRole.createHelp();
                        extra.setSyntax("regexpr");
                        extra.setHeader("Regular expression path");
                        extra.setBody("An unadorned edge label in a rule by default denotes a regular expression.", "This means that labels with non-standard characters need to be quoted, or preceded with 'COLON'.");
                        this.edgeKeys.add(extra.getItem());
                        break;
                    }
                    this.edgeKeys.add(item);
                    break;
                }
                case NODE_TYPE: 
                case FLAG: {
                    this.nodeKeys.add(item);
                    break;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
        this.docMap = new HashMap<String, String>();
        this.docMap.putAll(AspectKind.getNodeDocMap(this.role));
        this.docMap.putAll(AspectKind.getEdgeDocMap(this.role));
        this.docMap.putAll(EdgeRole.getDocMap());
        this.docMap.putAll(RegExpr.getDocMap());
        this.docMap.putAll(Algebras.getDocMap());
        if (extra != null) {
            this.docMap.put(extra.getItem(), extra.getTip());
        }
    }

    private void updateHistoryButtons() {
        this.getUndoAction().setEnabled(this.getUndoManager().canUndo());
        this.getRedoAction().setEnabled(this.getUndoManager().canRedo());
        this.updateDirty();
    }

    private void updateCopyPasteButtons() {
        boolean previewing = this.getJGraph().getMode() == JGraphMode.PREVIEW_MODE;
        boolean hasSelection = !this.getJGraph().isSelectionEmpty();
        this.getCopyAction().setEnabled(!previewing && hasSelection);
        this.getCutAction().setEnabled(!previewing && hasSelection);
        this.getDeleteAction().setEnabled(!previewing && hasSelection);
        this.getPasteAction().setEnabled(!previewing && clipboardFilled);
    }

    private JToggleButton getSnapToGridButton() {
        if (this.snapToGridButton == null) {
            this.snapToGridButton = new JToggleButton(this.getSnapToGridAction());
            this.snapToGridButton.setFocusable(false);
            this.snapToGridButton.setText(null);
        }
        return this.snapToGridButton;
    }

    public void setSnapToGrid() {
        boolean snap = this.getSnapToGridAction().getSnap();
        this.getSnapToGridButton().setSelected(snap);
        this.getJGraph().setGridEnabled(snap);
        this.getJGraph().setGridVisible(snap);
    }

    private void updateStatus() {
        this.updateCopyPasteButtons();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphEditorTab.this.updateErrors();
            }
        });
        this.updateDirty();
        this.getTabLabel().setError(this.hasErrors());
    }

    private void undoLastEdit() {
        this.setSelectInsertedCells(false);
        this.getUndoManager().undo();
        --this.dirtCount;
        this.setSelectInsertedCells(true);
        this.updateHistoryButtons();
    }

    private void redoLastEdit() {
        this.setSelectInsertedCells(false);
        this.getUndoManager().redo();
        ++this.dirtCount;
        this.setSelectInsertedCells(true);
        this.updateHistoryButtons();
    }

    private void setSelectInsertedCells(boolean select) {
        this.jgraph.getGraphLayoutCache().setSelectsAllInsertedCells(select);
    }

    private Action getCutAction() {
        if (this.cutAction == null) {
            Action action = TransferHandler.getCutAction();
            action.putValue("AcceleratorKey", Options.CUT_KEY);
            this.cutAction = new TransferAction(action, Options.CUT_KEY, "Cut");
            this.cutAction.putValue("SmallIcon", Icons.CUT_ICON);
        }
        return this.cutAction;
    }

    private Action getCopyAction() {
        if (this.copyAction == null) {
            Action action = TransferHandler.getCopyAction();
            this.copyAction = new TransferAction(action, Options.COPY_KEY, "Copy");
            this.copyAction.putValue("SmallIcon", Icons.COPY_ICON);
        }
        return this.copyAction;
    }

    private Action getPasteAction() {
        if (this.pasteAction == null) {
            Action action = TransferHandler.getPasteAction();
            this.pasteAction = new TransferAction(action, Options.PASTE_KEY, "Paste");
            this.pasteAction.putValue("SmallIcon", Icons.PASTE_ICON);
            this.pasteAction.setEnabled(true);
        }
        return this.pasteAction;
    }

    private Action getRedoAction() {
        if (this.redoAction == null) {
            this.redoAction = new ToolbarAction("Redo", Options.REDO_KEY, Icons.REDO_ICON){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (this.isEnabled()) {
                        super.actionPerformed(evt);
                        GraphEditorTab.this.redoLastEdit();
                    }
                }
            };
            this.redoAction.setEnabled(false);
        }
        return this.redoAction;
    }

    private Action getUndoAction() {
        if (this.undoAction == null) {
            this.undoAction = new ToolbarAction("Undo", Options.UNDO_KEY, Icons.UNDO_ICON){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (this.isEnabled()) {
                        super.actionPerformed(evt);
                        GraphEditorTab.this.undoLastEdit();
                    }
                }
            };
            this.undoAction.setEnabled(false);
        }
        return this.undoAction;
    }

    private Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    private SnapToGridAction getSnapToGridAction() {
        return this.getSimulator().getActions().getSnapToGridAction();
    }

    private class DeleteAction
    extends ToolbarAction {
        protected DeleteAction() {
            super("Delete", Options.DELETE_KEY, Icons.DELETE_ICON);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (!GraphEditorTab.this.getJGraph().isSelectionEmpty()) {
                Object[] cells = GraphEditorTab.this.getJGraph().getSelectionCells();
                cells = GraphEditorTab.this.getJGraph().getDescendants(cells);
                GraphEditorTab.this.getJGraph().getModel().remove(cells);
            }
        }
    }

    private class SyntaxCellRenderer
    extends DefaultListCellRenderer {
        private SyntaxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (result == this) {
                this.setToolTipText((String)GraphEditorTab.this.docMap.get(value));
            }
            return result;
        }
    }

    private abstract class ToolbarAction
    extends AbstractAction {
        ToolbarAction(String name, KeyStroke acceleratorKey, Icon icon) {
            super(name, icon);
            this.putValue("ShortDescription", name);
            this.putValue("AcceleratorKey", acceleratorKey);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            GraphEditorTab.this.getJGraph().stopEditing();
        }
    }

    private class TransferAction
    extends ToolbarAction {
        protected Action action;

        public TransferAction(Action action, KeyStroke acceleratorKey, String name) {
            super(name, acceleratorKey, (ImageIcon)action.getValue("SmallIcon"));
            this.putValue("ShortDescription", name);
            this.setEnabled(false);
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            super.actionPerformed(evt);
            evt = new ActionEvent((Object)GraphEditorTab.this.getJGraph(), evt.getID(), evt.getActionCommand(), evt.getModifiers());
            this.action.actionPerformed(evt);
            if (this == GraphEditorTab.this.getCutAction() || this == GraphEditorTab.this.getCopyAction()) {
                clipboardFilled = true;
                GraphEditorTab.this.getPasteAction().setEnabled(true);
            }
        }
    }
}

