/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.display;

import groove.grammar.QualName;
import groove.grammar.model.FormatError;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.ResourceModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.action.CancelEditAction;
import groove.gui.action.SaveAction;
import groove.gui.action.SimulatorAction;
import groove.gui.display.Display;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.TabLabel;
import groove.gui.list.ErrorListPanel;
import groove.gui.list.ListPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ResourceTab
extends JPanel {
    private final ResourceDisplay display;
    private final ResourceKind resourceKind;
    private final Simulator simulator;
    private JSplitPane mainPanel;
    private ListPanel errorPanel;
    private TabLabel tabLabel;

    public ResourceTab(ResourceDisplay display) {
        Simulator simulator = display.getSimulator();
        this.display = display;
        this.resourceKind = display.getResourceKind();
        this.simulator = simulator;
        this.setBorder(null);
        this.setLayout(new BorderLayout());
        this.addAccelerator(this.getSaveAction());
        this.addAccelerator(this.getCancelAction());
    }

    protected void start() {
        if (this.isEditor()) {
            this.add((Component)this.createToolBar(), "North");
        }
        this.add(this.getMainPanel());
    }

    private void addAccelerator(SimulatorAction action) {
        KeyStroke key = (KeyStroke)action.getValue("AcceleratorKey");
        String name = (String)action.getValue("Name");
        this.getInputMap(1).put(key, name);
        this.getInputMap(0).put(key, name);
        this.getActionMap().put(name, action);
    }

    private JSplitPane getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JSplitPane(0, this.getEditArea(), this.getErrorPanel());
            this.mainPanel.setDividerSize(1);
            this.mainPanel.setContinuousLayout(true);
            this.mainPanel.setResizeWeight(0.9);
            this.mainPanel.resetToPreferredSizes();
            this.mainPanel.setBorder(null);
        }
        return this.mainPanel;
    }

    protected final ListPanel getErrorPanel() {
        if (this.errorPanel == null) {
            this.errorPanel = new ErrorListPanel(String.format("Errors in %s", this.getResourceKind().getDescription()));
            this.errorPanel.addSelectionListener(this.createErrorListener());
        }
        return this.errorPanel;
    }

    protected abstract JComponent getEditArea();

    protected abstract Observer createErrorListener();

    protected final void updateErrors() {
        this.getErrorPanel().setEntries(this.getErrors());
        if (this.getErrorPanel().isVisible()) {
            this.getMainPanel().setBottomComponent(this.getErrorPanel());
            this.getMainPanel().setDividerSize(1);
            this.getMainPanel().resetToPreferredSizes();
        } else {
            this.getMainPanel().remove(this.getErrorPanel());
            this.getMainPanel().setDividerSize(0);
        }
    }

    public Icon getIcon() {
        return Icons.getEditorTabIcon(this.getDisplay().getKind().getResource());
    }

    public String getTitle() {
        StringBuilder result = new StringBuilder(QualName.getLastName(this.getName()));
        return this.decorateText(result).toString();
    }

    protected abstract JComponent getUpperInfoPanel();

    protected abstract JComponent getLowerInfoPanel();

    protected ChangeListener createInfoListener(final boolean upper) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ResourceTab.this.getDisplay().setInfoTabIndex(upper, ((JTabbedPane)e.getSource()).getSelectedIndex());
            }
        };
    }

    public abstract void updateGrammar(GrammarModel var1);

    protected StringBuilder decorateText(StringBuilder text) {
        if (this.isDirty()) {
            text.insert(0, "*");
        }
        return text;
    }

    public final ResourceKind getResourceKind() {
        return this.resourceKind;
    }

    public abstract boolean setResource(String var1);

    public abstract boolean removeResource(String var1);

    public boolean isEditor() {
        return true;
    }

    protected JToolBar createToolBar() {
        JToolBar result = Options.createToolBar();
        result.add(this.createSaveButton());
        result.add(this.createCancelButton());
        return result;
    }

    public abstract boolean isDirty();

    public abstract void setClean();

    public boolean saveEditor(boolean confirm, boolean dispose) {
        boolean result = false;
        if (!confirm || this.confirmCancel()) {
            if (dispose) {
                this.dispose();
            }
            result = true;
        }
        return result;
    }

    public boolean confirmCancel() {
        boolean result = true;
        if (this.isDirty()) {
            int answer = JOptionPane.showConfirmDialog(this.getDisplay(), String.format("%s '%s' has been modified. Save changes?", this.getResourceKind().getName(), this.getName()), null, 1);
            if (answer == 0) {
                this.saveResource();
            }
            result = answer != 2;
        }
        return result;
    }

    public final TabLabel getTabLabel() {
        if (this.tabLabel == null) {
            this.tabLabel = this.createTabLabel();
        }
        return this.tabLabel;
    }

    private TabLabel createTabLabel() {
        return new TabLabel(this, this.getIcon(), this.getName());
    }

    protected void updateDirty() {
        this.getTabLabel().setTitle(this.display.getLabelText(this.getName()));
        this.getSaveAction().refresh();
        Display.ListPanel listPanel = this.display.getListPanel();
        if (listPanel != null) {
            listPanel.repaint();
        }
    }

    protected ResourceModel<?> getResource() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        return this.getSimulatorModel().getGrammar().getResource(this.getResourceKind(), name);
    }

    protected abstract void saveResource();

    public void dispose() {
        this.getDisplay().getTabPane().remove(this);
    }

    public final ResourceDisplay getDisplay() {
        return this.display;
    }

    protected Collection<FormatError> getErrors() {
        ResourceModel<?> resource = this.getResource();
        if (resource == null) {
            return Collections.emptyList();
        }
        return this.getResource().getErrors();
    }

    protected final boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    private JButton createCancelButton() {
        return Options.createButton(this.getCancelAction());
    }

    private JButton createSaveButton() {
        return Options.createButton(this.getSaveAction());
    }

    protected final CancelEditAction getCancelAction() {
        return this.getSimulator().getActions().getCancelEditAction(this.getResourceKind());
    }

    protected final SaveAction getSaveAction() {
        return this.getSimulator().getActions().getSaveAction(this.getResourceKind());
    }

    public final Simulator getSimulator() {
        return this.simulator;
    }

    protected final SimulatorModel getSimulatorModel() {
        return this.getSimulator().getModel();
    }

    protected final class EditMouseListener
    extends MouseAdapter {
        protected EditMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                ResourceTab.this.getDisplay().getEditAction().execute();
            }
        }
    }
}

