/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.gui.Options;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;

public class JAttr {
    public static final int DEFAULT_LINE_WIDTH = 1;
    public static final Color EDITOR_BACKGROUND;
    public static final Color STATE_BACKGROUND;
    public static final Color FILTER_BACKGROUND;
    public static final int NORMAL_ARC_SIZE = 5;
    public static final int STRONG_ARC_SIZE = 20;
    public static final Rectangle DEFAULT_NODE_BOUNDS;
    public static final Dimension DEFAULT_NODE_SIZE;
    public static final int EXTRA_BORDER_SPACE = 6;
    public static final Dimension NODE_EDGE_DIMENSION;
    public static final int ADORNMENT_HEIGHT = 12;
    public static final Font ADORNMENT_FONT;
    public static final Color RUBBER_FOREGROUND;
    public static final Color RUBBER_BACKGROUND;
    public static final int EMPH_WIDTH = 3;
    public static final int EMPH_INCREMENT = 2;
    private static final boolean GRADIENT_PAINT = false;
    public static String SHAPE_KEY;
    private static Map<Color, Color[]> gradientMap;

    static {
        Options.initLookAndFeel();
        EDITOR_BACKGROUND = new Color(255, 255, 230);
        STATE_BACKGROUND = new Color(242, 250, 254);
        FILTER_BACKGROUND = new Color(230, 230, 255);
        DEFAULT_NODE_BOUNDS = new Rectangle(10, 10, 19, 19);
        DEFAULT_NODE_SIZE = new Dimension(JAttr.DEFAULT_NODE_BOUNDS.width, JAttr.DEFAULT_NODE_BOUNDS.height);
        NODE_EDGE_DIMENSION = new Dimension(6, 6);
        ADORNMENT_FONT = Options.LABEL_FONT;
        RUBBER_FOREGROUND = new Color(150, 150, 150);
        RUBBER_BACKGROUND = new Color(100, 212, 224, 40);
        SHAPE_KEY = "vertexShape";
        gradientMap = new HashMap<Color, Color[]>();
    }

    public static Stroke createStroke(float width, float[] dash) {
        BasicStroke result = dash == null ? new BasicStroke(width, 2, 0) : new BasicStroke(width, 0, 0, 10.0f, dash, 1.0f);
        return result;
    }

    public static Paint createPaint(Rectangle b, Color c) {
        return c;
    }

    private static Color[] getGradient(Color c) {
        Color[] result = gradientMap.get(c);
        if (result == null) {
            float factor = 0.9f;
            Color inC = new Color((int)Math.min((float)c.getRed() / factor, 255.0f), (int)Math.min((float)c.getGreen() / factor, 255.0f), (int)Math.min((float)c.getBlue() / factor, 255.0f), c.getAlpha());
            Color outC = new Color((int)((float)c.getRed() * factor), (int)((float)c.getGreen() * factor), (int)((float)c.getBlue() * factor), c.getAlpha());
            result = new Color[]{inC, outC};
            gradientMap.put(c, result);
        }
        return result;
    }
}

