/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.graph.Graph;
import groove.gui.Icons;
import groove.gui.jgraph.AspectJEdge;
import groove.gui.jgraph.AspectJGraph;
import groove.gui.jgraph.JAttr;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JEdgeView;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JGraphMode;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.JVertexView;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.MouseInputAdapter;
import org.jgraph.graph.CellView;
import org.jgraph.plaf.basic.BasicGraphUI;

public class JGraphUI<G extends Graph>
extends BasicGraphUI {
    private static final boolean ADD_EDGE_BY_CLICK = true;

    private JGraph<G> getJGraph() {
        return (JGraph)this.graph;
    }

    private JGraphMode getJGraphMode() {
        return this.getJGraph().getMode();
    }

    protected void updateCachedPreferredSize() {
        CellView[] views = this.graphLayoutCache.getRoots();
        Rectangle2D.Double size = null;
        if (views != null && views.length > 0) {
            int i = 0;
            while (i < views.length) {
                Rectangle2D r;
                if (views[i] != null && !(views[i] instanceof JEdgeView) && (r = views[i].getBounds()) != null) {
                    if (size == null) {
                        size = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                    } else {
                        Rectangle2D.union(size, r, size);
                    }
                }
                ++i;
            }
        }
        if (size == null) {
            size = new Rectangle2D.Double();
        }
        Point2D.Double psize = new Point2D.Double(((RectangularShape)size).getX() + ((RectangularShape)size).getWidth(), ((RectangularShape)size).getY() + ((RectangularShape)size).getHeight());
        Dimension d = this.getJGraph().getMinimumSize();
        Point min = d != null ? this.getJGraph().toScreen(new Point(d.width, d.height)) : new Point(0, 0);
        Point2D scaled = this.getJGraph().toScreen(psize);
        this.preferredSize = new Dimension((int)Math.max(((Point2D)min).getX(), scaled.getX()), (int)Math.max(((Point2D)min).getY(), scaled.getY()));
        Insets in = this.graph.getInsets();
        if (in != null) {
            this.preferredSize.setSize(this.preferredSize.getWidth() + (double)in.left + (double)in.right, this.preferredSize.getHeight() + (double)in.top + (double)in.bottom);
        }
        this.validCachedPreferredSize = true;
    }

    protected Point2D getEditorLocation(Object cell, Dimension2D editorSize, Point2D pt) {
        double scale = this.getJGraph().getScale();
        return super.getEditorLocation(cell, editorSize, (Point2D)new Point2D.Double(pt.getX() + scale * 10.0 - 4.0, pt.getY() + scale * 9.0 - 3.0));
    }

    protected void installListeners() {
        super.installListeners();
        this.graph.addMouseWheelListener((MouseWheelListener)((Object)this.mouseListener));
    }

    public void drawGraph(Graphics g, Rectangle2D clipBounds) {
        super.drawGraph(g, clipBounds);
        if (!this.graph.isDoubleBuffered()) {
            this.getMouseListener().draw(g);
        }
    }

    protected void paintOverlay(Graphics g) {
        this.getMouseListener().draw(g);
    }

    private MouseHandler getMouseListener() {
        return (MouseHandler)this.mouseListener;
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    public void cancelEdgeAdding() {
        this.getMouseListener().cancelEdgeAdding(null);
    }

    static enum DragMode {
        MOVE,
        PAN,
        EDGE,
        SELECT;

    }

    public static class EdgePreview
    extends MouseInputAdapter {
        private final AspectJGraph canvas;
        private JVertexView dragOrigVertex = null;
        private JVertexView dragCurrVertex = null;
        private Point dragCurrPoint;

        public EdgePreview(AspectJGraph canvas) {
            this.canvas = canvas;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.dragOrigVertex = this.vertexAt(e.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.update(e);
            if (this.dragCurrVertex != null) {
                this.canvas.setSelectionCell(this.dragCurrVertex.getCell());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.update(e);
            this.dragOrigVertex = null;
        }

        private void update(MouseEvent e) {
            if (this.dragOrigVertex != null) {
                Rectangle dirty = this.getScreenBounds(this.dragOrigVertex).getBounds();
                if (this.dragCurrPoint != null) {
                    dirty.add(this.dragCurrPoint);
                }
                if (this.dragCurrVertex != null) {
                    dirty.add(this.dragCurrVertex.getBounds());
                }
                if (e != null) {
                    Point point;
                    this.dragCurrPoint = point = e.getPoint();
                    this.dragCurrVertex = this.vertexAt(point);
                    dirty.add(point);
                }
                if (this.dragCurrVertex != null) {
                    dirty.add(this.getScreenBounds(this.dragCurrVertex));
                }
                --dirty.x;
                --dirty.y;
                dirty.width += 2;
                dirty.height += 2;
                this.canvas.repaint(dirty);
            }
        }

        public void draw(Graphics g) {
            if (this.dragOrigVertex != null) {
                int endY;
                int endX;
                Rectangle2D startBounds = this.getScreenBounds(this.dragOrigVertex);
                int startX = (int)startBounds.getCenterX();
                int startY = (int)startBounds.getCenterY();
                if (this.dragCurrVertex != null && this.dragCurrVertex != this.dragOrigVertex) {
                    Rectangle2D endBounds = this.getScreenBounds(this.dragCurrVertex);
                    endX = (int)endBounds.getCenterX();
                    endY = (int)endBounds.getCenterY();
                } else {
                    endX = this.dragCurrPoint.x;
                    endY = this.dragCurrPoint.y;
                }
                g.setColor(Color.black);
                g.drawLine(startX, startY, endX, endY);
            }
        }

        Rectangle2D getScreenBounds(JVertexView vertex) {
            return this.canvas.toScreen((Rectangle2D)vertex.getBounds().clone());
        }

        JVertexView edgeStart() {
            return this.dragOrigVertex;
        }

        JVertexView edgeEnd() {
            return this.dragCurrVertex;
        }

        private JVertexView vertexAt(Point2D p) {
            JCell jCell = this.canvas.getFirstCellForLocation(p.getX(), p.getY(), true, false);
            return (JVertexView)this.canvas.getGraphLayoutCache().getMapping(jCell, false);
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements Serializable {
        private final RubberBand selectHandler;
        private final EdgePreview edgeHandler;
        private DragMode dragMode = DragMode.MOVE;
        private MouseEvent dragStart;
        private boolean edgeAdding;
        private MouseEvent edgeAddStart;
        private int dragOrigX = -1;
        private int dragOrigY = -1;

        MouseHandler() {
            this.selectHandler = new RubberBand((JComponent)((Object)JGraphUI.this.getJGraph()));
            this.edgeHandler = JGraphUI.this.getJGraph() instanceof AspectJGraph ? new EdgePreview((AspectJGraph)JGraphUI.this.getJGraph()) : null;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            boolean addEdge;
            block23: {
                block21: {
                    AspectJGraph jGraph;
                    block25: {
                        block24: {
                            block22: {
                                if (!this.isMyEvent(e)) {
                                    return;
                                }
                                addEdge = false;
                                if (JGraphUI.this.getJGraphMode() != JGraphMode.EDIT_MODE || e.getButton() != 1) break block21;
                                jGraph = (AspectJGraph)JGraphUI.this.getJGraph();
                                if (!this.isEdgeAdding() || e.getClickCount() != 1) break block22;
                                this.finishEdgeAdding(e);
                                break block23;
                            }
                            if (!e.isAltDown()) break block24;
                            JCell jEdge = this.getJEdgeAt(e.getPoint());
                            Object selectedCell = JGraphUI.this.getJGraph().getSelectionCell();
                            if (selectedCell instanceof JEdge) {
                                AspectJEdge selectedEdge = (AspectJEdge)selectedCell;
                                if (selectedCell == jEdge) {
                                    jGraph.getRemovePointAction(e.getPoint()).execute(selectedEdge);
                                } else {
                                    jGraph.getAddPointAction(e.getPoint()).execute(selectedEdge);
                                }
                            }
                            break block23;
                        }
                        if (this.getJCellAt(e.getPoint()) == null) break block25;
                        JCell jCell = this.getJCellAt(e.getPoint());
                        switch (e.getClickCount()) {
                            case 1: {
                                this.selectCellsForEvent(Collections.singleton(jCell), e);
                                addEdge = jCell instanceof JVertex && !e.isControlDown() && !e.isShiftDown();
                                break;
                            }
                            case 2: {
                                jGraph.startEditingAtCell(jCell);
                            }
                        }
                        break block23;
                    }
                    switch (e.getClickCount()) {
                        case 1: {
                            jGraph.clearSelection();
                            break;
                        }
                        case 2: {
                            if (!jGraph.isEditable()) break block23;
                            jGraph.addVertex(e.getPoint());
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block23;
                }
                if (e.getButton() != 3) {
                    JCell jCell = this.getJCellAt(e.getPoint());
                    if (jCell == null) {
                        JGraphUI.this.getJGraph().clearSelection();
                    } else {
                        this.selectCellsForEvent(Collections.singleton(jCell), e);
                    }
                }
            }
            if (this.isEdgeAdding()) {
                this.cancelEdgeAdding(e);
            } else if (addEdge && JGraphUI.this.getJGraph().isEditable()) {
                this.startEdgeAdding(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DragMode newDragMode;
            if (!this.isMyEvent(e)) {
                return;
            }
            JGraphUI.this.getJGraph().requestFocus();
            JGraphUI.this.stopEditing(JGraphUI.this.getJGraph());
            JCell jVertex = this.getJVertexAt(e.getPoint());
            JCell jEdge = this.getJEdgeAt(e.getPoint());
            if (JGraphUI.this.getJGraphMode() == JGraphMode.PAN_MODE && e.getButton() == 1) {
                newDragMode = DragMode.PAN;
            } else if (jVertex != null || jEdge != null) {
                if (JGraphUI.this.getJGraphMode() == JGraphMode.EDIT_MODE) {
                    e.getButton();
                }
                newDragMode = DragMode.MOVE;
            } else {
                newDragMode = DragMode.SELECT;
            }
            this.dragMode = newDragMode;
            this.dragStart = e;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.isMyEvent(e)) {
                return;
            }
            JGraphUI.autoscroll((org.jgraph.JGraph)JGraphUI.this.getJGraph(), (Point)e.getPoint());
            switch (this.dragMode) {
                case PAN: {
                    if (this.dragStart != null) {
                        this.dragOrigX = this.dragStart.getX();
                        this.dragOrigY = this.dragStart.getY();
                        this.selectHandler.mousePressed(this.dragStart);
                    }
                    if (this.isPanEnabled()) {
                        this.doPan(e);
                    }
                    return;
                }
                case MOVE: {
                    if (this.dragStart != null) {
                        JCell cell = this.getJEdgeAt(this.dragStart.getPoint());
                        if (cell == null || !JGraphUI.this.getJGraph().getSelectionModel().isCellSelected(cell)) {
                            cell = this.getJCellAt(this.dragStart.getPoint());
                            JGraphUI.this.getJGraph().setCursor(Icons.HAND_CLOSED_CURSOR);
                        }
                        if (!JGraphUI.this.getJGraph().isCellSelected(cell)) {
                            JGraphUI.this.getJGraph().setSelectionCell(cell);
                        }
                        JGraphUI.this.getHandle().mousePressed(this.dragStart);
                    }
                    if (JGraphUI.this.getHandle() == null) break;
                    JGraphUI.this.getHandle().mouseDragged(e);
                    break;
                }
                case EDGE: {
                    if (this.dragStart != null) {
                        this.edgeHandler.mousePressed(this.dragStart);
                    }
                    this.edgeHandler.mouseDragged(e);
                    break;
                }
                case SELECT: {
                    if (this.dragStart != null) {
                        this.selectHandler.mousePressed(this.dragStart);
                    }
                    this.selectHandler.mouseDragged(e);
                }
            }
            this.dragStart = null;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.isMyEvent(e)) {
                return;
            }
            if (this.dragStart == null && this.dragMode != null) {
                switch (this.dragMode) {
                    case EDGE: {
                        this.finishEdgeAdding(e);
                        break;
                    }
                    case MOVE: {
                        if (JGraphUI.this.getHandle() == null) break;
                        JGraphUI.this.getHandle().mouseReleased(e);
                        break;
                    }
                    case SELECT: {
                        this.completeSelect(e);
                        this.selectHandler.mouseReleased(e);
                        break;
                    }
                    case PAN: {
                        this.dragOrigX = -1;
                        this.dragOrigY = -1;
                    }
                }
            }
            JGraphUI.this.getJGraph().setCursor(JGraphUI.this.getJGraph().getMode().getCursor());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isMyEvent(e)) {
                return;
            }
            if (this.isEdgeAdding()) {
                if (e.isControlDown() || e.isShiftDown() || e.isAltDown()) {
                    this.cancelEdgeAdding(e);
                } else {
                    this.continueEdgeAdding(e);
                }
            } else if (JGraphUI.this.getHandle() != null) {
                JGraphUI.this.getHandle().mouseMoved(e);
                if (!e.isConsumed()) {
                    JGraphUI.this.getJGraph().setCursor(JGraphUI.this.getJGraph().getMode().getCursor());
                }
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!this.isMyEvent(e)) {
                return;
            }
            if (JGraphUI.this.getJGraph().getMode() == JGraphMode.PAN_MODE) {
                int change = -e.getWheelRotation();
                JGraphUI.this.getJGraph().changeScale(change);
            } else {
                JGraphUI.this.getJGraph().getParent().dispatchEvent(e);
            }
        }

        void draw(Graphics g) {
            if (this.dragMode == DragMode.SELECT) {
                this.selectHandler.draw(g);
            } else if (this.isEdgeAdding()) {
                this.edgeHandler.draw(g);
            }
        }

        private boolean isMyEvent(MouseEvent evt) {
            return evt != null && !evt.isConsumed() && JGraphUI.this.getJGraph().isEnabled() && !JGraphUI.this.getJGraph().isPopupMenuEvent(evt);
        }

        private void completeSelect(MouseEvent evt) {
            Rectangle bounds = this.selectHandler.getBounds();
            if (JGraphUI.this.getJGraphMode() == JGraphMode.PAN_MODE) {
                JGraphUI.this.getJGraph().zoomTo(bounds);
            } else {
                bounds = JGraphUI.this.getJGraph().fromScreen(bounds).getBounds();
                ArrayList list = new ArrayList();
                CellView[] views = JGraphUI.this.getJGraph().getGraphLayoutCache().getRoots();
                int i = 0;
                while (i < views.length) {
                    if (bounds.contains(views[i].getBounds())) {
                        list.add((JCell)views[i].getCell());
                    }
                    ++i;
                }
                this.selectCellsForEvent(list, evt);
            }
        }

        private void selectCellsForEvent(Collection<JCell<G>> cells, MouseEvent evt) {
            if (cells.isEmpty()) {
                JGraphUI.this.getJGraph().clearSelection();
            } else if (JGraphUI.this.isToggleSelectionEvent(evt)) {
                for (JCell jCell : cells) {
                    JGraphUI.this.toggleSelectionCellForEvent(jCell, evt);
                }
            } else if (JGraphUI.this.isAddToSelectionEvent(evt)) {
                JGraphUI.this.getJGraph().addSelectionCells(cells.toArray());
            } else {
                JGraphUI.this.getJGraph().setSelectionCells(cells.toArray());
            }
        }

        private JCell<G> getJCellAt(Point2D p) {
            return JGraphUI.this.getJGraph().getFirstCellForLocation(p.getX(), p.getY());
        }

        private JCell<G> getJVertexAt(Point2D p) {
            return JGraphUI.this.getJGraph().getFirstCellForLocation(p.getX(), p.getY(), true, false);
        }

        private JCell<G> getJEdgeAt(Point2D p) {
            return JGraphUI.this.getJGraph().getFirstCellForLocation(p.getX(), p.getY(), false, true);
        }

        private void doPan(MouseEvent e) {
            Point p = this.getViewPort().getViewPosition();
            p.x -= e.getX() - this.dragOrigX;
            p.y -= e.getY() - this.dragOrigY;
            Dimension size = JGraphUI.this.getJGraph().getSize();
            Dimension vsize = this.getViewPort().getExtentSize();
            if (p.x + vsize.width > size.width) {
                p.x = size.width - vsize.width;
            }
            if (p.y + vsize.height > size.height) {
                p.y = size.height - vsize.height;
            }
            if (p.x < 0) {
                p.x = 0;
            }
            if (p.y < 0) {
                p.y = 0;
            }
            this.getViewPort().setViewPosition(p);
        }

        private boolean isPanEnabled() {
            return JGraphUI.this.getJGraph().getMode() == JGraphMode.PAN_MODE && this.getViewPort() != null;
        }

        private boolean isEdgeAdding() {
            return this.edgeAdding;
        }

        private void startEdgeAdding(MouseEvent e) {
            this.edgeAdding = true;
            this.edgeAddStart = e;
            JGraphUI.this.getJGraph().setCursor(Cursor.getPredefinedCursor(1));
        }

        private void continueEdgeAdding(MouseEvent e) {
            if (this.edgeAddStart != null) {
                this.edgeHandler.mousePressed(e);
                this.edgeAddStart = null;
            }
            this.edgeHandler.mouseDragged(e);
        }

        private void cancelEdgeAdding(MouseEvent e) {
            if (this.edgeAdding) {
                this.edgeAdding = false;
                if (this.edgeAddStart == null) {
                    this.edgeHandler.mouseReleased(e);
                }
            }
            JGraphUI.this.getJGraph().setCursor(JGraphUI.this.getJGraph().getMode().getCursor());
        }

        private void finishEdgeAdding(MouseEvent e) {
            if (this.edgeHandler.edgeStart() != null && this.edgeHandler.edgeStart() != this.edgeHandler.edgeEnd()) {
                Rectangle2D start = this.edgeHandler.getScreenBounds(this.edgeHandler.edgeStart());
                Point point = e.getPoint();
                ((AspectJGraph)JGraphUI.this.getJGraph()).addEdge(new Point((int)start.getCenterX(), (int)start.getCenterY()), point);
            }
            this.edgeHandler.mouseReleased(e);
        }

        private JViewport getViewPort() {
            return JGraphUI.this.getJGraph().getViewPort();
        }
    }

    public static class RubberBand
    extends MouseInputAdapter {
        private boolean active;
        private final JComponent canvas;
        private final Rectangle bounds;
        private int pressX;
        private int pressY;

        public RubberBand(JComponent canvas) {
            this.canvas = canvas;
            this.bounds = new Rectangle();
        }

        public Rectangle getBounds() {
            return this.bounds.getBounds();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int tmp;
            int x = e.getX();
            int y = e.getY();
            int w = 0;
            int h = 0;
            if (this.pressX < x) {
                tmp = x;
                x = this.pressX;
                w = tmp - x;
            } else {
                w = this.pressX - x;
            }
            if (this.pressY < y) {
                tmp = y;
                y = this.pressY;
                h = tmp - y;
            } else {
                h = this.pressY - y;
            }
            this.update(x, y, w, h);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.isAllowed(e)) {
                this.pressX = e.getX();
                this.pressY = e.getY();
                this.bounds.setBounds(this.pressX, this.pressY, 0, 0);
                this.active = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.active) {
                if (this.bounds.width > 3 && this.bounds.height > 3) {
                    this.stopRubberBand(e);
                }
                this.update(-1, -1, 0, 0);
                this.canvas.removeMouseMotionListener(this);
                this.active = false;
            }
        }

        private void update(int x, int y, int width, int height) {
            Rectangle dirty = (Rectangle)this.bounds.clone();
            this.bounds.setBounds(x, y, width, height);
            dirty = dirty.union(this.bounds);
            --dirty.x;
            --dirty.y;
            dirty.height += 2;
            dirty.width += 2;
            this.canvas.repaint(dirty);
        }

        public void draw(Graphics g) {
            if (this.bounds.width >= 0) {
                Color oldColor = g.getColor();
                g.setColor(JAttr.RUBBER_FOREGROUND);
                g.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                g.setColor(JAttr.RUBBER_BACKGROUND);
                g.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                g.setColor(oldColor);
            }
        }

        protected boolean isAllowed(MouseEvent event) {
            return true;
        }

        protected void stopRubberBand(MouseEvent event) {
        }
    }
}

