/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.jgraph;

import groove.grammar.aspect.AspectKind;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.gui.Options;
import groove.gui.jgraph.AspectJCell;
import groove.gui.jgraph.AspectJModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.jgraph.JGraph;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.GraphCellEditor;

public class MultiLinedEditor
extends DefaultGraphCellEditor {
    public Component getGraphCellEditorComponent(JGraph graph, Object cell, boolean isSelected) {
        Component component = super.getGraphCellEditorComponent(graph, cell, isSelected);
        return component;
    }

    protected GraphCellEditor createGraphCellEditor() {
        return new RealCellEditor();
    }

    protected Container createContainer() {
        return new ModifiedEditorContainer();
    }

    final Component getEditingComponent() {
        return this.editingComponent;
    }

    private class ModifiedEditorContainer
    extends DefaultGraphCellEditor.EditorContainer {
        ModifiedEditorContainer() {
            super((DefaultGraphCellEditor)MultiLinedEditor.this);
        }

        public void doLayout() {
            if (MultiLinedEditor.this.getEditingComponent() != null) {
                Dimension size = MultiLinedEditor.this.getEditingComponent().getPreferredSize();
                int w = size.width + 3;
                int minw = 45;
                int maxw = MultiLinedEditor.this.getEditingComponent().getMaximumSize().width;
                if (this.getParent() != null && maxw > this.getParent().getWidth()) {
                    maxw = this.getParent().getWidth();
                }
                w = Math.max(minw, Math.min(w, maxw));
                MultiLinedEditor.this.getEditingComponent().setBounds(MultiLinedEditor.this.offsetX, MultiLinedEditor.this.offsetY, w, size.height);
                this.setSize(this.getPreferredSize());
            }
        }
    }

    private static class RealCellEditor
    extends AbstractCellEditor
    implements GraphCellEditor,
    CaretListener {
        private JTextArea editorComponent;
        private final SortedSet<String> labels = new TreeSet<String>();
        private LinkedList<String> completions = null;
        private static final String AUTOCOMPLETE_STRING = "autocomplete";
        private static final String NEWLINE_STRING = "newline";
        private static final String STOP_EDIT_STRING = "stop";
        private static final KeyStroke AUTOCOMPLETE_KEY;
        private static final KeyStroke NEWLINE_KEY_1;
        private static final KeyStroke NEWLINE_KEY_2;
        private static final KeyStroke STOP_EDIT_KEY_1;
        private static final KeyStroke STOP_EDIT_KEY_2;
        private static final List<String> prefixes;

        static {
            String prefix;
            AUTOCOMPLETE_KEY = KeyStroke.getKeyStroke(32, 128);
            NEWLINE_KEY_1 = KeyStroke.getKeyStroke(10, 64);
            NEWLINE_KEY_2 = KeyStroke.getKeyStroke(10, 128);
            STOP_EDIT_KEY_1 = KeyStroke.getKeyStroke(10, 0);
            STOP_EDIT_KEY_2 = KeyStroke.getKeyStroke(27, 0);
            prefixes = new LinkedList<String>();
            Enum[] enumArray = AspectKind.values();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                AspectKind aspectKind = enumArray[n2];
                prefix = aspectKind.getPrefix();
                if (prefix.length() > 1) {
                    prefixes.add(prefix);
                }
                ++n2;
            }
            enumArray = EdgeRole.values();
            n = enumArray.length;
            n2 = 0;
            while (n2 < n) {
                Enum edgeRole = enumArray[n2];
                prefix = ((EdgeRole)edgeRole).getPrefix();
                if (prefix.length() > 1) {
                    prefixes.add(prefix);
                }
                ++n2;
            }
        }

        private RealCellEditor() {
        }

        public Component getGraphCellEditorComponent(JGraph graph, Object value, boolean isSelected) {
            AspectJCell jCell = (AspectJCell)value;
            this.labels.clear();
            this.labels.addAll(prefixes);
            AspectJModel jmodel = (AspectJModel)graph.getModel();
            TypeGraph type = jmodel.getResourceModel().getGrammar().getTypeGraph();
            for (TypeLabel label : type.getLabels()) {
                this.labels.add(label.text());
            }
            JTextArea result = this.getEditorComponent();
            Font font = Options.LABEL_FONT.deriveFont(jCell.getVisuals().getFont());
            Font font2 = font = font != null ? font : graph.getFont();
            if (graph.getScale() != 1.0) {
                double scale = graph.getScale();
                Dimension size = result.getSize();
                size.height = (int)((double)size.height * scale);
                size.width = (int)((double)size.width * scale);
                result.setSize(size);
                font = font.deriveFont((float)((double)font.getSize() * scale));
            }
            result.setFont(font);
            String editString = ((AspectJCell)value).getUserObject().toEditString();
            result.setText(editString);
            result.selectAll();
            return result;
        }

        private Document getDocument() {
            return this.getEditorComponent().getDocument();
        }

        private JTextArea getEditorComponent() {
            if (this.editorComponent == null) {
                this.editorComponent = this.computeEditorComponent();
            }
            return this.editorComponent;
        }

        private JTextArea computeEditorComponent() {
            JTextArea result = new JTextArea();
            result.setBorder(UIManager.getBorder("Tree.editorBorder"));
            result.setWrapStyleWord(true);
            InputMap focusedInputMap = result.getInputMap(0);
            focusedInputMap.put(STOP_EDIT_KEY_1, STOP_EDIT_STRING);
            focusedInputMap.put(STOP_EDIT_KEY_2, STOP_EDIT_STRING);
            focusedInputMap.put(NEWLINE_KEY_1, NEWLINE_STRING);
            focusedInputMap.put(NEWLINE_KEY_2, NEWLINE_STRING);
            focusedInputMap.put(AUTOCOMPLETE_KEY, AUTOCOMPLETE_STRING);
            result.getActionMap().put(STOP_EDIT_STRING, new StopEditAction());
            result.getActionMap().put(NEWLINE_STRING, new NewlineAction());
            result.getActionMap().put(AUTOCOMPLETE_STRING, new AutocompleteAction());
            result.addCaretListener(this);
            return result;
        }

        @Override
        public Object getCellEditorValue() {
            return this.getEditorComponent().getText();
        }

        @Override
        public boolean shouldSelectCell(EventObject event) {
            this.getEditorComponent().requestFocus();
            return super.shouldSelectCell(event);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.resetAutocomplete();
        }

        private String getNextCompletion() {
            String result;
            if (this.completions == null) {
                this.completions = this.computeCompletions();
            }
            if ((result = this.completions.poll()) != null) {
                this.completions.add(result);
            }
            return result;
        }

        private LinkedList<String> computeCompletions() {
            String root;
            SortedSet<String> tailSet;
            String content;
            LinkedList<String> result = new LinkedList<String>();
            Caret caret = this.getEditorComponent().getCaret();
            int dot = caret.getDot();
            int mark = caret.getMark();
            int min = Math.min(dot, mark);
            int max = Math.max(dot, mark);
            try {
                Document document = this.getDocument();
                if (max < document.getLength() && Character.isLetterOrDigit(document.getText(max, 1).charAt(0))) {
                    return result;
                }
                content = document.getText(0, min);
            }
            catch (BadLocationException exc) {
                throw new IllegalStateException(String.format("Impossible error: %s", exc));
            }
            int start = min;
            while (start > 0 && Character.isLetterOrDigit(content.charAt(start - 1))) {
                --start;
            }
            if (start < min && !(tailSet = this.labels.tailSet(root = content.substring(start))).isEmpty()) {
                Iterator iter = tailSet.iterator();
                String nextCompletion = (String)iter.next();
                while (nextCompletion.startsWith(root)) {
                    result.add(nextCompletion.substring(min - start));
                    nextCompletion = (String)iter.next();
                }
            }
            return result;
        }

        private void resetAutocomplete() {
            this.completions = null;
        }

        private void doAutocomplete() {
            String completion = this.getNextCompletion();
            if (completion != null) {
                SwingUtilities.invokeLater(new CompletionTask(completion));
            }
        }

        private class AutocompleteAction
        extends AbstractAction {
            private AutocompleteAction() {
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                RealCellEditor.this.doAutocomplete();
            }
        }

        private class CompletionTask
        implements Runnable {
            private final String completion;

            CompletionTask(String completion) {
                this.completion = completion;
            }

            @Override
            public void run() {
                RealCellEditor.this.getEditorComponent().removeCaretListener(RealCellEditor.this);
                Caret caret = RealCellEditor.this.getEditorComponent().getCaret();
                int pos = Math.min(caret.getDot(), caret.getMark());
                RealCellEditor.this.getEditorComponent().replaceSelection(this.completion);
                RealCellEditor.this.getEditorComponent().setCaretPosition(pos);
                RealCellEditor.this.getEditorComponent().moveCaretPosition(pos + this.completion.length());
                RealCellEditor.this.getEditorComponent().addCaretListener(RealCellEditor.this);
            }
        }

        private class NewlineAction
        extends AbstractAction {
            private NewlineAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RealCellEditor.this.getDocument().insertString(RealCellEditor.this.getEditorComponent().getCaretPosition(), "\n", null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
            }
        }

        private class StopEditAction
        extends AbstractAction {
            private StopEditAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RealCellEditor.this.stopCellEditing();
            }
        }
    }
}

