/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.layout;

import groove.gui.jgraph.JAttr;
import groove.gui.layout.JCellLayout;
import groove.gui.look.VisualMap;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.GraphConstants;

public class JVertexLayout
implements JCellLayout {
    private final Rectangle2D bounds;

    public static JVertexLayout newInstance(AttributeMap jAttr) {
        Rectangle2D bounds = GraphConstants.getBounds((Map)jAttr);
        if (bounds == null) {
            bounds = new Rectangle(JAttr.DEFAULT_NODE_BOUNDS);
        }
        return new JVertexLayout(bounds);
    }

    public static JVertexLayout newInstance(VisualMap visuals) {
        Dimension2D size = visuals.getNodeSize();
        Point2D pos = visuals.getNodePos();
        return new JVertexLayout(new Rectangle2D.Double(pos.getX() - size.getWidth() / 2.0, pos.getY() - size.getHeight() / 2.0, size.getWidth(), size.getHeight()));
    }

    public static boolean isDefaultNodeLocation(double x, double y) {
        return defaultNodeLocation.getX() == x && defaultNodeLocation.getY() == y;
    }

    public JVertexLayout(Rectangle2D bounds) {
        this.bounds = (Rectangle2D)bounds.clone();
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.bounds.clone();
    }

    @Override
    public VisualMap toVisuals() {
        VisualMap result = new VisualMap();
        if (this.bounds != null) {
            result.setNodePos(new Point2D.Double(this.bounds.getCenterX(), this.bounds.getCenterY()));
        }
        return result;
    }

    @Override
    public AttributeMap toJAttr() {
        AttributeMap result = new AttributeMap();
        if (this.bounds != null) {
            GraphConstants.setBounds((Map)result, (Rectangle2D)this.bounds);
        }
        return result;
    }

    @Override
    public boolean isDefault() {
        return JVertexLayout.isDefaultNodeLocation(this.getBounds().getX(), this.getBounds().getY());
    }

    public boolean equals(Object obj) {
        if (obj instanceof JVertexLayout) {
            JVertexLayout other = (JVertexLayout)obj;
            return this.getBounds().equals(other.getBounds());
        }
        return false;
    }

    public int hashCode() {
        return this.getBounds().hashCode();
    }

    public String toString() {
        return "Bounds=" + this.getBounds();
    }
}

