/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.list;

import groove.grammar.model.ResourceKind;
import groove.graph.Element;
import groove.gui.look.Values;
import groove.io.HTMLConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ListPanel
extends JPanel {
    private JList entryArea;
    private JLabel title;

    public ListPanel(String title) {
        super(new BorderLayout());
        if (title != null) {
            this.add((Component)this.getTitle(title), "North");
        }
        JScrollPane scrollPane = new JScrollPane(this.getEntryArea());
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setPreferredSize(new Dimension(0, 70));
        this.add(scrollPane);
        this.setVisible(false);
    }

    public void setEntries(Collection<? extends SelectableListEntry> entries) {
        this.getEntryArea().setListData(entries.toArray());
        this.setVisible(!entries.isEmpty());
    }

    public void clearEntries() {
        this.getEntryArea().setListData(Collections.emptySet().toArray());
        this.setVisible(false);
    }

    public void addSelectionListener(final Observer listener) {
        this.getEntryArea().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                listener.update(null, ListPanel.this.getEntryArea().getSelectedValue());
            }
        });
        this.getEntryArea().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = ListPanel.this.getIndexAt(e.getPoint());
                if (index >= 0 && ListPanel.this.getEntryArea().isSelectedIndex(index)) {
                    listener.update(null, ListPanel.this.getEntryArea().getSelectedValue());
                }
            }
        });
    }

    public SelectableListEntry getSelectedEntry() {
        return (SelectableListEntry)this.getEntryArea().getSelectedValue();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getContentSize() == 0) {
            return new Dimension();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.getContentSize() == 0) {
            return new Dimension();
        }
        return super.getMaximumSize();
    }

    public boolean hasContent() {
        return this.getContentSize() > 0;
    }

    private int getContentSize() {
        return this.getEntryArea().getModel().getSize();
    }

    private JList getEntryArea() {
        if (this.entryArea == null) {
            JList<Object> result = this.entryArea = new JList<Object>();
            result.setBackground(this.getColors().getBackground(Values.Mode.NONE));
            result.setForeground(this.getColors().getForeground(Values.Mode.NONE));
            result.setSelectionBackground(this.getColors().getBackground(Values.Mode.FOCUSED));
            result.setSelectionForeground(this.getColors().getBackground(Values.Mode.FOCUSED));
            result.setSelectionMode(0);
            result.setCellRenderer(new CellRenderer());
        }
        return this.entryArea;
    }

    private JLabel getTitle(String text) {
        if (this.title == null) {
            this.title = new JLabel(HTMLConverter.HTML_TAG.on(HTMLConverter.STRONG_TAG.on(text)));
        }
        return this.title;
    }

    private int getIndexAt(Point point) {
        int result = this.getEntryArea().locationToIndex(point);
        Rectangle cellBounds = this.getEntryArea().getCellBounds(result, result);
        boolean cellSelected = cellBounds != null && cellBounds.contains(point);
        return cellSelected ? result : -1;
    }

    protected abstract Values.ColorSet getColors();

    private class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component result = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, false);
            Values.Mode mode = cellHasFocus ? Values.Mode.FOCUSED : (isSelected ? Values.Mode.SELECTED : Values.Mode.NONE);
            result.setBackground(ListPanel.this.getColors().getBackground(mode));
            result.setForeground(ListPanel.this.getColors().getForeground(mode));
            return result;
        }
    }

    public static interface SelectableListEntry {
        public ResourceKind getResourceKind();

        public String getResourceName();

        public List<Element> getElements();
    }
}

