/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.look;

import groove.gui.jgraph.JAttr;
import groove.util.Colors;
import groove.util.DefaultFixable;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Map;

public class Values {
    public static final float[] ABSENT_DASH = new float[]{3.0f, 3.0f};
    public static final float[] ABSTRACT_DASH = new float[]{6.0f, 2.0f};
    public static final float[] CONNECT_DASH = new float[]{2.0f, 4.0f};
    public static final float[] EMBARGO_DASH = new float[]{2.0f, 2.0f};
    public static final float[] ERASER_DASH = new float[]{4.0f, 4.0f};
    public static final float[] NESTED_DASH = new float[]{2.0f, 3.0f};
    public static final float[] NO_DASH = new float[]{10.0f, 0.0f};
    public static final Color CREATOR_FOREGROUND = Color.green.darker();
    public static final Color CREATOR_BACKGROUND = null;
    public static final Color DEFAULT_FOREGROUND = Color.black;
    public static final Color DEFAULT_BACKGROUND = Colors.findColor("243 243 243");
    public static final Color EMBARGO_FOREGROUND = Color.RED;
    public static final Color EMBARGO_BACKGROUND = null;
    public static final Color ERASER_FOREGROUND = Color.BLUE;
    public static final Color ERASER_BACKGROUND = Colors.findColor("200 240 255");
    public static final Color REMARK_FOREGROUND = Colors.findColor("255 140 0");
    public static final Color REMARK_BACKGROUND = Colors.findColor("255 255 180");
    public static final Color OPEN_BACKGROUND = Color.GRAY.brighter();
    public static final Color FINAL_BACKGROUND = Color.RED;
    public static final Color RESULT_BACKGROUND = Colors.findColor("255 165 0");
    public static final Color START_BACKGROUND = Color.BLACK;
    public static final Color START_OPEN_BACKGROUND = Color.GRAY.darker();
    public static final Color START_FOREGROUND = JAttr.STATE_BACKGROUND;
    public static final Color ACTIVE_COLOR = Color.BLUE;
    public static final Color ACTIVE_START_COLOR = Colors.findColor("30 190 255");
    public static final Color TRANSIENT_COLOR = Colors.findColor("165 42 42");
    public static final Color TRANSIENT_ACTIVE_COLOR = Colors.findColor("165 42 149");
    public static final Color FOCUS_BACKGROUND = Color.DARK_GRAY;
    public static final Color FOCUS_FOREGROUND = Color.WHITE;
    public static final Color SELECT_BACKGROUND = Color.LIGHT_GRAY;
    public static final Color SELECT_FOREGROUND = Color.BLACK;
    public static final Color NORMAL_BACKGROUND = Color.WHITE;
    public static final Color NORMAL_FOREGROUND = Color.BLACK;
    public static final ColorSet NORMAL_COLORS = new ColorSet();
    public static final Color ERROR_COLOR;
    public static final Color ERROR_FOCUS_BACKGROUND;
    public static final Color ERROR_FOCUS_FOREGROUND;
    public static final Color ERROR_SELECT_BACKGROUND;
    public static final Color ERROR_SELECT_FOREGROUND;
    public static final Color ERROR_NORMAL_BACKGROUND;
    public static final Color ERROR_NORMAL_FOREGROUND;
    public static final ColorSet ERROR_COLORS;
    public static final ColorSet TRANSIENT_COLORS;
    public static final int STYLE_MANHATTAN = 14;

    static {
        NORMAL_COLORS.putColors(Mode.FOCUSED, FOCUS_FOREGROUND, FOCUS_BACKGROUND);
        NORMAL_COLORS.putColors(Mode.SELECTED, SELECT_FOREGROUND, SELECT_BACKGROUND);
        NORMAL_COLORS.putColors(Mode.NONE, NORMAL_FOREGROUND, NORMAL_BACKGROUND);
        ERROR_COLOR = new Color(255, 50, 0, 40);
        ERROR_FOCUS_BACKGROUND = Color.RED.darker().darker();
        ERROR_FOCUS_FOREGROUND = Color.WHITE;
        ERROR_SELECT_BACKGROUND = ERROR_COLOR;
        ERROR_SELECT_FOREGROUND = Color.RED;
        ERROR_NORMAL_BACKGROUND = Color.WHITE;
        ERROR_NORMAL_FOREGROUND = Color.RED;
        ERROR_COLORS = new ColorSet();
        ERROR_COLORS.putColors(Mode.FOCUSED, ERROR_FOCUS_FOREGROUND, ERROR_FOCUS_BACKGROUND);
        ERROR_COLORS.putColors(Mode.SELECTED, ERROR_SELECT_FOREGROUND, ERROR_SELECT_BACKGROUND);
        ERROR_COLORS.putColors(Mode.NONE, ERROR_NORMAL_FOREGROUND, ERROR_NORMAL_BACKGROUND);
        TRANSIENT_COLORS = new ColorSet();
        TRANSIENT_COLORS.putColors(Mode.FOCUSED, Color.WHITE, TRANSIENT_COLOR.darker());
        TRANSIENT_COLORS.putColors(Mode.SELECTED, TRANSIENT_COLOR.darker(), SELECT_BACKGROUND);
        TRANSIENT_COLORS.putColors(Mode.NONE, TRANSIENT_COLOR, NORMAL_BACKGROUND);
    }

    public static class ColorSet
    extends DefaultFixable {
        private final Map<Mode, Color> foreColors = new EnumMap<Mode, Color>(Mode.class);
        private final Map<Mode, Color> backColors = new EnumMap<Mode, Color>(Mode.class);

        public void putColors(Mode mode, Color foreground, Color background) {
            this.testFixed(false);
            Color oldFore = this.foreColors.put(mode, foreground);
            assert (oldFore == null);
            Color oldBack = this.backColors.put(mode, background);
            assert (oldBack == null);
            if (this.foreColors.size() == Mode.values().length) {
                this.setFixed();
            }
        }

        public Color getForeground(boolean selected, boolean focused) {
            return this.getColor(this.foreColors, selected, focused);
        }

        public Color getForeground(Mode mode) {
            return this.foreColors.get((Object)mode);
        }

        public Color getBackground(boolean selected, boolean focused) {
            return this.getColor(this.backColors, selected, focused);
        }

        public Color getBackground(Mode mode) {
            return this.backColors.get((Object)mode);
        }

        private Color getColor(Map<Mode, Color> colors, boolean selected, boolean focused) {
            return colors.get((Object)Mode.toMode(selected, focused));
        }
    }

    public static enum Mode {
        FOCUSED,
        SELECTED,
        NONE;


        public static Mode toMode(boolean selected, boolean focused) {
            if (focused) {
                return FOCUSED;
            }
            if (selected) {
                return SELECTED;
            }
            return NONE;
        }
    }
}

