/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.menu;

import groove.explore.StrategyValue;
import groove.gui.Simulator;
import groove.gui.SimulatorListener;
import groove.gui.SimulatorModel;
import groove.gui.action.CheckLTLAction;
import groove.gui.action.SimulatorAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ModelCheckingMenu
extends JMenu
implements SimulatorListener {
    protected final Simulator simulator;
    private final Map<StrategyValue, SimulatorAction> scenarioActionMap = new HashMap<StrategyValue, SimulatorAction>();

    public ModelCheckingMenu(Simulator simulator) {
        super("Verify");
        this.simulator = simulator;
        this.createAddMenuItems();
        this.refreshActions(true);
        simulator.getModel().addListener(this, SimulatorModel.Change.GTS);
    }

    protected void createAddMenuItems() {
        this.addScenarioHandler(StrategyValue.LTL, "Check LTL property (full state space)");
        this.addScenarioHandler(StrategyValue.LTL_BOUNDED, "Check LTL property (bounded state space)");
        this.addScenarioHandler(StrategyValue.LTL_POCKET, "Check LTL property (bounded pocket strategy)");
    }

    public void addScenarioHandler(StrategyValue strategyType, String name) {
        CheckLTLAction generateAction = new CheckLTLAction(this.simulator, strategyType, name);
        generateAction.setEnabled(false);
        this.scenarioActionMap.put(strategyType, generateAction);
        JMenuItem menuItem = this.add(generateAction);
        menuItem.setToolTipText(strategyType.getDescription());
    }

    @Override
    public void update(SimulatorModel source, SimulatorModel oldModel, Set<SimulatorModel.Change> changes) {
        if (changes.contains((Object)SimulatorModel.Change.GTS)) {
            this.refreshActions(source.getGts() != null);
        }
    }

    private void refreshActions(boolean enabled) {
        for (Action action : this.scenarioActionMap.values()) {
            action.setEnabled(enabled);
        }
    }
}

