/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.menu;

import groove.automaton.NodeRelation;
import groove.automaton.RegExpr;
import groove.automaton.RelationCalculator;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.Graph;
import groove.graph.Label;
import groove.gui.dialog.StringDialog;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JEdge;
import groove.gui.jgraph.JGraph;
import groove.gui.jgraph.JVertex;
import groove.gui.jgraph.LTSJGraph;
import groove.gui.jgraph.LTSJModel;
import groove.io.FileType;
import groove.io.GrooveFileChooser;
import groove.io.HTMLConverter;
import groove.lts.GTS;
import groove.lts.GraphState;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

public class ShowHideMenu<G extends Graph>
extends JMenu {
    protected static final int ADD_MODE = 0;
    protected static final int HIDE_MODE = 1;
    protected static final int ONLY_MODE = 2;
    public static final String HIDE_MODE_NAME = "Hide";
    public static final String ADD_MODE_NAME = "Add";
    protected static final String ONLY_MODE_NAME = "Show";
    public static final String ALL_ACTION_NAME = "All";
    public static final String SELECTED_ACTION_NAME = "Selected";
    public static final String INVERT_ACTION_NAME = "Inverse";
    public static final String CONTEXT_ACTION_NAME = "Context";
    public static final String REGEXPR_ACTION_NAME = "Pattern...";
    public static final String FILE_ACTION_NAME = "All From File...";
    public static final String LABEL_MENU_NAME = "Label";
    public static final String TRACE_ACTION_NAME = "Trace From Start State";
    private final JGraph<G> jgraph;
    private static int ALL_MNEMONIC = 65;
    private static int EMPHASIZED_MNEMONIC = 69;
    private static int CONTEXT_MNEMONIC = 67;
    private static int REG_EXPR_MNEMONIC = 80;
    private static int FILE_MNEMONIC = 70;
    private static int TRACE_MNEMONIC = 84;
    private static int MENU_MNEMONIC = 83;

    public static String getModeName(int showMode) {
        switch (showMode) {
            case 0: {
                return ADD_MODE_NAME;
            }
            case 2: {
                return ONLY_MODE_NAME;
            }
        }
        return HIDE_MODE_NAME;
    }

    public ShowHideMenu(JGraph<G> jgraph) {
        super("Show/Hide");
        this.setMnemonic(MENU_MNEMONIC);
        this.jgraph = jgraph;
        this.fillOutMenu(this.getPopupMenu());
    }

    protected void fillOutMenu(JPopupMenu menu) {
        menu.add(this.createAllAction(2));
        menu.add(this.createSelectedAction(2));
        menu.add(this.createShowRegExprAction(2));
        menu.add(this.createContextAction(0));
        if (this.jgraph instanceof LTSJGraph) {
            menu.add(this.createTraceAction(2));
        }
        menu.add(this.createFromFileAction(2));
        menu.addSeparator();
        menu.add(this.createSelectedAction(0));
        menu.add(this.createAddRegExprAction(0));
        menu.add(this.createContextAction(0));
        menu.add(this.createLabelMenu(0));
        menu.addSeparator();
        menu.add(this.createAllAction(1));
        menu.add(this.createSelectedAction(1));
        menu.add(this.createAddRegExprAction(1));
        menu.add(this.createLabelMenu(1));
    }

    protected ShowHideAction<G> createAllAction(int showMode) {
        return new AllAction<G>(this.jgraph, showMode);
    }

    protected ShowHideAction<G> createInvertAction(int showMode) {
        return new InvertAction<G>(this.jgraph, showMode);
    }

    protected ShowHideAction<G> createAddRegExprAction(int showMode) {
        return new RegExprAction<G>(this.jgraph, showMode);
    }

    protected ShowHideAction<G> createShowRegExprAction(int showMode) {
        return new RegExprAction<G>(this.jgraph, showMode);
    }

    protected ShowHideAction<G> createContextAction(int showMode) {
        return new ContextAction<G>(this.jgraph, showMode);
    }

    protected ShowHideAction<G> createSelectedAction(int showMode) {
        return new SelectedAction<G>(this.jgraph, showMode);
    }

    protected ShowHideAction<G> createFromFileAction(int showMode) {
        return new FromFileAction<G>(this.jgraph, showMode);
    }

    protected ShowHideAction<GTS> createTraceAction(int showMode) {
        return new TraceAction((LTSJGraph)this.jgraph, showMode);
    }

    protected ShowHideAction<G> createLabelAction(int showMode, Label label) {
        return new LabelAction<G>(this.jgraph, showMode, label);
    }

    protected JMenu createLabelMenu(int showMode) {
        return new LabelMenu(showMode);
    }

    JGraph<G> getJGraph() {
        return this.jgraph;
    }

    protected static class AllAction<G extends Graph>
    extends ShowHideAction<G> {
        protected AllAction(JGraph<G> jgraph, int showMode) {
            super(jgraph, showMode, ShowHideMenu.ALL_ACTION_NAME);
            this.putValue("MnemonicKey", ALL_MNEMONIC);
        }

        @Override
        protected boolean isInvolved(JCell<G> cell) {
            return true;
        }
    }

    protected static class ContextAction<G extends Graph>
    extends ShowHideAction<G> {
        protected ContextAction(JGraph<G> jgraph, int showMode) {
            super(jgraph, showMode, ShowHideMenu.CONTEXT_ACTION_NAME);
            assert (showMode != 1) : "Hiding not defined for context";
            this.putValue("MnemonicKey", CONTEXT_MNEMONIC);
        }

        @Override
        protected boolean isInvolved(JCell<G> cell) {
            boolean result = false;
            if (cell instanceof JEdge) {
                HashSet<Object> selectedCells;
                JEdge edge = (JEdge)cell;
                JVertex sourceVertex = edge.getSourceVertex();
                JVertex targetVertex = edge.getTargetVertex();
                Object[] selectedCellArray = this.jgraph.getSelectionCells();
                result = selectedCellArray.length == 0 ? !sourceVertex.isGrayedOut() || !targetVertex.isGrayedOut() : (selectedCells = new HashSet<Object>(Arrays.asList(selectedCellArray))).contains(sourceVertex) || selectedCells.contains(targetVertex);
            }
            return result;
        }
    }

    protected static class FromFileAction<G extends Graph>
    extends ShowHideAction<G> {
        private Set<String> labels;

        public FromFileAction(JGraph<G> jgraph, int showMode) {
            super(jgraph, showMode, ShowHideMenu.FILE_ACTION_NAME);
            this.putValue("MnemonicKey", FILE_MNEMONIC);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            GrooveFileChooser fileChooser = GrooveFileChooser.getFileChooser(FileType.TEXT_FILTER);
            int result = fileChooser.showOpenDialog((Component)((Object)this.jgraph));
            if (result == 0) {
                File labelsFile = fileChooser.getSelectedFile();
                HashSet<String> labels = new HashSet<String>();
                try {
                    BufferedReader in = new BufferedReader(new FileReader(labelsFile));
                    if (!in.ready()) {
                        in.close();
                        throw new IOException();
                    }
                    while (true) {
                        String fileLine;
                        if ((fileLine = in.readLine()) == null) {
                            in.close();
                            break;
                        }
                        labels.add(fileLine);
                    }
                }
                catch (IOException iOException) {}
                this.labels = labels;
                super.actionPerformed(evt);
            }
        }

        @Override
        protected boolean isInvolved(JCell<G> jCell) {
            boolean result = false;
            for (Label label : jCell.getKeys()) {
                result = this.labels.contains(label.text());
                if (result) break;
            }
            return result;
        }
    }

    protected static class InvertAction<G extends Graph>
    extends ShowHideAction<G> {
        protected InvertAction(JGraph<G> jgraph, int showMode) {
            super(jgraph, showMode, ShowHideMenu.INVERT_ACTION_NAME);
        }

        @Override
        protected boolean isInvolved(JCell<G> cell) {
            return !cell.isGrayedOut();
        }
    }

    protected static class LabelAction<G extends Graph>
    extends ShowHideAction<G> {
        private final Label label;

        protected LabelAction(JGraph<G> jgraph, int showMode, Label label) throws IllegalArgumentException {
            super(jgraph, showMode, "");
            this.putValue("Name", label.text().length() == 0 ? "(empty)" : HTMLConverter.HTML_TAG.on(TypeLabel.toHtmlString(label)));
            this.label = label;
        }

        @Override
        protected boolean isInvolved(JCell<G> cell) {
            return cell.getKeys().contains(this.label);
        }
    }

    protected class LabelMenu
    extends JMenu {
        private final int showMode;

        protected LabelMenu(int showMode) {
            super(String.valueOf(ShowHideMenu.getModeName(showMode)) + " " + ShowHideMenu.LABEL_MENU_NAME);
            this.showMode = showMode;
        }

        @Override
        public void menuSelectionChanged(boolean isIncluded) {
            if (isIncluded) {
                this.removeAll();
                for (Label labelAction : ShowHideMenu.this.getJGraph().getLabelTree().getLabels()) {
                    this.add(new LabelAction(ShowHideMenu.this.getJGraph(), this.showMode, labelAction));
                }
            }
            super.menuSelectionChanged(isIncluded);
        }
    }

    protected static class RegExprAction<G extends Graph>
    extends ShowHideAction<G> {
        private Collection<Element> elementSet;
        private RelationCalculator calculator;
        private static StringDialog exprDialog = StringDialog.createStringDialog("Regular Expression: ");

        protected RegExprAction(JGraph<G> jgraph, int showMode) {
            super(jgraph, showMode, ShowHideMenu.REGEXPR_ACTION_NAME);
            this.putValue("MnemonicKey", REG_EXPR_MNEMONIC);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Graph graph = this.jgraph.getModel().getGraph();
            String exprText = exprDialog.showDialog(null);
            if (exprText != null) {
                try {
                    RegExpr expr = RegExpr.parse(exprText);
                    if (expr != null) {
                        if (this.calculator == null || this.calculator.getGraph() != graph) {
                            if (this.calculator != null) {
                                this.calculator.stopListening();
                            }
                            this.calculator = new RelationCalculator(graph, new NodeRelation());
                            this.calculator.startListening();
                        }
                        NodeRelation rel = expr.apply(this.calculator);
                        this.elementSet = rel.getSupport();
                    }
                    super.actionPerformed(evt);
                }
                catch (FormatException exc) {
                    JOptionPane.showMessageDialog(null, "Error in regular expression '" + exprText + "': " + exc.getMessage());
                }
            }
        }

        @Override
        protected boolean isInvolved(JCell<G> cell) {
            Set<Edge> edgesInCell = cell.getEdges();
            boolean edgeFound = false;
            Iterator<Edge> edgeInCellIter = edgesInCell.iterator();
            while (!edgeFound && edgeInCellIter.hasNext()) {
                edgeFound = this.elementSet.contains(edgeInCellIter.next());
            }
            return edgeFound;
        }
    }

    protected static class SelectedAction<G extends Graph>
    extends ShowHideAction<G> {
        public SelectedAction(JGraph<G> jgraph, int showMode) {
            super(jgraph, showMode, ShowHideMenu.SELECTED_ACTION_NAME);
            this.putValue("MnemonicKey", EMPHASIZED_MNEMONIC);
        }

        @Override
        protected boolean isInvolved(JCell<G> jCell) {
            return this.jgraph.getSelectionModel().isCellSelected(jCell);
        }
    }

    protected static abstract class ShowHideAction<G extends Graph>
    extends AbstractAction {
        protected final JGraph<G> jgraph;
        protected final int showMode;

        protected ShowHideAction(JGraph<G> jgraph, int showMode, String name) {
            super(String.valueOf(ShowHideMenu.getModeName(showMode)) + " " + name);
            this.jgraph = jgraph;
            this.showMode = showMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashSet<JCell<G>> hiddenCells = new HashSet<JCell<G>>();
            HashSet<JCell<G>> shownCells = new HashSet<JCell<G>>();
            for (JCell<G> jCell : this.jgraph.getModel().getRoots()) {
                if (this.isHiding(jCell)) {
                    hiddenCells.add(jCell);
                    continue;
                }
                if (!this.isShowing(jCell)) continue;
                shownCells.add(jCell);
            }
            if (this.getShowMode() != 1) {
                this.setHidden(hiddenCells, true);
                this.setHidden(shownCells, false);
            } else {
                this.setHidden(shownCells, false);
                this.setHidden(hiddenCells, true);
            }
            this.jgraph.repaint();
        }

        public int getShowMode() {
            return this.showMode;
        }

        protected boolean isHiding(JCell<G> jCell) {
            boolean involved = this.isInvolved(jCell);
            return involved && this.getShowMode() == 1 || !involved && this.getShowMode() == 2;
        }

        protected boolean isShowing(JCell<G> jCell) {
            return this.isInvolved(jCell) && this.getShowMode() != 1;
        }

        protected final void setHidden(Set<JCell<G>> cells, boolean hidden) {
            this.jgraph.changeGrayedOut(cells, hidden);
        }

        protected abstract boolean isInvolved(JCell<G> var1);
    }

    protected static class TraceAction
    extends ShowHideAction<GTS> {
        private Set<JCell<GTS>> trace;

        public TraceAction(LTSJGraph jgraph, int showMode) {
            super(jgraph, showMode, ShowHideMenu.TRACE_ACTION_NAME);
            this.putValue("MnemonicKey", TRACE_MNEMONIC);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            HashSet<GraphState> states = new HashSet<GraphState>();
            LTSJGraph jGraph = (LTSJGraph)this.jgraph;
            states.add(jGraph.getActiveState());
            this.trace = jGraph.findTraces(states);
            LTSJModel model = jGraph.getModel();
            if (model != null) {
                super.actionPerformed(evt);
            }
        }

        @Override
        protected boolean isInvolved(JCell<GTS> jCell) {
            return this.trace.contains(jCell);
        }
    }
}

