/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.tree;

import groove.gui.tree.RecipeTreeNode;
import groove.util.Strings;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DisplayTreeNode
extends DefaultMutableTreeNode {
    private final Comparator<TreeNode> comparator = new ChildComparator();

    DisplayTreeNode() {
    }

    protected DisplayTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public Icon getIcon() {
        return null;
    }

    public boolean isError() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getText() {
        return this.toString();
    }

    public String getTip() {
        return null;
    }

    public void insertSorted(MutableTreeNode child) {
        Comparator<TreeNode> comparator = this.comparator;
        int lower = 0;
        int upper = this.getChildCount();
        while (lower < upper) {
            int mid = (lower + upper) / 2;
            TreeNode midChild = this.getChildAt(mid);
            if (comparator.compare(child, midChild) < 0) {
                upper = mid;
                continue;
            }
            lower = mid + 1;
        }
        this.insert(child, lower);
    }

    private static class ChildComparator
    implements Comparator<TreeNode> {
        private static final Comparator<String> stringComparator = Strings.getNaturalComparator();

        private ChildComparator() {
        }

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof RecipeTreeNode) {
                if (!(o2 instanceof RecipeTreeNode)) {
                    return -1;
                }
            } else if (o2 instanceof RecipeTreeNode) {
                return 1;
            }
            return stringComparator.compare(o1.toString(), o2.toString());
        }
    }
}

